/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.client.web.admin;

import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import org.bedework.appcommon.client.Client;
import org.bedework.calfacade.configs.SystemProperties;
import org.bedework.client.admin.AdminClient;
import org.bedework.client.web.rw.BwRWWebGlobals;

public class BwAdminWebGlobals
extends BwRWWebGlobals {
    private boolean superUser;
    private String currentTab = "main";
    private boolean suggestionEnabled;
    private boolean workflowEnabled;
    private String workflowRoot;
    private String encodedWorkflowRoot;
    private boolean oneGroup;
    private String adminGroupName;
    private boolean userMaintOK;
    private boolean adminGroupMaintOK;
    private boolean curUserContentAdminUser;
    private boolean curUserApproverUser;

    public boolean isSuperUser() {
        return this.superUser;
    }

    public void assignCurrentTab(String val) {
        this.currentTab = val;
    }

    public String getCurrentTab() {
        return this.currentTab;
    }

    public boolean getSuggestionEnabled() {
        return this.suggestionEnabled;
    }

    public boolean getWorkflowEnabled() {
        return this.workflowEnabled;
    }

    public String getWorkflowRoot() {
        return this.workflowRoot;
    }

    public String getEncodedWorkflowRoot() {
        return this.encodedWorkflowRoot;
    }

    public boolean getOneGroup() {
        return this.oneGroup;
    }

    public String getAdminGroupName() {
        return this.adminGroupName;
    }

    public boolean getUserMaintOK() {
        return this.userMaintOK;
    }

    public boolean getAdminGroupMaintOK() {
        return this.adminGroupMaintOK;
    }

    public void assignCurUserContentAdminUser(boolean val) {
        this.curUserContentAdminUser = val;
    }

    public boolean getCurUserContentAdminUser() {
        return this.curUserContentAdminUser;
    }

    public void assignCurUserApproverUser(boolean val) {
        this.curUserApproverUser = val;
    }

    public boolean getCurUserApproverUser() {
        return this.curUserApproverUser;
    }

    public void reset(Client cl) {
        AdminClient adcl = (AdminClient)cl;
        this.superUser = cl.isSuperUser();
        super.reset(cl);
        SystemProperties sysprops = cl.getSystemProperties();
        this.suggestionEnabled = sysprops.getSuggestionEnabled();
        this.workflowEnabled = sysprops.getWorkflowEnabled();
        this.workflowRoot = sysprops.getWorkflowRoot();
        if (this.workflowRoot != null) {
            this.encodedWorkflowRoot = URLEncoder.encode(this.workflowRoot, StandardCharsets.UTF_8);
        }
        this.oneGroup = adcl.getOneGroup();
        this.adminGroupName = adcl.getAdminGroupName();
        this.userMaintOK = adcl.getUserMaintOK();
        this.adminGroupMaintOK = adcl.getAdminGroupMaintOK();
    }
}

