/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.client.web.admin;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bedework.calfacade.exc.CalFacadeException;
import org.bedework.calfacade.indexing.BwIndexer;
import org.bedework.client.admin.AdminClient;
import org.bedework.client.web.admin.BwAdminWebGlobals;
import org.bedework.webcommon.BwRequest;
import org.bedework.webcommon.RenderMainAction;

public class ShowCurrentTabAction
extends RenderMainAction {
    private static final Map<String, Integer> forwardsTab = new HashMap<String, Integer>();
    private final List<Integer> eventSearchTab = Arrays.asList(48, 49, 50, 51);

    public int doAction(BwRequest request) {
        Integer fwd;
        BwAdminWebGlobals globals = (BwAdminWebGlobals)request.getBwGlobals();
        request.refresh();
        AdminClient cl = (AdminClient)request.getClient();
        if (!cl.isApprover()) {
            globals.assignCurrentTab("approvalQueue");
        }
        if ((fwd = forwardsTab.get(globals.getCurrentTab())) == null) {
            throw new CalFacadeException("No forward - tab not defined: " + globals.getCurrentTab());
        }
        if (this.eventSearchTab.contains(fwd)) {
            int sfwd = super.doAction(request);
            if (sfwd != 0) {
                return sfwd;
            }
            request.setRequestAttr("bw_search_list", (Object)cl.getSearchResult(BwIndexer.Position.current));
        }
        return fwd;
    }

    static {
        forwardsTab.put("main", 48);
        forwardsTab.put("approvalQueue", 49);
        forwardsTab.put("pending", 50);
        forwardsTab.put("suggestionQueue", 51);
        forwardsTab.put("users", 52);
        forwardsTab.put("calsuite", 53);
        forwardsTab.put("system", 54);
    }
}

