/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.client.web.admin.admingroup;

import org.bedework.calfacade.BwGroup;
import org.bedework.calfacade.BwPrincipal;
import org.bedework.calfacade.DirectoryInfo;
import org.bedework.calfacade.exc.CalFacadeException;
import org.bedework.calfacade.svc.BwAdminGroup;
import org.bedework.calfacade.svc.BwAuthUser;
import org.bedework.client.admin.AdminClient;
import org.bedework.client.web.admin.AdminActionBase;
import org.bedework.client.web.admin.BwAdminActionForm;
import org.bedework.util.misc.Util;
import org.bedework.webcommon.BwRequest;

public class UpdateAGAction
extends AdminActionBase {
    @Override
    public int doAction(BwRequest request, AdminClient cl) {
        if (!cl.isSuperUser()) {
            return 4;
        }
        if (request.getReqPar("delete") != null) {
            return 18;
        }
        BwAdminActionForm form = this.getAdminForm();
        cl.setChoosingGroup(false);
        boolean add = form.getAddingAdmingroup();
        BwAdminGroup updgrp = form.getUpdAdminGroup();
        if (updgrp == null) {
            return 35;
        }
        try {
            if (request.getReqPar("addGroupMember") != null) {
                BwGroup newMbr;
                String mbr = Util.checkNull((String)request.getReqPar("updGroupMember"));
                if (mbr == null) {
                    return 1;
                }
                String kind = request.getReqPar("kind");
                if (!this.validateKind(request, kind)) {
                    return 2;
                }
                if (updgrp.isMember(mbr, "group".equals(kind))) {
                    request.error("org.bedework.client.error.alreadymember", (Object)mbr);
                    return 2;
                }
                if ("user".equals(kind)) {
                    BwAuthUser au;
                    BwPrincipal p = cl.getUser(mbr);
                    if (p == null) {
                        cl.addUser(mbr);
                        p = cl.getUser(mbr);
                    }
                    if ((au = cl.getAuthUser(p)) != null && au.isUnauthorized()) {
                        return 26;
                    }
                    if (au == null) {
                        au = BwAuthUser.makeAuthUser((String)p.getPrincipalRef(), (int)64);
                        cl.addAuthUser(au);
                    }
                    newMbr = p;
                } else {
                    newMbr = cl.findGroup(mbr);
                    if (newMbr == null) {
                        request.error("org.bedework.client.error.unknown.group", (Object)mbr);
                        return 2;
                    }
                }
                cl.addAdminGroupMember(updgrp, (BwPrincipal)newMbr);
                updgrp.addGroupMember((BwPrincipal)newMbr);
            } else if (request.getReqPar("removeGroupMember") != null) {
                String mbr = request.getReqPar("removeGroupMember");
                String kind = request.getReqPar("kind");
                if (!this.validateKind(request, kind)) {
                    return 2;
                }
                Object oldMbr = "user".equals(kind) ? cl.getUser(mbr) : cl.findAdminGroup(mbr);
                if (oldMbr != null) {
                    cl.removeAdminGroupMember(updgrp, oldMbr);
                    updgrp.removeGroupMember(oldMbr);
                }
            } else if (add) {
                if (!this.validateNewAdminGroup(request, cl)) {
                    return 2;
                }
                cl.addAdminGroup(updgrp);
                form.assignAddingAdmingroup(false);
            } else {
                if (!this.validateAdminGroup(request, cl)) {
                    return 2;
                }
                if (this.debug()) {
                    this.debug("About to update " + updgrp);
                }
                cl.updateAdminGroup(updgrp);
            }
            cl.refreshAdminGroups();
        }
        catch (CalFacadeException cfe) {
            String msg;
            switch (msg = cfe.getMessage()) {
                case "org.bedework.exception.duplicateadmingroup": {
                    request.error("org.bedework.client.error.duplicategroup", (Object)updgrp.getAccount());
                    return 2;
                }
                case "org.bedework.exception.alreadyonagrouppath": {
                    request.error("org.bedework.client.error.ongrouppath", (Object)updgrp.getAccount());
                    return 2;
                }
            }
            throw cfe;
        }
        request.message("org.bedework.client.message.updated.group");
        return 1;
    }

    public void setAdminGroupGroupOwner(String val) {
        this.getAdminForm().setAdminGroupGroupOwner(val);
    }

    public String getAdminGroupGroupOwner() {
        return this.getAdminForm().getAdminGroupGroupOwner();
    }

    public void setAdminGroupEventOwner(String val) {
        this.getAdminForm().setAdminGroupEventOwner(val);
    }

    public String getAdminGroupEventOwner() {
        return this.getAdminForm().getAdminGroupEventOwner();
    }

    private boolean validateNewAdminGroup(BwRequest request, AdminClient cl) {
        String adminGroupGroupOwner;
        boolean ok = true;
        BwAdminGroup updAdminGroup = this.getAdminForm().getUpdAdminGroup();
        if (updAdminGroup == null) {
            return false;
        }
        updAdminGroup.setAccount(Util.checkNull((String)updAdminGroup.getAccount()));
        if (updAdminGroup.getAccount() == null) {
            request.error("org.bedework.validation.error.missingname");
            ok = false;
        } else {
            DirectoryInfo di = cl.getDirectoryInfo();
            Object href = di.getBwadmingroupPrincipalRoot();
            if (!((String)href).endsWith("/")) {
                href = (String)href + "/";
            }
            updAdminGroup.setPrincipalRef((String)href + updAdminGroup.getAccount());
        }
        updAdminGroup.setDescription(Util.checkNull((String)updAdminGroup.getDescription()));
        if (updAdminGroup.getDescription() == null) {
            request.error("org.bedework.validation.error.missingdescription");
            ok = false;
        }
        if ((adminGroupGroupOwner = Util.checkNull((String)this.getAdminForm().getAdminGroupGroupOwner())) == null) {
            request.error("org.bedework.validation.error.missinggroupowner");
            ok = false;
        } else {
            updAdminGroup.setGroupOwnerHref(cl.getUserAlways(adminGroupGroupOwner).getPrincipalRef());
        }
        Object adminGroupEventOwner = Util.checkNull((String)this.getAdminForm().getAdminGroupEventOwner());
        if (adminGroupEventOwner == null) {
            adminGroupEventOwner = updAdminGroup.getAccount();
        }
        if (adminGroupEventOwner == null) {
            request.error("org.bedework.validation.error.missingeventowner");
            ok = false;
        } else {
            String prefix = cl.getAdminGroupsIdPrefix();
            if (cl.isPrincipal((String)adminGroupEventOwner)) {
                adminGroupEventOwner = ((String)adminGroupEventOwner).substring(((String)adminGroupEventOwner).lastIndexOf("/") + 1);
            }
            if (!((String)adminGroupEventOwner).startsWith(prefix)) {
                adminGroupEventOwner = prefix + (String)adminGroupEventOwner;
            }
            updAdminGroup.setOwnerHref(cl.getUserAlways((String)adminGroupEventOwner).getPrincipalRef());
        }
        return ok;
    }

    private boolean validateAdminGroup(BwRequest request, AdminClient cl) {
        Object adminGroupEventOwner;
        boolean ok = true;
        BwAdminGroup updAdminGroup = this.getAdminForm().getUpdAdminGroup();
        if (updAdminGroup == null) {
            return false;
        }
        updAdminGroup.setDescription(Util.checkNull((String)updAdminGroup.getDescription()));
        if (updAdminGroup.getDescription() == null) {
            request.error("org.bedework.validation.error.missingdescription");
            ok = false;
        }
        String adminGroupGroupOwner = Util.checkNull((String)this.getAdminForm().getAdminGroupGroupOwner());
        BwPrincipal updAgowner = cl.getPrincipal(updAdminGroup.getGroupOwnerHref());
        if (adminGroupGroupOwner != null && !adminGroupGroupOwner.equals(updAgowner.getAccount())) {
            BwPrincipal aggo = cl.getUser(adminGroupGroupOwner);
            if (aggo == null) {
                request.error("org.bedework.client.error.unknown.user", (Object)adminGroupGroupOwner);
                return false;
            }
            updAdminGroup.setGroupOwnerHref(aggo.getPrincipalRef());
        }
        if ((adminGroupEventOwner = Util.checkNull((String)this.getAdminForm().getAdminGroupEventOwner())) == null) {
            return ok;
        }
        BwPrincipal ageo = cl.getUser((String)adminGroupEventOwner);
        String prefix = cl.getAdminGroupsIdPrefix();
        if (!((String)adminGroupEventOwner).startsWith(prefix)) {
            adminGroupEventOwner = prefix + (String)adminGroupEventOwner;
        }
        if (ageo == null) {
            request.error("org.bedework.client.error.unknown.user", adminGroupEventOwner);
            return false;
        }
        if (ageo.getPrincipalRef().equals(updAdminGroup.getOwnerHref())) {
            return ok;
        }
        updAdminGroup.setOwnerHref(ageo.getPrincipalRef());
        return ok;
    }

    private boolean validateKind(BwRequest request, String kind) {
        if (kind == null) {
            request.error("org.bedework.client.error.missingrequestpar", (Object)"kind");
            return false;
        }
        if ("group".equals(kind) || "user".equals(kind)) {
            return true;
        }
        request.error("org.bedework.client.error.badrequest", (Object)kind);
        return false;
    }
}

