/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.client.web.admin.event;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.bedework.calfacade.BwCategory;
import org.bedework.calfacade.BwEvent;
import org.bedework.calfacade.BwXproperty;
import org.bedework.calfacade.base.BwShareableDbentity;
import org.bedework.calfacade.svc.BwAdminGroup;
import org.bedework.calfacade.svc.EventInfo;
import org.bedework.calfacade.svc.RealiasResult;
import org.bedework.calfacade.svc.wrappers.BwCalSuiteWrapper;
import org.bedework.calfacade.util.ChangeTableEntry;
import org.bedework.client.admin.AdminClient;
import org.bedework.client.admin.AdminConfig;
import org.bedework.client.rw.RWClient;
import org.bedework.client.web.admin.BwAdminActionForm;
import org.bedework.client.web.admin.event.AdminUpdatePars;
import org.bedework.client.web.rw.EventCommon;
import org.bedework.client.web.rw.event.UpdateEventAction;
import org.bedework.client.web.rw.event.UpdatePars;
import org.bedework.sysevents.events.SysEventBase;
import org.bedework.sysevents.events.publicAdmin.EntityApprovalNeededEvent;
import org.bedework.sysevents.events.publicAdmin.EntitySuggestedEvent;
import org.bedework.util.calendar.PropertyIndex;
import org.bedework.util.misc.Util;
import org.bedework.util.misc.response.GetEntityResponse;
import org.bedework.util.misc.response.Response;
import org.bedework.webcommon.BwRequest;

public class AdminUpdateEventAction
extends UpdateEventAction {
    public int doAction(BwRequest request, RWClient cl) {
        if (this.getRwForm().getEventInfo() == null) {
            return 3;
        }
        AdminUpdatePars pars = new AdminUpdatePars(request, cl);
        if (pars.publishEvent || pars.approveEvent) {
            cl.rollback();
            return 3;
        }
        int fwd = super.doUpdate(request, cl, (UpdatePars)pars);
        pars.ev.setPublick(Boolean.valueOf(true));
        return fwd;
    }

    protected boolean isOwner(UpdatePars pars) {
        return pars.adding || ((AdminClient)pars.cl).isCalSuiteEntity((BwShareableDbentity)pars.ev);
    }

    protected boolean setLocation(UpdatePars pars) {
        return EventCommon.adminEventLocation((BwRequest)pars.request, (EventInfo)pars.ei);
    }

    protected GetEntityResponse<Set<BwCategory>> doAliases(UpdatePars pars) {
        GetEntityResponse ger = new GetEntityResponse();
        AdminUpdatePars adPars = (AdminUpdatePars)pars;
        RealiasResult resp = pars.cl.reAlias(pars.ev);
        if (resp.getStatus() != Response.Status.ok) {
            if (this.debug()) {
                this.debug("Failed to get topical areas? " + resp);
            }
            pars.cl.rollback();
            pars.request.error("org.bedework.validation.error.missingtopicalarea");
            return (GetEntityResponse)Response.error((Response)ger, (String)"org.bedework.validation.error.missingtopicalarea");
        }
        adPars.categories = resp.getCats();
        ger.setEntity((Object)resp.getCats());
        return ger;
    }

    protected boolean doAdditional(UpdatePars pars) {
        AdminUpdatePars adPars = (AdminUpdatePars)pars;
        if (this.isOwner(pars)) {
            adPars.suggestedTo = this.doSuggested(adPars);
        }
        return true;
    }

    protected int processXprops(UpdatePars pars, List<BwXproperty> extras) {
        List xps;
        AdminUpdatePars adPars = (AdminUpdatePars)pars;
        if (adPars.updateSubmitEvent && !Util.isEmpty((Collection)(xps = adPars.ev.getXproperties("X-BEDEWORK-SUBMITTER-EMAIL")))) {
            adPars.submitterEmail = ((BwXproperty)xps.get(0)).getValue();
        }
        return super.processXprops(pars, extras);
    }

    protected int update(UpdatePars pars) {
        BwXproperty evregprop;
        AdminUpdatePars adPars = (AdminUpdatePars)pars;
        BwEvent ev = pars.ev;
        AdminClient adcl = (AdminClient)pars.cl;
        BwAdminActionForm form = (BwAdminActionForm)pars.request.getBwForm();
        int fwd = super.doUpdate(pars);
        if (fwd != 0) {
            return fwd;
        }
        String clearFormPref = adcl.getCalsuitePreferences().getClearFormsOnSubmit();
        boolean clearForm = clearFormPref == null ? ((AdminConfig)pars.request.getConfig()).getDefaultClearFormsOnSubmit() : Boolean.parseBoolean(clearFormPref);
        if (clearForm) {
            form.setLocation(null);
            form.setContact(null);
            form.resetSelectIds();
        }
        if (adPars.updateSubmitEvent && pars.request.getBooleanReqPar("submitNotification", false)) {
            EventCommon.notifySubmitter((BwRequest)pars.request, (EventInfo)pars.ei, (String)adPars.submitterEmail);
        }
        if (adPars.awaitingApprovalEvent) {
            BwCalSuiteWrapper cs = adcl.getCalSuite();
            String csHref = cs != null ? cs.getGroup().getOwnerHref() : null;
            EntityApprovalNeededEvent sev = new EntityApprovalNeededEvent(SysEventBase.SysCode.APPROVAL_NEEDED, adcl.getCurrentPrincipalHref(), ev.getCreatorHref(), ev.getHref(), null, null, csHref);
            adcl.postNotification((SysEventBase)sev);
        }
        if (!Util.isEmpty(adPars.suggestedTo)) {
            for (BwEvent.SuggestedTo st : adPars.suggestedTo) {
                BwAdminGroup grp = (BwAdminGroup)adcl.getAdminGroup(st.getGroupHref());
                if (grp == null) {
                    this.warn("Unable to locate group " + st.getGroupHref());
                    continue;
                }
                EntitySuggestedEvent ese = new EntitySuggestedEvent(SysEventBase.SysCode.SUGGESTED, adcl.getCurrentPrincipalHref(), ev.getCreatorHref(), ev.getHref(), null, grp.getOwnerHref());
                adcl.postNotification((SysEventBase)ese);
            }
        }
        if ((evregprop = ev.findXproperty("X-BEDEWORK-REGISTRATION-START")) != null) {
            EventCommon.notifyEventReg((BwRequest)pars.request, (EventInfo)pars.ei);
        }
        EventCommon.resetEvent((BwRequest)pars.request, (boolean)clearForm);
        return 0;
    }

    private List<BwEvent.SuggestedTo> doSuggested(AdminUpdatePars pars) {
        AdminClient cl = (AdminClient)pars.cl;
        if (!cl.getSystemProperties().getSuggestionEnabled()) {
            return null;
        }
        ArrayList<BwEvent.SuggestedTo> suggestedTo = null;
        ChangeTableEntry xcte = pars.changes.getEntry(PropertyIndex.PropertyInfoIndex.XPROP);
        List groupHrefs = pars.request.getReqPars("groupHref");
        List alreadySuggested = pars.ev.getXproperties("X-BEDEWORK-SUGGESTED-TO");
        BwCalSuiteWrapper cs = cl.getCalSuite();
        String csHref = cs.getGroup().getPrincipalRef();
        if (groupHrefs == null) {
            if (!Util.isEmpty((Collection)alreadySuggested)) {
                for (BwXproperty xp : alreadySuggested) {
                    pars.ev.removeXproperty(xp);
                    xcte.addRemovedValue((Object)xp);
                }
            }
            return suggestedTo;
        }
        TreeSet<String> hrefsPresent = new TreeSet<String>();
        HashMap<String, BwXproperty> toRemove = new HashMap<String, BwXproperty>(alreadySuggested.size());
        for (BwXproperty as : alreadySuggested) {
            String href = new BwEvent.SuggestedTo(as.getValue()).getGroupHref();
            hrefsPresent.add(href);
            toRemove.put(href, as);
        }
        TreeSet deDuped = new TreeSet(groupHrefs);
        for (String groupHref : deDuped) {
            if (!hrefsPresent.contains(groupHref)) {
                BwEvent.SuggestedTo sto = new BwEvent.SuggestedTo('P', groupHref, csHref);
                BwXproperty grpXp = new BwXproperty("X-BEDEWORK-SUGGESTED-TO", null, sto.toString());
                pars.ev.addXproperty(grpXp);
                xcte.addAddedValue((Object)grpXp);
                if (suggestedTo == null) {
                    suggestedTo = new ArrayList<BwEvent.SuggestedTo>();
                }
                suggestedTo.add(sto);
            } else {
                toRemove.remove(groupHref);
            }
            cl.getPreferences().addPreferredGroup(groupHref);
        }
        if (!Util.isEmpty(toRemove.values())) {
            for (BwXproperty xp : toRemove.values()) {
                pars.ev.removeXproperty(xp);
                xcte.addRemovedValue((Object)xp);
            }
        }
        return suggestedTo;
    }
}

