/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.client.web.admin.event;

import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.bedework.appcommon.client.Client;
import org.bedework.calfacade.BwCategory;
import org.bedework.calfacade.BwEvent;
import org.bedework.calfacade.exc.ValidationError;
import org.bedework.client.rw.RWClient;
import org.bedework.client.web.rw.EventCommon;
import org.bedework.client.web.rw.event.UpdatePars;
import org.bedework.util.misc.Util;
import org.bedework.webcommon.BwRequest;

public class AdminUpdatePars
extends UpdatePars {
    String submitterEmail;
    final boolean publishEvent;
    final boolean updateSubmitEvent;
    final boolean approveEvent;
    final String submissionsRoot;
    final String workflowRoot;
    boolean awaitingApprovalEvent;
    List<BwEvent.SuggestedTo> suggestedTo;
    Set<BwCategory> categories;

    AdminUpdatePars(BwRequest request, RWClient cl) {
        super(request, cl);
        this.publishEvent = request.present("publishEvent");
        this.updateSubmitEvent = request.present("updateSubmitEvent");
        this.approveEvent = request.present("approveEvent");
        this.submissionsRoot = cl.getSystemProperties().getSubmissionRoot();
        this.workflowRoot = cl.getSystemProperties().getWorkflowRoot();
        this.categories = this.ev.getCategories();
    }

    public List<ValidationError> validate() {
        List ves = EventCommon.validateEvent((Client)this.cl, (int)this.cl.getAuthProperties().getMaxPublicDescriptionLength(), (boolean)false, (BwEvent)this.ev);
        if (!Util.isEmpty((Collection)ves)) {
            return ves;
        }
        if (!this.updateSubmitEvent) {
            if (this.ev.getLocation() == null) {
                ves = EventCommon.addError((List)ves, (String)"org.bedework.validation.error.missinglocation");
            }
            if (this.ev.getContact() == null) {
                ves = EventCommon.addError((List)ves, (String)"org.bedework.validation.error.missingcontact");
            }
        }
        if (this.updateSubmitEvent) {
            if (!this.ev.getColPath().startsWith(this.submissionsRoot)) {
                ves = EventCommon.addError((List)ves, (String)"org.bedework.validation.error.notsubmissionscalendar");
                this.cl.rollback();
                return ves;
            }
        } else if (this.workflowRoot != null && this.ev.getColPath().startsWith(this.workflowRoot)) {
            this.awaitingApprovalEvent = this.adding;
        }
        if (!this.updateSubmitEvent && Util.isEmpty(this.categories)) {
            ves = EventCommon.addError((List)ves, (String)"org.bedework.validation.error.missingtopicalarea");
        }
        return ves;
    }
}

