/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.client.web.admin.event;

import java.util.Collection;
import java.util.List;
import org.bedework.calfacade.BwContact;
import org.bedework.calfacade.BwEvent;
import org.bedework.calfacade.BwLocation;
import org.bedework.calfacade.BwXproperty;
import org.bedework.calfacade.exc.ValidationError;
import org.bedework.calfacade.svc.EventInfo;
import org.bedework.calfacade.svc.wrappers.BwCalSuiteWrapper;
import org.bedework.client.admin.AdminClient;
import org.bedework.client.rw.RWClient;
import org.bedework.client.web.admin.AdminActionBase;
import org.bedework.client.web.admin.BwAdminWebGlobals;
import org.bedework.client.web.admin.event.AdminUpdatePars;
import org.bedework.client.web.rw.EventCommon;
import org.bedework.client.web.rw.event.UpdatePars;
import org.bedework.sysevents.events.SysEventBase;
import org.bedework.sysevents.events.publicAdmin.EntityApprovalResponseEvent;
import org.bedework.util.calendar.PropertyIndex;
import org.bedework.util.misc.Util;
import org.bedework.util.misc.response.Response;
import org.bedework.webcommon.BwRequest;

public class ApprovePublishAction
extends AdminActionBase {
    @Override
    public int doAction(BwRequest request, AdminClient cl) {
        BwXproperty evregprop;
        Response resp;
        if (this.getBwForm().getEventInfo() == null) {
            return 3;
        }
        BwAdminWebGlobals globals = (BwAdminWebGlobals)request.getGlobals();
        AdminUpdatePars pars = new AdminUpdatePars(request, (RWClient)cl);
        AdminClient adcl = (AdminClient)pars.cl;
        BwEvent ev = pars.ev;
        if (pars.approveEvent) {
            if (!globals.getCurUserApproverUser()) {
                cl.rollback();
                return 4;
            }
        } else if (pars.publishEvent) {
            List xps = ev.getXproperties("X-BEDEWORK-SUBMITTER-EMAIL");
            if (!Util.isEmpty((Collection)xps)) {
                pars.submitterEmail = ((BwXproperty)xps.get(0)).getValue();
            }
        } else {
            cl.rollback();
            return 4;
        }
        if (ev.getRecurrenceId() != null) {
            cl.rollback();
            return 3;
        }
        List<ValidationError> ves = this.validate(pars);
        if (ves != null) {
            for (ValidationError ve : ves) {
                request.error(ve.getErrorCode(), (Object)ve.getExtra());
            }
            return 17;
        }
        if (pars.publishEvent) {
            EventInfo.UpdateResult ur;
            this.copyEntities(ev);
            this.changeOwner(ev, pars.cl);
            pars.changes.changed(PropertyIndex.PropertyInfoIndex.CREATOR, null, (Object)ev.getCreatorHref());
            if (ev.getRecurring().booleanValue() && pars.ei.getOverrideProxies() != null) {
                for (BwEvent oev : pars.ei.getOverrideProxies()) {
                    this.copyEntities(oev);
                    this.changeOwner(oev, pars.cl);
                    oev.setColPath(ev.getColPath());
                }
            }
            if (!(ur = pars.cl.updateEvent(pars.ei, !pars.sendInvitations, null, false)).isOk()) {
                pars.request.error(ur.getMessage());
                pars.cl.rollback();
                return 3;
            }
            if (request.getBooleanReqPar("submitNotification", false)) {
                EventCommon.notifySubmitter((BwRequest)pars.request, (EventInfo)pars.ei, (String)pars.submitterEmail);
            }
        }
        if (!(resp = pars.cl.moveEvent(pars.ei, cl.getPrimaryPublicPath())).isOk()) {
            pars.request.error(resp.getMessage());
            pars.cl.rollback();
            return 3;
        }
        if (pars.approveEvent) {
            BwCalSuiteWrapper cs = adcl.getCalSuite();
            String csHref = cs != null ? cs.getGroup().getOwnerHref() : null;
            EntityApprovalResponseEvent sev = new EntityApprovalResponseEvent(SysEventBase.SysCode.APPROVAL_STATUS, adcl.getCurrentPrincipalHref(), ev.getCreatorHref(), ev.getHref(), null, true, null, csHref);
            adcl.postNotification((SysEventBase)sev);
        }
        if ((evregprop = ev.findXproperty("X-BEDEWORK-REGISTRATION-START")) != null) {
            EventCommon.notifyEventReg((BwRequest)pars.request, (EventInfo)pars.ei);
        }
        pars.ev.setPublick(Boolean.valueOf(true));
        return 0;
    }

    protected List<ValidationError> validate(UpdatePars pars) {
        AdminUpdatePars adPars = (AdminUpdatePars)pars;
        BwEvent ev = pars.ev;
        List ves = adPars.validate();
        if (!Util.isEmpty(ves)) {
            return ves;
        }
        String colPath = ev.getColPath();
        if (adPars.publishEvent) {
            if (!colPath.startsWith(adPars.submissionsRoot)) {
                ves = EventCommon.addError(ves, (String)"org.bedework.validation.error.notinsubmissionscalendar");
                return ves;
            }
        } else if (adPars.approveEvent && !colPath.startsWith(adPars.workflowRoot)) {
            ves = EventCommon.addError((List)ves, (String)"org.bedework.validation.error.notinworkflowcalendar");
            return ves;
        }
        return ves;
    }

    private void changeOwner(BwEvent ev, RWClient cl) {
        cl.claimEvent(ev);
        ev.setCreatorHref(cl.getCurrentPrincipalHref());
    }

    private void copyEntities(BwEvent ev) {
        BwContact contact;
        BwLocation loc = ev.getLocation();
        if (loc != null && !loc.getPublick().booleanValue()) {
            loc = (BwLocation)loc.clone();
            loc.setOwnerHref(null);
            loc.setCreatorHref(null);
            loc.setPublick(Boolean.valueOf(true));
            ev.setLocation(loc);
        }
        if ((contact = ev.getContact()) != null && !contact.getPublick().booleanValue()) {
            contact = (BwContact)contact.clone();
            contact.setOwnerHref(null);
            contact.setCreatorHref(null);
            contact.setPublick(Boolean.valueOf(true));
            ev.setLocation(loc);
            ev.setContact(contact);
        }
    }
}

