/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.client.web.admin.location;

import javax.servlet.http.HttpServletResponse;
import org.bedework.calfacade.BwLocation;
import org.bedework.calfacade.BwString;
import org.bedework.client.admin.AdminClient;
import org.bedework.client.web.admin.AdminActionBase;
import org.bedework.client.web.admin.BwAdminActionForm;
import org.bedework.util.misc.Uid;
import org.bedework.util.misc.response.GetEntityResponse;
import org.bedework.webcommon.BwRequest;

public class AddSubLocationAction
extends AdminActionBase {
    @Override
    public int doAction(BwRequest request, AdminClient cl) {
        GetEntityResponse gresp;
        BwAdminActionForm form = this.getAdminForm();
        String uid = request.getReqPar("uid");
        BwLocation location = null;
        if (uid != null && (gresp = cl.getLocationByUid(uid)).isOk()) {
            location = (BwLocation)gresp.getEntity();
        }
        if (this.debug()) {
            if (location == null) {
                this.info("No location with id " + uid);
            } else {
                this.info("Retrieved location " + location.getUid());
            }
        }
        form.assignAddingLocation(false);
        form.setLocation(location);
        HttpServletResponse resp = request.getResponse();
        if (location == null) {
            resp.setStatus(404);
            return 47;
        }
        String subaddr = request.getReqPar("sub");
        BwLocation newloc = new BwLocation();
        newloc.setUid(Uid.getUid());
        newloc.setCreatorHref(location.getCreatorHref());
        newloc.setOwnerHref(location.getOwnerHref());
        newloc.setPublick(location.getPublick());
        if (location.getAddress() != null) {
            newloc.setAddress((BwString)location.getAddress().clone());
        } else {
            newloc.setAddress(new BwString(null, ""));
        }
        BwString addr = newloc.getAddress();
        if (addr.getValue().contains("\t")) {
            int pos = addr.getValue().lastIndexOf("\t");
            addr.setValue(addr.getValue().substring(0, pos));
        }
        addr.setValue(addr.getValue() + "\t" + subaddr);
        if (location.getSubaddress() != null) {
            newloc.setSubaddress((BwString)location.getSubaddress().clone());
        }
        newloc.setLink(location.getLink());
        try {
            cl.addLocation(newloc);
        }
        catch (Throwable t) {
            if (this.debug()) {
                this.error(t);
            }
            resp.setStatus(500);
            return 47;
        }
        form.setLocation(newloc);
        cl.outputJson(resp, cl.getCurrentChangeToken(), null, (Object)newloc);
        return 47;
    }
}

