/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.client.web.admin.resources;

import org.bedework.calfacade.BwResource;
import org.bedework.calfacade.BwResourceContent;
import org.bedework.calfacade.svc.BwCalSuite;
import org.bedework.client.admin.AdminClient;
import org.bedework.client.web.admin.AdminActionBase;
import org.bedework.client.web.admin.BwAdminActionForm;
import org.bedework.webcommon.BwRequest;
import org.bedework.webcommon.BwWebGlobals;

public class AddResourceAction
extends AdminActionBase {
    @Override
    public int doAction(BwRequest request, AdminClient cl) {
        BwWebGlobals globals = request.getBwGlobals();
        BwAdminActionForm form = this.getAdminForm();
        String rclass = request.getReqPar("class");
        String name = request.getReqPar("name");
        Object contentType = request.getReqPar("ct");
        String type = request.getReqPar("type");
        if (rclass == null) {
            rclass = "calsuite";
        }
        if (name == null) {
            request.error("org.bedework.validation.error.missingname");
            return 28;
        }
        if (contentType == null) {
            request.error("org.bedework.validation.error.missingcontenttype");
            return 28;
        }
        if (type == null) {
            request.error("org.bedework.validation.error.missingtype");
            return 28;
        }
        if ((rclass.equals("global") || rclass.equals("admin")) && !cl.isSuperUser()) {
            request.error("org.bedework.client.error.noaccess");
            return 4;
        }
        BwResource r = cl.getCSResource((BwCalSuite)globals.getCurrentCalSuite(), name, rclass);
        if (r != null) {
            request.error("org.bedework.client.error.duplicateresource");
            return 16;
        }
        r = new BwResource();
        r.setName(name);
        BwResourceContent rc = new BwResourceContent();
        r.setContent(rc);
        contentType = (String)contentType + "\ttype=" + type;
        r.setContentType((String)contentType);
        cl.addCSResource((BwCalSuite)globals.getCurrentCalSuite(), r, rclass);
        form.setResourceName(name);
        form.setResourceClass(rclass);
        form.assignAddingResource(true);
        return 0;
    }
}

