/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.client.web.admin.resources;

import org.bedework.appcommon.CalSuiteResource;
import org.bedework.calfacade.BwResource;
import org.bedework.calfacade.svc.BwCalSuite;
import org.bedework.client.admin.AdminClient;
import org.bedework.client.web.admin.AdminActionBase;
import org.bedework.client.web.admin.BwAdminActionForm;
import org.bedework.webcommon.BwRequest;

public class RenderResourceAction
extends AdminActionBase {
    @Override
    public int doAction(BwRequest request, AdminClient cl) {
        BwAdminActionForm form = this.getAdminForm();
        String name = form.getResourceName();
        if (name == null) {
            request.error("org.bedework.validation.error.missingname");
            return 2;
        }
        String rclass = form.getResourceClass();
        if (rclass == null) {
            rclass = "calsuite";
        }
        if ((rclass.equals("global") || rclass.equals("admin")) && !cl.isSuperUser()) {
            return 4;
        }
        String mod = request.getReqPar("mod");
        BwResource resource = cl.getCSResource((BwCalSuite)request.getBwGlobals().getCurrentCalSuite(), name, rclass);
        if (resource == null) {
            request.error("org.bedework.client.error.unknown.resource", (Object)name);
            return 2;
        }
        if (mod != null && mod.equals("true")) {
            form.assignAddingResource(false);
        }
        form.setCalSuiteResource(new CalSuiteResource(resource, rclass));
        return 0;
    }
}

