/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.client.web.admin.resources;

import java.util.ArrayList;
import java.util.List;
import org.bedework.appcommon.CalSuiteResource;
import org.bedework.calfacade.BwResource;
import org.bedework.calfacade.exc.CalFacadeException;
import org.bedework.calfacade.svc.BwCalSuite;
import org.bedework.client.admin.AdminClient;
import org.bedework.client.web.admin.AdminActionBase;
import org.bedework.client.web.admin.BwAdminActionForm;
import org.bedework.webcommon.BwRequest;
import org.bedework.webcommon.BwWebGlobals;

public class RenderResourcesAction
extends AdminActionBase {
    @Override
    public int doAction(BwRequest request, AdminClient cl) {
        BwAdminActionForm form = this.getAdminForm();
        BwWebGlobals globals = request.getBwGlobals();
        if (request.isNewSession()) {
            request.refresh();
            return 21;
        }
        List<CalSuiteResource> resources = this.getResources(cl, (BwCalSuite)globals.getCurrentCalSuite());
        form.setCalSuiteResources(resources);
        return 0;
    }

    protected List<CalSuiteResource> getResources(AdminClient cl, BwCalSuite currentCalSuite) throws CalFacadeException {
        ArrayList<CalSuiteResource> resources = new ArrayList<CalSuiteResource>();
        List bres = cl.getCSResources(currentCalSuite, "calsuite");
        if (bres != null) {
            for (BwResource r : bres) {
                resources.add(new CalSuiteResource(r, "calsuite"));
            }
        }
        if (cl.isSuperUser() && (bres = cl.getCSResources(currentCalSuite, "admin")) != null) {
            for (BwResource r : bres) {
                resources.add(new CalSuiteResource(r, "admin"));
            }
        }
        return resources;
    }

    public boolean clearMessagesOnEntry() {
        return false;
    }
}

