/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.webcommon;

import java.io.Serializable;
import java.util.ArrayList;
import org.bedework.access.Ace;
import org.bedework.access.AceWho;
import org.bedework.access.Privilege;
import org.bedework.access.PrivilegeDefs;
import org.bedework.access.Privileges;
import org.bedework.webcommon.BwRequest;
import org.bedework.webcommon.ForwardDefs;

public class AccessSetter
implements ForwardDefs,
Serializable {
    public static Pars parseRequest(BwRequest request) throws Throwable {
        Pars pars = new Pars();
        pars.status = AccessSetter.getWho(request, pars);
        if (pars.status != 0) {
            return pars;
        }
        pars.status = AccessSetter.getHow(request, pars);
        if (pars.status != 0) {
            return pars;
        }
        pars.status = AccessSetter.getWhat(request, pars);
        return pars;
    }

    private static int getWhat(BwRequest request, Pars pars) throws Throwable {
        String what = request.getReqPar("what");
        if (what == null) {
            if (pars.isScheduling) {
                request.getErr().emit("org.bedework.client.error.missingschedulewhat");
                return 3;
            }
            return 0;
        }
        if (!pars.isScheduling && !pars.defaultHow) {
            request.getErr().emit("org.bedework.client.error.badschedulewhat", (Object)what);
            return 3;
        }
        if (what.equals("in")) {
            pars.calType = 5;
            pars.isScheduling = true;
        } else if (what.equals("out")) {
            pars.calType = 6;
            pars.isScheduling = true;
        } else {
            request.getErr().emit("org.bedework.client.error.badschedulewhat", (Object)what);
            return 3;
        }
        return 0;
    }

    private static int getWho(BwRequest request, Pars pars) throws Throwable {
        String whoTypeStr = request.getReqPar("whoType");
        String who = request.getReqPar("who");
        int whoType = -1;
        boolean needWho = false;
        if (whoTypeStr == null || whoTypeStr.equals("user")) {
            if (who == null) {
                return 9;
            }
            whoType = 1;
            needWho = true;
        } else if (whoTypeStr.equals("owner")) {
            whoType = 0;
        } else if (whoTypeStr.equals("user")) {
            whoType = 1;
            needWho = true;
        } else if (whoTypeStr.equals("group")) {
            whoType = 2;
            needWho = true;
        } else if (whoTypeStr.equals("resource")) {
            whoType = 5;
            needWho = true;
        } else if (whoTypeStr.equals("venue")) {
            whoType = 6;
            needWho = true;
        } else if (whoTypeStr.equals("ticket")) {
            whoType = 4;
            needWho = true;
        } else if (whoTypeStr.equals("host")) {
            whoType = 3;
            needWho = true;
        } else if (whoTypeStr.equals("auth")) {
            whoType = 8;
        } else if (whoTypeStr.equals("unauth")) {
            whoType = 7;
        } else if (whoTypeStr.equals("all")) {
            whoType = 10;
        } else if (whoTypeStr.equals("other")) {
            whoType = 9;
        } else {
            request.getErr().emit("org.bedework.validation.error.invalid.whotype", (Object)whoTypeStr);
            return 3;
        }
        if (needWho && who == null) {
            request.getErr().emit("org.bedework.validation.error.missingwho");
            return 3;
        }
        pars.who = AceWho.getAceWho((String)who, (int)whoType, (boolean)"yes".equals(request.getReqPar("notWho")));
        return 0;
    }

    private static int getHow(BwRequest request, Pars pars) throws Throwable {
        String how = request.getReqPar("how");
        if (how == null) {
            request.getErr().emit("org.bedework.validation.error.missinghow");
            return 3;
        }
        if (how.equals("default")) {
            pars.defaultHow = true;
            return 0;
        }
        char[] howchs = how.toCharArray();
        boolean scheduling = true;
        ArrayList<Privilege> privs = new ArrayList<Privilege>();
        for (int hi = 0; hi < howchs.length; ++hi) {
            char howch = howchs[hi];
            boolean found = false;
            boolean denial = false;
            if (howch == '-') {
                denial = true;
                if (++hi == howchs.length) {
                    request.getErr().emit("org.bedework.validation.error.invalid.how");
                    return 3;
                }
                howch = howchs[hi];
            }
            for (int pi = 0; pi <= 24; ++pi) {
                if (howch != PrivilegeDefs.privEncoding[pi]) continue;
                if (!AccessSetter.schedulingPriv(pi, pars)) {
                    scheduling = false;
                }
                privs.add(Privileges.makePriv((int)pi, (boolean)denial));
                found = true;
                break;
            }
            if (!found) {
                request.getErr().emit("org.bedework.validation.error.invalid.how");
                return 3;
            }
            pars.isScheduling = scheduling;
        }
        pars.aces.add(Ace.makeAce((AceWho)pars.who, privs, null));
        return 0;
    }

    private static boolean schedulingPriv(int pi, Pars pars) {
        if (pi == 10) {
            pars.schedule = true;
            return true;
        }
        if (pi == 11) {
            pars.scheduleRequest = true;
            return true;
        }
        if (pi == 12) {
            pars.scheduleReply = true;
            return true;
        }
        if (pi == 13) {
            pars.scheduleFreeBusy = true;
            return true;
        }
        return false;
    }

    public static class Pars {
        public int status;
        public boolean replaceAll;
        public AceWho who;
        public boolean defaultHow;
        public ArrayList<Ace> aces = new ArrayList();
        private boolean isScheduling;
        public int calType = -1;
        public boolean schedule;
        public boolean scheduleRequest;
        public boolean scheduleReply;
        public boolean scheduleFreeBusy;
    }
}

