/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.webcommon;

import java.util.Collection;
import org.apache.log4j.Logger;
import org.bedework.appcommon.AdminConfig;
import org.bedework.appcommon.client.Client;
import org.bedework.calfacade.BwGroup;
import org.bedework.calfacade.BwPrincipal;
import org.bedework.calfacade.exc.CalFacadeAccessException;
import org.bedework.calfacade.svc.BwAdminGroup;
import org.bedework.calfacade.svc.BwAuthUser;
import org.bedework.calfacade.svc.prefs.BwAuthUserPrefs;
import org.bedework.calfacade.svc.wrappers.BwCalSuiteWrapper;
import org.bedework.util.struts.Request;
import org.bedework.webcommon.BwAbstractAction;
import org.bedework.webcommon.BwActionFormBase;
import org.bedework.webcommon.BwRequest;
import org.bedework.webcommon.BwSessionImpl;
import org.bedework.webcommon.ForwardDefs;

public class AdminUtil
implements ForwardDefs {
    public static int actionSetup(BwRequest request) throws Throwable {
        int temp;
        boolean debug = AdminUtil.getLogger().isDebugEnabled();
        BwActionFormBase form = request.getBwForm();
        Client cl = request.getClient();
        BwAuthUser au = cl.getAuthUser(cl.getAuthPrincipal());
        if (au == null) {
            return 4;
        }
        BwAuthUserPrefs prefs = au.getPrefs();
        ((BwSessionImpl)request.getSess()).setCurAuthUserPrefs(prefs);
        form.setCurAuthUserPrefs(prefs);
        if (form.getNewSession()) {
            form.assignCurUserPublicEvents(au.isPublicEventUser());
            form.assignCurUserContentAdminUser(au.isContentAdminUser());
            form.assignCurUserApproverUser(au.isApproverUser());
            form.assignAuthorisedUser(!au.isUnauthorized());
        }
        if (debug) {
            AdminUtil.logIt("form.getGroupSet()=" + cl.getGroupSet());
        }
        if (debug) {
            AdminUtil.logIt("-------- isSuperUser: " + form.getCurUserSuperUser());
        }
        if ((temp = AdminUtil.checkGroup(request, true)) != 9) {
            if (debug) {
                AdminUtil.logIt("form.getGroupSet()=" + cl.getGroupSet());
            }
            return temp;
        }
        if (!form.getAuthorisedUser()) {
            return 4;
        }
        return 9;
    }

    public static int checkGroup(BwRequest request, boolean initCheck) throws Throwable {
        BwActionFormBase form = (BwActionFormBase)request.getForm();
        Client cl = request.getClient();
        if (cl.getGroupSet()) {
            return 9;
        }
        try {
            if (cl.getChoosingGroup()) {
                String reqpar = request.getReqPar("adminGroupName");
                if (reqpar == null) {
                    form.assignCalSuites(cl.getContextCalSuites());
                    return 13;
                }
                BwAdminGroup adg = (BwAdminGroup)cl.findGroup(reqpar);
                if (adg == null) {
                    if (AdminUtil.getLogger().isDebugEnabled()) {
                        AdminUtil.logIt("No user admin group with name " + reqpar);
                    }
                    form.assignCalSuites(cl.getContextCalSuites());
                    return 13;
                }
                return AdminUtil.setGroup(request, adg);
            }
            BwPrincipal p = cl.getAuthPrincipal();
            if (p == null) {
                return 4;
            }
            Collection adgs = initCheck || !form.getCurUserSuperUser() ? cl.getGroups(p) : cl.getAllGroups(false);
            if (adgs.isEmpty()) {
                boolean noGroupAllowed = ((AdminConfig)form.getConfig()).getNoGroupAllowed();
                if (cl.isSuperUser() || noGroupAllowed) {
                    cl.setAdminGroupName(null);
                    cl.setGroupSet(true);
                    return 9;
                }
                return 14;
            }
            cl.setOneGroup(false);
            if (adgs.size() == 1) {
                cl.setOneGroup(true);
                return AdminUtil.setGroup(request, (BwAdminGroup)adgs.iterator().next());
            }
            request.setSessionAttr("bw_user_admin_groups", adgs);
            form.assignCalSuites(cl.getContextCalSuites());
            cl.setChoosingGroup(true);
            return 13;
        }
        catch (Throwable t) {
            form.getErr().emit(t);
            return 3;
        }
    }

    private static int setGroup(BwRequest request, BwAdminGroup adg) throws Throwable {
        BwActionFormBase form = request.getBwForm();
        Client cl = request.getClient();
        boolean debug = AdminUtil.getLogger().isDebugEnabled();
        cl.getMembers((BwGroup)adg);
        if (debug) {
            AdminUtil.logIt("Set admin group to " + adg);
        }
        cl.setAdminGroupName(adg.getAccount());
        form.assignAdminGroupName(adg.getAccount());
        cl.setGroupSet(true);
        BwPrincipal p = cl.getPrincipal(adg.getOwnerHref());
        if (p == null || !((BwAbstractAction)request.getAction()).checkSvci(request, request.getSess(), p.getAccount(), AdminUtil.isMember(adg, form))) {
            return 4;
        }
        return 9;
    }

    private static boolean isMember(BwAdminGroup ag, BwActionFormBase form) throws Throwable {
        return ag.isMember(String.valueOf(form.getCurrentUser()), false);
    }

    public static BwCalSuiteWrapper findCalSuite(Request request, Client cl) throws Throwable {
        String groupName = cl.getAdminGroupName();
        if (groupName == null) {
            return null;
        }
        BwAdminGroup adg = (BwAdminGroup)cl.findGroup(groupName);
        return AdminUtil.findCalSuite(request, cl, adg);
    }

    private static BwCalSuiteWrapper findCalSuite(Request request, Client cl, BwAdminGroup adg) throws Throwable {
        if (adg == null) {
            return null;
        }
        try {
            BwCalSuiteWrapper cs = cl.getCalSuite(adg);
            if (cs != null) {
                return cs;
            }
            for (BwGroup parent : cl.findGroupParents((BwGroup)adg)) {
                cs = AdminUtil.findCalSuite(request, cl, (BwAdminGroup)parent);
                if (cs == null) continue;
                return cs;
            }
        }
        catch (CalFacadeAccessException cfe) {
            request.getErr().emit("org.bedework.client.error.nocalsuiteaccess", (Object)adg.getPrincipalRef());
        }
        return null;
    }

    public static void logIt(String msg) {
        AdminUtil.getLogger().info((Object)msg);
    }

    public static Logger getLogger() {
        return Logger.getLogger(AdminUtil.class);
    }

    public static void info(String msg) {
        AdminUtil.getLogger().info((Object)msg);
    }

    public void debugMsg(String msg) {
        AdminUtil.getLogger().debug((Object)msg);
    }

    public void error(Throwable t) {
        AdminUtil.getLogger().error((Object)this, t);
    }
}

