/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.webcommon;

import java.io.Serializable;
import java.util.Set;
import java.util.TreeSet;
import org.bedework.calfacade.BwAttendee;
import org.bedework.calfacade.base.AttendeesEntity;
import org.bedework.calfacade.exc.CalFacadeException;

public class Attendees
implements AttendeesEntity,
Serializable {
    private Set<BwAttendee> attendees;
    private Set<BwAttendee> queriedExternalAttendees;
    private Set<String> recipients;
    private Set<BwAttendee> addedAttendees;
    private Set<BwAttendee> deletedAttendees;

    public void setQueriedExternalAttendees(Set<BwAttendee> val) {
        this.queriedExternalAttendees = val;
    }

    public Set<BwAttendee> getQueriedExternalAttendees() {
        return this.queriedExternalAttendees;
    }

    public Set<BwAttendee> getDeletedAttendees() {
        return this.deletedAttendees;
    }

    public Set<BwAttendee> getAddedAttendees() {
        return this.addedAttendees;
    }

    public void setAttendees(Set<BwAttendee> val) {
        this.attendees = val;
    }

    public Set<BwAttendee> getAttendees() {
        return this.attendees;
    }

    public int getNumAttendees() {
        Set<BwAttendee> as = this.getAttendees();
        if (as == null) {
            return 0;
        }
        return as.size();
    }

    public void addAttendee(BwAttendee val) {
        Set<BwAttendee> as = this.getAttendees();
        if (as == null) {
            as = new TreeSet<BwAttendee>();
            this.setAttendees(as);
        }
        if (!as.contains(val)) {
            as.add(val);
            if (this.addedAttendees == null) {
                this.addedAttendees = new TreeSet<BwAttendee>();
            }
            this.addedAttendees.add(val);
        }
        if (this.deletedAttendees != null && this.deletedAttendees.contains(val)) {
            this.deletedAttendees.remove(val);
        }
    }

    public boolean removeAttendee(BwAttendee val) {
        Set<BwAttendee> as = this.getAttendees();
        if (as == null) {
            return false;
        }
        if (!as.remove(val)) {
            return false;
        }
        if (this.deletedAttendees == null) {
            this.deletedAttendees = new TreeSet<BwAttendee>();
        }
        this.deletedAttendees.add(val);
        if (this.addedAttendees != null && this.addedAttendees.contains(val)) {
            this.addedAttendees.remove(val);
        }
        return true;
    }

    public Set<BwAttendee> copyAttendees() {
        if (this.getNumAttendees() == 0) {
            return null;
        }
        TreeSet<BwAttendee> ts = new TreeSet<BwAttendee>();
        for (BwAttendee att : this.getAttendees()) {
            ts.add(att);
        }
        return ts;
    }

    public Set<BwAttendee> cloneAttendees() {
        if (this.getNumAttendees() == 0) {
            return null;
        }
        TreeSet<BwAttendee> ts = new TreeSet<BwAttendee>();
        for (BwAttendee att : this.getAttendees()) {
            ts.add((BwAttendee)att.clone());
        }
        return ts;
    }

    public BwAttendee findAttendee(String uri) throws CalFacadeException {
        if (this.getNumAttendees() == 0) {
            return null;
        }
        int uriLen = uri.length();
        while (uri.charAt(uriLen - 1) == '/') {
            if (--uriLen != 0) continue;
            return null;
        }
        for (BwAttendee att : this.getAttendees()) {
            String auri = att.getAttendeeUri();
            int auriLen = auri.length();
            while (auri.charAt(auriLen - 1) == '/') {
                if (--auriLen != 0) continue;
                return null;
            }
            if (auriLen != uriLen || !uri.regionMatches(0, auri, 0, uriLen)) continue;
            return att;
        }
        return null;
    }

    public void setRecipients(Set<String> val) {
        this.recipients = val;
    }

    public Set<String> getRecipients() {
        return this.recipients;
    }

    public int getNumRecipients() {
        Set<String> rs = this.getRecipients();
        if (rs == null) {
            return 0;
        }
        return rs.size();
    }

    public void addRecipient(String val) {
        Set<String> rs = this.getRecipients();
        if (rs == null) {
            rs = new TreeSet<String>();
            this.setRecipients(rs);
        }
        if (!rs.contains(val)) {
            rs.add(val);
        }
    }

    public boolean removeRecipient(String val) {
        Set<String> rs = this.getRecipients();
        if (rs == null) {
            return false;
        }
        return rs.remove(val);
    }
}

