/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.webcommon;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.TimeZone;
import java.util.TreeSet;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import net.fortuna.ical4j.model.Dur;
import org.apache.struts.action.Action;
import org.apache.struts.upload.FormFile;
import org.apache.struts.util.MessageResources;
import org.bedework.appcommon.AdminConfig;
import org.bedework.appcommon.BedeworkDefs;
import org.bedework.appcommon.CalendarInfo;
import org.bedework.appcommon.ConfigCommon;
import org.bedework.appcommon.EventKey;
import org.bedework.appcommon.ImageProcessing;
import org.bedework.appcommon.InOutBoxInfo;
import org.bedework.appcommon.MyCalendarVO;
import org.bedework.appcommon.NotificationInfo;
import org.bedework.appcommon.TimeView;
import org.bedework.appcommon.client.AdminClientImpl;
import org.bedework.appcommon.client.Client;
import org.bedework.appcommon.client.ClientImpl;
import org.bedework.appcommon.client.ROClientImpl;
import org.bedework.appcommon.client.SearchParams;
import org.bedework.caldav.util.filter.FilterBase;
import org.bedework.caldav.util.filter.OrFilter;
import org.bedework.calfacade.BwCalendar;
import org.bedework.calfacade.BwCategory;
import org.bedework.calfacade.BwDateTime;
import org.bedework.calfacade.BwDuration;
import org.bedework.calfacade.BwEvent;
import org.bedework.calfacade.BwEventObj;
import org.bedework.calfacade.BwLocation;
import org.bedework.calfacade.BwPrincipal;
import org.bedework.calfacade.BwResource;
import org.bedework.calfacade.BwString;
import org.bedework.calfacade.RecurringRetrievalMode;
import org.bedework.calfacade.ScheduleResult;
import org.bedework.calfacade.base.BwTimeRange;
import org.bedework.calfacade.base.CategorisedEntity;
import org.bedework.calfacade.configs.AuthProperties;
import org.bedework.calfacade.exc.CalFacadeAccessException;
import org.bedework.calfacade.exc.CalFacadeException;
import org.bedework.calfacade.filter.BwCategoryFilter;
import org.bedework.calfacade.filter.BwCreatorFilter;
import org.bedework.calfacade.filter.SimpleFilterParser;
import org.bedework.calfacade.locale.BwLocale;
import org.bedework.calfacade.responses.GetFilterDefResponse;
import org.bedework.calfacade.responses.Response;
import org.bedework.calfacade.svc.BwCalSuite;
import org.bedework.calfacade.svc.BwPreferences;
import org.bedework.calfacade.svc.EventInfo;
import org.bedework.calfacade.svc.wrappers.BwCalSuiteWrapper;
import org.bedework.calfacade.util.BwDateTimeUtil;
import org.bedework.calfacade.util.ChangeTable;
import org.bedework.calfacade.util.ChangeTableEntry;
import org.bedework.calsvci.SchedulingI;
import org.bedework.util.calendar.PropertyIndex;
import org.bedework.util.calendar.XcalUtil;
import org.bedework.util.misc.Util;
import org.bedework.util.servlet.filters.ConfiguredXSLTFilter;
import org.bedework.util.servlet.filters.PresentationState;
import org.bedework.util.struts.Request;
import org.bedework.util.struts.UtilAbstractAction;
import org.bedework.util.struts.UtilActionForm;
import org.bedework.util.timezones.DateTimeUtil;
import org.bedework.util.timezones.Timezones;
import org.bedework.webcommon.AdminUtil;
import org.bedework.webcommon.Attendees;
import org.bedework.webcommon.BwActionFormBase;
import org.bedework.webcommon.BwCallback;
import org.bedework.webcommon.BwCallbackImpl;
import org.bedework.webcommon.BwModule;
import org.bedework.webcommon.BwModuleState;
import org.bedework.webcommon.BwRequest;
import org.bedework.webcommon.BwSession;
import org.bedework.webcommon.BwSessionImpl;
import org.bedework.webcommon.BwWebUtil;
import org.bedework.webcommon.FormattedFreeBusy;
import org.bedework.webcommon.ForwardDefs;
import org.bedework.webcommon.TimeDateComponents;
import org.bedework.webcommon.config.ClientConfigurations;

public abstract class BwAbstractAction
extends UtilAbstractAction
implements ForwardDefs {
    private static final String appNameInitParameter = "bwappname";
    private static boolean configTraced;

    public String getId() {
        return this.getClass().getName();
    }

    public abstract int doAction(BwRequest var1, BwActionFormBase var2) throws Throwable;

    public String performAction(Request request, MessageResources messages) throws Throwable {
        String forward;
        int temp;
        PresentationState ps;
        BwSession bsess;
        int status;
        BwActionFormBase form = (BwActionFormBase)request.getForm();
        String adminUserId = null;
        BwCallback cb = this.getCb(request, form);
        try {
            status = cb.in(request);
        }
        catch (Throwable t) {
            this.error(t);
            this.invalidateSession(request);
            return forwards[3];
        }
        if (status != 200) {
            request.getResponse().setStatus(status);
            this.getLogger().error((Object)("Callback.in status=" + status));
            this.invalidateSession(request);
            return forwards[3];
        }
        this.setConfig(request);
        if (form.getConfig().getGuestMode()) {
            form.assignCurrentUser(null);
        } else {
            adminUserId = form.fetchCurrentAdminUser();
            if (adminUserId == null) {
                adminUserId = form.getCurrentUser();
            }
        }
        if (this.debug) {
            this.debugMsg("About to get state");
        }
        if ((bsess = this.getState(request, form, messages, adminUserId)) == null) {
            return forwards[3];
        }
        if (this.debug) {
            this.debugMsg("About to get state");
        }
        form.setSession(bsess);
        BwRequest bwreq = new BwRequest(request, bsess, (Action)this);
        if (bwreq.present("refresh")) {
            bwreq.refresh();
        }
        Collection reqLocales = request.getLocales();
        String reqLoc = request.getReqPar("locale");
        if (reqLoc != null) {
            if ("default".equals(reqLoc)) {
                form.setRequestedLocale(null);
            } else {
                try {
                    Locale loc = Util.makeLocale((String)reqLoc);
                    form.setRequestedLocale(loc);
                }
                catch (Throwable loc) {
                    // empty catch block
                }
            }
        }
        this.checkMvarReq(bwreq);
        Client cl = bwreq.getClient();
        Locale loc = cl.getUserLocale(reqLocales, form.getRequestedLocale());
        BwModuleState mstate = bwreq.getModule().getState();
        if (loc != null) {
            BwLocale.setLocale((Locale)loc);
            Locale cloc = form.getCurrentLocale();
            if (cloc == null | !cloc.equals(loc)) {
                mstate.setRefresh(true);
            }
            form.setCurrentLocale(loc);
        }
        form.assignSuggestionEnabled(cl.getSystemProperties().getSuggestionEnabled());
        form.assignWorkflowEnabled(cl.getSystemProperties().getWorkflowEnabled());
        form.assignWorkflowRoot(cl.getSystemProperties().getWorkflowRoot());
        form.assignCurUserSuperUser(cl.isSuperUser());
        form.assignAdminGroupMaintOK(cl.getAdminGroupMaintOK());
        form.assignUserMaintOK(cl.getUserMaintOK());
        form.assignOneGroup(cl.getOneGroup());
        form.assignAdminUserPrincipal(cl.getCurrentPrincipal());
        mstate.setCalInfo(CalendarInfo.getInstance());
        form.setGuest(bsess.isGuest());
        BwPreferences prefs = cl.getPreferences();
        if (form.getGuest()) {
            form.setPublicView(true);
        } else {
            form.assignImageUploadDirectory(prefs.getDefaultImageDirectory());
        }
        if (cl.getWebSubmit() && request.getReqPar("cs") != null) {
            form.setCalSuiteName(request.getReqPar("cs"));
        }
        if (form.getNewSession()) {
            if (this.debug && !configTraced) {
                this.traceConfig(request);
                configTraced = true;
            }
            form.setHour24(form.getConfig().getHour24());
            if (!(cl.getPublicAdmin() || form.getSubmitApp() || form.getGuest())) {
                form.setHour24(prefs.getHour24());
            }
            form.setEndDateType("duration");
            if (!cl.getPublicAdmin() && !form.getGuest()) {
                form.setEndDateType(prefs.getPreferredEndType());
            }
            bsess.embedFilters(bwreq);
            if (this.debug) {
                this.debugMsg("Filters embedded");
            }
            if (!cl.getPublicAdmin()) {
                String viewType = request.getReqPar("viewType");
                if (viewType != null) {
                    mstate.setViewType(viewType);
                } else {
                    mstate.setViewType(prefs.getPreferredViewPeriod());
                }
            }
        }
        if (this.debug) {
            this.debugMsg("About to prepare render");
        }
        bsess.prepareRender(bwreq);
        if (form.getNewSession()) {
            this.gotoDateView(bwreq, mstate.getDate(), mstate.getViewType());
        }
        if (this.debug) {
            this.debugMsg("current change token: " + bwreq.getSessionAttr("bw_change_token"));
        }
        try {
            String tzid = prefs.getDefaultTzid();
            if (tzid != null) {
                Timezones.setThreadDefaultTzid((String)tzid);
            }
        }
        catch (Throwable tzid) {
            // empty catch block
        }
        if (form.getDirInfo() == null) {
            form.setDirInfo(cl.getDirectoryInfo());
        }
        if ((ps = this.getPresentationState(request)).getAppRoot() == null) {
            ps.setAppRoot(this.suffixRoot(request, form.getConfig().getAppRoot()));
            ps.setBrowserResourceRoot(this.suffixRoot(request, form.getConfig().getBrowserResourceRoot()));
            if (ps.getSkinName() == null) {
                String skinName = prefs.getSkinName();
                ps.setSkinName(skinName);
                ps.setSkinNameSticky(true);
            }
        }
        if ((temp = this.actionSetup(bwreq, form)) != 9) {
            return forwards[temp];
        }
        String reqpar = request.getReqPar("cancelled");
        if (reqpar != null) {
            form.getMsg().emit("org.bedework.client.message.cancelled");
            return forwards[32];
        }
        if (!cl.getPublicAdmin() && !form.getGuest()) {
            InOutBoxInfo ib = form.getInBoxInfo();
            if (ib == null) {
                ib = new InOutBoxInfo(cl, true);
                form.setInBoxInfo(ib);
            } else {
                ib.refresh(cl, false);
            }
        }
        if (!(form.getGuest() || cl.getPublicAdmin() && !cl.getGroupSet())) {
            NotificationInfo ni = form.getNotificationInfo();
            if (ni == null) {
                ni = new NotificationInfo();
                form.setNotificationInfo(ni);
            }
            ni.refresh(cl, false);
        }
        try {
            forward = forwards[this.doAction(bwreq, form)];
        }
        catch (CalFacadeAccessException cfae) {
            form.getErr().emit("org.bedework.client.error.noaccess");
            forward = forwards[4];
            cl.rollback();
        }
        catch (CalFacadeException cfe) {
            form.getErr().emit(cfe.getMessage(), (Object)cfe.getExtra());
            form.getErr().emit((Throwable)cfe);
            forward = forwards[3];
            cl.rollback();
        }
        catch (Throwable t) {
            form.getErr().emit(t);
            forward = forwards[3];
            cl.rollback();
        }
        return forward;
    }

    public int actionSetup(BwRequest request, BwActionFormBase form) throws Throwable {
        Client cl = request.getClient();
        if (cl.getPublicAdmin()) {
            return AdminUtil.actionSetup(request);
        }
        ConfigCommon conf = form.getConfig();
        String refreshAction = request.getRefreshAction();
        Integer refreshInt = request.getRefreshInt();
        if (refreshAction == null) {
            refreshAction = conf.getRefreshAction();
        }
        if (refreshAction == null) {
            refreshAction = request.getActionPath();
        }
        if (refreshAction != null) {
            if (refreshInt == null) {
                refreshInt = conf.getRefreshInterval();
            }
            this.setRefreshInterval(request.getRequest(), request.getResponse(), refreshInt, refreshAction, form);
        }
        return 9;
    }

    public void setConfig(Request request) throws Throwable {
        String appType;
        BwActionFormBase form = (BwActionFormBase)request.getForm();
        if (form.configSet()) {
            return;
        }
        HttpSession session = request.getRequest().getSession();
        ServletContext sc = session.getServletContext();
        String appname = sc.getInitParameter(appNameInitParameter);
        if (appname == null || appname.length() == 0) {
            appname = "unknown-app-name";
        }
        if ((appType = sc.getInitParameter("bwapptype")) == null || appType.length() == 0) {
            throw new Exception("No bwapptype context param");
        }
        ConfigCommon conf = ClientConfigurations.getConfigs().getClientConfig(appname);
        if (conf == null) {
            throw new CalFacadeException("No config available for app " + appname);
        }
        form.setConfig(conf);
        form.assignAppType(appType);
    }

    public PresentationState getPresentationState(Request req) throws Throwable {
        ConfiguredXSLTFilter.XSLTConfig xc;
        BwActionFormBase form = (BwActionFormBase)req.getForm();
        BwModule module = form.fetchModule(req.getModuleName());
        BwModuleState mstate = module.getState();
        PresentationState ps = mstate.getPresentationState();
        if (ps == null) {
            ps = new PresentationState();
            this.initPresentationState(req, ps);
            mstate.setPresentationState(ps);
        }
        if ((xc = mstate.getXsltConfig()) == null) {
            Object o = req.getRequestAttr("org.bedework.util.servlet.filter.AbstractFilter.FilterGlobals");
            xc = o instanceof ConfiguredXSLTFilter.XSLTConfig ? (ConfiguredXSLTFilter.XSLTConfig)o : new ConfiguredXSLTFilter.XSLTConfig();
            mstate.setXsltConfig(xc);
        }
        req.setRequestAttr("org.bedework.util.servlet.filter.AbstractFilter.FilterGlobals", (Object)xc);
        return ps;
    }

    protected int setSearchParams(BwRequest request, SearchParams params, boolean gridMode) throws Throwable {
        int count;
        int offset;
        int max;
        String lim;
        BwActionFormBase form = request.getBwForm();
        BwModuleState mstate = request.getModule().getState();
        Client cl = request.getClient();
        params.setPublicIndexRequested(request.present("public"));
        String startStr = request.getReqPar("start");
        String endStr = request.getReqPar("end");
        this.filterAndQuery(request, params);
        if (gridMode) {
            TimeView tv = mstate.getCurTimeView();
            if (tv == null) {
                params.setFromDate(this.todaysDateTime());
                return 0;
            }
            if (startStr == null) {
                params.setFromDate(tv.getViewStart());
                params.setToDate(tv.getViewEnd());
                return 0;
            }
            BwDateTime bdt = BwDateTimeUtil.getDateTime((String)XcalUtil.getIcalFormatDateTime((String)startStr), (boolean)true, (boolean)false, null);
            this.gotoDateView(request, bdt.getDtval(), mstate.getViewType());
            tv = mstate.getCurTimeView();
            params.setFromDate(tv.getViewStart());
            params.setToDate(tv.getViewEnd());
            return 0;
        }
        if (startStr == null && (lim = mstate.getSearchLimits()) != null && !"none".equals(lim)) {
            if ("beforeToday".equals(lim)) {
                endStr = DateTimeUtil.isoDate((Date)DateTimeUtil.yesterday());
            } else if ("fromToday".equals(lim)) {
                startStr = DateTimeUtil.isoDate((Date)new Date());
            }
        }
        AuthProperties authp = cl.getAuthProperties();
        int days = request.getIntReqPar("days", -32767);
        if (startStr == null && endStr == null) {
            if (!(cl.getWebSubmit() || cl.getPublicAdmin() || request.getBooleanReqPar("listAllEvents", false))) {
                params.setFromDate(this.todaysDateTime());
                max = authp.getMaxWebCalPeriod();
                if (days < 0) {
                    days = max;
                } else if (days > max && !cl.isSuperUser()) {
                    days = max;
                }
                params.setToDate(params.getFromDate().addDur(new Dur(days, 0, 0, 0)));
            }
        } else if (endStr != null || days > 0) {
            BwTimeRange tr;
            max = 0;
            if (!cl.isSuperUser()) {
                max = authp.getMaxWebCalPeriod();
            }
            if ((tr = BwDateTimeUtil.getPeriod((String)startStr, (String)endStr, (int)5, (int)days, (int)5, (int)max)) == null) {
                form.getErr().emit("org.bedework.client.error.badrequest", (Object)"dates");
                return 9;
            }
            params.setFromDate(tr.getStart());
            params.setToDate(tr.getEnd());
        } else {
            params.setFromDate(BwDateTimeUtil.getDateTime((String)XcalUtil.getIcalFormatDateTime((String)startStr), (boolean)true, (boolean)false, null));
            params.setToDate(params.getFromDate().addDur(new Dur(authp.getMaxWebCalPeriod().intValue(), 0, 0, 0)));
        }
        if (params.getFromDate() != null) {
            this.gotoDateView(request, params.getFromDate().getDtval(), mstate.getViewType());
        }
        if ((offset = request.getIntReqPar("offset", -1)) > 0) {
            params.setCurOffset(offset);
        }
        if ((count = request.getIntReqPar("count", -1)) < 0) {
            count = cl.getPreferences().getPageSize();
        }
        if (count < 0) {
            count = 20;
        }
        if (count > 250) {
            count = 250;
        }
        params.setPageSize(count);
        params.setFormat(request.getReqPar("format"));
        if (request.getBooleanReqPar("master", false)) {
            params.setRecurMode(RecurringRetrievalMode.entityOnly);
        }
        return 0;
    }

    private boolean filterAndQuery(BwRequest request, SearchParams params) throws Throwable {
        BwActionFormBase form = request.getBwForm();
        Client cl = request.getClient();
        params.setQuery(request.getReqPar("query"));
        params.setRelevance(request.getBooleanReqPar("relevance", false));
        GetFilterDefResponse gfdr = request.getFilterDef();
        if (gfdr.getStatus() != Response.Status.ok) {
            params.setStatus(gfdr.getStatus());
            params.setMessage(gfdr.getMessage());
            return false;
        }
        FilterBase filter = null;
        if (gfdr.getFilterDef() != null) {
            filter = gfdr.getFilterDef().getFilters();
        }
        if (cl.getWebSubmit() || cl.getPublicAdmin()) {
            boolean ignoreCreator = false;
            if (request.getBooleanReqPar("sg", false) || request.getBooleanReqPar("ignoreCreator", false)) {
                ignoreCreator = true;
            }
            if (!ignoreCreator) {
                BwCreatorFilter crefilter = new BwCreatorFilter(null);
                crefilter.setEntity((Object)cl.getCurrentPrincipalHref());
                filter = FilterBase.addAndChild((FilterBase)filter, (FilterBase)crefilter);
            }
        }
        params.setFilter(filter);
        String sort = request.getReqPar("sort");
        if (sort == null) {
            sort = "dtstart.utc:asc";
        }
        SimpleFilterParser.ParseResult pr = cl.parseSort(sort);
        if (!pr.ok) {
            form.getErr().emit(pr.message);
            params.setStatus(Response.Status.failed);
            params.setMessage(pr.message);
            return false;
        }
        params.setSort(pr.sortTerms);
        return true;
    }

    protected BwDateTime todaysDateTime() throws Throwable {
        return BwDateTimeUtil.getDateTime((String)DateTimeUtil.isoDate(), (boolean)true, (boolean)false, null);
    }

    protected FilterBase addor(FilterBase filter, BwCategory cat) {
        BwCategoryFilter f = new BwCategoryFilter(null);
        f.setEntity((Object)cat);
        f.setExact(false);
        if (filter == null) {
            return f;
        }
        if (!(filter instanceof OrFilter)) {
            OrFilter orFilter = new OrFilter();
            orFilter.addChild(filter);
            filter = orFilter;
        }
        filter.addChild((FilterBase)f);
        return filter;
    }

    protected void emitScheduleStatus(BwActionFormBase form, ScheduleResult sr, boolean errorsOnly) {
        if (sr.errorCode != null) {
            form.getErr().emit(sr.errorCode, sr.extraInfo);
        }
        if (sr.ignored) {
            form.getMsg().emit("org.bedework.client.message.schedule.ignored");
        }
        if (sr.reschedule) {
            form.getMsg().emit("org.bedework.client.message.schedule.rescheduled");
        }
        if (sr.update) {
            form.getMsg().emit("org.bedework.client.message.schedule.updated");
        }
        for (ScheduleResult.ScheduleRecipientResult srr : sr.recipientResults.values()) {
            if (srr.getStatus() == 2) {
                form.getMsg().emit("org.bedework.client.message.schedule.deferred", (Object)srr.recipient);
                continue;
            }
            if (srr.getStatus() == 1) {
                form.getErr().emit("org.bedework.client.error.noschedulingaccess", (Object)srr.recipient);
                continue;
            }
            if (errorsOnly) continue;
            form.getMsg().emit("org.bedework.client.message.schedule.sent", (Object)srr.recipient);
        }
    }

    protected BwPrincipal findPrincipal(BwRequest request) throws Throwable {
        String str = request.getReqPar("user");
        if (str == null) {
            request.getErr().emit("org.bedework.client.error.unknown.user", (Object)"null");
            return null;
        }
        BwPrincipal p = request.getClient().getUser(str);
        if (p == null) {
            request.getErr().emit("org.bedework.client.error.unknown.user", (Object)str);
            return null;
        }
        return p;
    }

    protected SetEntityCategoriesResult setEntityCategories(BwRequest request, Set<BwCategory> extraCats, CategorisedEntity ent, ChangeTable changes) throws Throwable {
        Client cl = request.getClient();
        SetEntityCategoriesResult secr = new SetEntityCategoriesResult();
        Set evcats = ent.getCategories();
        Set defCatuids = cl.getPreferences().getDefaultCategoryUids();
        Set allDefCatUids = cl.getDefaultPublicCategoryUids();
        List strCatUids = request.getReqPars("catUid");
        if (Util.isEmpty((Collection)strCatUids) && Util.isEmpty(extraCats) && Util.isEmpty((Collection)defCatuids) && Util.isEmpty((Collection)allDefCatUids)) {
            if (!Util.isEmpty((Collection)evcats)) {
                if (changes != null) {
                    ChangeTableEntry cte = changes.getEntry(PropertyIndex.PropertyInfoIndex.CATEGORIES);
                    cte.setRemovedValues(new ArrayList(evcats));
                }
                secr.numRemoved = evcats.size();
                evcats.clear();
            }
            secr.rcode = 0;
            return secr;
        }
        TreeSet<BwCategory> cats = new TreeSet<BwCategory>();
        if (extraCats != null) {
            cats.addAll(extraCats);
        }
        if (!Util.isEmpty((Collection)defCatuids)) {
            for (String uid : defCatuids) {
                cats.add(cl.getPersistentCategory(uid));
            }
        }
        if (!Util.isEmpty((Collection)allDefCatUids) && evcats != null) {
            block1: for (Iterator catUid : allDefCatUids) {
                for (BwCategory evcat : evcats) {
                    if (!evcat.getUid().equals(catUid)) continue;
                    cats.add(evcat);
                    continue block1;
                }
            }
        }
        if (!Util.isEmpty((Collection)strCatUids)) {
            block3: for (Iterator catUid : strCatUids) {
                BwCategory cat;
                if (evcats != null) {
                    for (BwCategory evcat : evcats) {
                        if (!evcat.getUid().equals(catUid)) continue;
                        cats.add(evcat);
                        continue block3;
                    }
                }
                if ((cat = cl.getPersistentCategory((String)((Object)catUid))) == null) continue;
                cats.add(cat);
            }
        }
        ArrayList<BwCategory> toRemove = new ArrayList<BwCategory>();
        if (evcats != null) {
            for (BwCategory evcat : evcats) {
                if (cats.contains(evcat)) {
                    cats.remove(evcat);
                    continue;
                }
                toRemove.add(evcat);
            }
        }
        for (BwCategory cat : cats) {
            ent.addCategory(cat);
            ++secr.numAdded;
        }
        for (BwCategory cat : toRemove) {
            if (!evcats.remove(cat)) continue;
            ++secr.numRemoved;
        }
        if (changes != null && secr.numAdded > 0 && secr.numRemoved > 0) {
            ChangeTableEntry cte = changes.getEntry(PropertyIndex.PropertyInfoIndex.CATEGORIES);
            cte.setRemovedValues(toRemove);
            cte.setAddedValues(cats);
        }
        secr.rcode = 0;
        if (secr.numCreated > 0) {
            request.getMsg().emit("org.bedework.client.message.added.categories", secr.numCreated);
        }
        return secr;
    }

    /*
     * Enabled aggressive block sorting
     */
    public int doFreeBusy(BwRequest request, BwActionFormBase form, Attendees atts, String st, String et, String intunitStr, int interval) throws Throwable {
        BwDuration dur;
        ScheduleResult sr;
        BwDateTime edt;
        BwDateTime sdt;
        BwModuleState mstate;
        Client cl;
        block13: {
            block14: {
                block15: {
                    String originator;
                    Calendar end;
                    Calendar start;
                    cl = request.getClient();
                    mstate = request.getModule().getState();
                    if (st == null) {
                        TimeView tv = request.getSess().getCurTimeView(request);
                        start = (Calendar)tv.getFirstDay().clone();
                        end = tv.getLastDay();
                        end.add(5, 1);
                    } else {
                        start = mstate.getCalInfo().getFirstDayOfThisWeek((TimeZone)Timezones.getDefaultTz(), DateTimeUtil.fromISODate((String)st));
                        end = (Calendar)start.clone();
                        end.add(3, 1);
                    }
                    Calendar check = Calendar.getInstance(mstate.getCalInfo().getLocale());
                    check.setTime(start.getTime());
                    check.add(5, 32);
                    if (check.before(end)) {
                        return 33;
                    }
                    sdt = BwDateTimeUtil.getDateTime((Date)start.getTime());
                    BwEvent fbreq = BwEventObj.makeFreeBusyRequest((BwDateTime)sdt, (BwDateTime)(edt = BwDateTimeUtil.getDateTime((Date)end.getTime())), null, (String)(originator = cl.getCurrentCalendarAddress()), atts.getAttendees(), atts.getRecipients());
                    if (fbreq == null) {
                        return 33;
                    }
                    sr = cl.schedule(new EventInfo(fbreq), null, null, false);
                    if (this.debug) {
                        this.debugMsg(sr.toString());
                    }
                    if (sr.recipientResults != null) {
                        for (ScheduleResult.ScheduleRecipientResult srr : sr.recipientResults.values()) {
                            if (srr.getStatus() == 0) continue;
                            form.getMsg().emit("org.bedework.client.message.freebusy.unavailable", (Object)srr.recipient);
                        }
                    }
                    dur = new BwDuration();
                    if (interval <= 0) {
                        form.getErr().emit("org.bedework.client.error.badinterval", interval);
                        return 3;
                    }
                    if (intunitStr == null) break block14;
                    if (!"minutes".equals(intunitStr)) break block15;
                    dur.setMinutes(interval);
                    break block13;
                }
                if ("hours".equals(intunitStr)) {
                    dur.setHours(interval);
                    break block13;
                } else if ("days".equals(intunitStr)) {
                    dur.setDays(interval);
                    break block13;
                } else {
                    if (!"weeks".equals(intunitStr)) {
                        form.getErr().emit("org.bedework.client.error.badintervalunit", interval);
                        return 3;
                    }
                    dur.setWeeks(interval);
                }
                break block13;
            }
            dur.setHours(interval);
        }
        SchedulingI.FbResponses resps = cl.aggregateFreeBusy(sr, sdt, edt, dur);
        form.setFbResponses(resps);
        FormattedFreeBusy ffb = new FormattedFreeBusy(resps.getAggregatedResponse(), mstate.getCalInfo().getLocale());
        form.setFormattedFreeBusy(ffb);
        this.emitScheduleStatus(form, sr, true);
        return 0;
    }

    protected EventInfo findEvent(BwRequest request, RecurringRetrievalMode.Rmode mode) throws Throwable {
        Client cl = request.getClient();
        EventInfo ev = null;
        String href = request.getReqPar("href");
        if (href != null) {
            EventKey ekey = new EventKey(href, false);
            ev = cl.getEvent(ekey.getColPath(), ekey.getName(), ekey.getRecurrenceId());
            if (ev == null) {
                request.getForm().getErr().emit("org.bedework.client.error.unknown.event", (Object)ekey.getName());
                return null;
            }
            if (this.debug) {
                this.debugMsg("Get event found " + ev.getEvent());
            }
            return ev;
        }
        BwCalendar cal = request.getCalendar(true);
        if (cal == null) {
            return null;
        }
        String guid = request.getReqPar("guid");
        String eventName = request.getReqPar("eventName");
        if (eventName == null) {
            eventName = request.getReqPar("contentName");
        }
        if (guid != null) {
            RecurringRetrievalMode rrm;
            if (this.debug) {
                this.debugMsg("Get event by guid");
            }
            String rid = request.getReqPar("recurrenceId");
            if (mode == RecurringRetrievalMode.Rmode.overrides) {
                rrm = RecurringRetrievalMode.overrides;
                rid = null;
            } else {
                rrm = mode == RecurringRetrievalMode.Rmode.expanded ? RecurringRetrievalMode.expanded : new RecurringRetrievalMode(mode);
            }
            Collection evs = cl.getEventByUid(cal.getPath(), guid, rid, rrm);
            if (this.debug) {
                this.debugMsg("Get event by guid found " + evs.size());
            }
            if (evs.size() == 1) {
                ev = (EventInfo)evs.iterator().next();
            } else if (evs.size() > 1) {
                this.warn("Multiple result from getEvent");
            }
        } else if (eventName != null) {
            if (this.debug) {
                this.debugMsg("Get event by name");
            }
            ev = cl.getEvent(cal.getPath(), eventName, null);
        }
        if (ev == null) {
            request.getForm().getErr().emit("org.bedework.client.error.unknown.event", (Object)guid);
            return null;
        }
        if (this.debug) {
            this.debugMsg("Get event found " + ev.getEvent());
        }
        return ev;
    }

    protected BwLocation getLocation(Client cl, BwActionFormBase form, String owner, boolean webSubmit) throws Throwable {
        String a;
        BwLocation loc = null;
        if (!webSubmit && (a = Util.checkNull((String)form.getLocationAddress().getValue())) != null) {
            loc = BwLocation.makeLocation();
            BwString addr = new BwString(null, a);
            loc.setAddress(addr);
        }
        if (loc == null && form.getLocationUid() != null) {
            loc = cl.getPersistentLocation(form.getLocationUid());
        }
        if (loc != null) {
            loc.setLink(Util.checkNull((String)loc.getLink()));
            String ownerHref = owner;
            if (ownerHref == null) {
                ownerHref = cl.getCurrentPrincipalHref();
            }
            Client.CheckEntityResult cer = cl.ensureLocationExists(loc, ownerHref);
            loc = (BwLocation)cer.getEntity();
            if (cer.getAdded()) {
                form.getMsg().emit("org.bedework.client.message.added.locations", 1);
            }
        }
        return loc;
    }

    protected BwCalendar findCalendar(BwRequest request, String url) throws CalFacadeException {
        if (url == null) {
            return null;
        }
        return request.getClient().getCollection(url);
    }

    protected ProcessedImage processImage(BwRequest request, FormFile file) {
        ProcessedImage pi;
        block21: {
            pi = new ProcessedImage();
            Client cl = request.getClient();
            try {
                byte[] thumbContent;
                long maxSize = cl.getUserMaxEntitySize();
                if ((long)file.getFileSize() > maxSize) {
                    request.getErr().emit("org.bedework.validation.error.toolarge", (Object)file.getFileSize(), (Object)maxSize);
                    pi.retry = true;
                    return pi;
                }
                BwCalendar imageCol = null;
                String imagecolPath = cl.getPreferences().getDefaultImageDirectory();
                if (imagecolPath == null) {
                    BwCalendar home = cl.getHome();
                    String imageColName = "Images";
                    imagecolPath = Util.buildPath((boolean)false, (String[])new String[]{home.getPath(), "/", "Images"});
                    imageCol = cl.getCollection(imagecolPath);
                    if (imageCol == null) {
                        imageCol = new BwCalendar();
                        imageCol.setSummary("Images");
                        imageCol.setName("Images");
                        imageCol = cl.addCollection(imageCol, home.getPath());
                    }
                } else {
                    imageCol = cl.getCollection(imagecolPath);
                    if (imageCol == null) {
                        request.getErr().emit("org.bedework.client.error.missingimagedirectory");
                        return pi;
                    }
                }
                String thumbType = "png";
                Filenames fns = this.makeFilenames(file.getFileName(), "png");
                boolean replace = false;
                boolean replaceThumb = false;
                pi.image = cl.getResource(Util.buildPath((boolean)false, (String[])new String[]{imageCol.getPath(), "/", fns.fn}));
                if (pi.image != null) {
                    if (!request.getBooleanReqPar("replaceImage", false)) {
                        request.getErr().emit("org.bedework.client.error.duplicateimage");
                        pi.retry = true;
                        return pi;
                    }
                    replace = true;
                    if (!cl.getResourceContent(pi.image)) {
                        request.getErr().emit("Missing content for " + imageCol.getPath() + "/" + fns.fn);
                        pi.retry = true;
                        return pi;
                    }
                } else {
                    pi.image = new BwResource();
                    pi.image.setName(fns.fn);
                }
                byte[] fileData = file.getFileData();
                try {
                    thumbContent = ImageProcessing.createThumbnail((InputStream)new ByteArrayInputStream(fileData), (String)"png", (int)160);
                }
                catch (Throwable t) {
                    if (this.debug) {
                        this.error(t);
                    }
                    request.getErr().emit("org.bedework.client.error.imageerror");
                    pi.retry = true;
                    return pi;
                }
                cl.setResourceValue(pi.image, fileData);
                pi.image.setContentType(file.getContentType());
                pi.thumbnail = cl.getResource(Util.buildPath((boolean)false, (String[])new String[]{imageCol.getPath(), "/", fns.thumbFn}));
                if (pi.thumbnail != null) {
                    replaceThumb = true;
                    if (!cl.getResourceContent(pi.image)) {
                        request.getErr().emit("Missing content for " + imageCol.getPath() + "/" + fns.thumbFn);
                        pi.retry = true;
                        return pi;
                    }
                } else {
                    pi.thumbnail = new BwResource();
                    pi.thumbnail.setName(fns.thumbFn);
                }
                pi.thumbnail.setContentType("image/png");
                cl.setResourceValue(pi.thumbnail, thumbContent);
                if (!replace) {
                    cl.saveResource(imageCol.getPath(), pi.image);
                } else {
                    cl.updateResource(pi.image, true);
                }
                if (!replaceThumb) {
                    cl.saveResource(imageCol.getPath(), pi.thumbnail);
                } else {
                    cl.updateResource(pi.thumbnail, true);
                }
                pi.OK = true;
            }
            catch (Throwable t) {
                if (!this.debug) break block21;
                this.error(t);
                request.getErr().emit(t);
            }
        }
        return pi;
    }

    private Filenames makeFilenames(String imageName, String thumbType) {
        int dotPos = imageName.lastIndexOf(46);
        Filenames fns = new Filenames();
        String dt = new SimpleDateFormat("yyyyMMddhhmm").format(new Date());
        if (dotPos < 0) {
            fns.fn = imageName + "-" + dt;
            fns.thumbFn = fns.fn + "-thumb." + thumbType;
        } else {
            String namePart = imageName.substring(0, dotPos) + "-" + dt;
            fns.fn = namePart + imageName.substring(dotPos);
            fns.thumbFn = namePart + "-thumb." + thumbType;
        }
        return fns;
    }

    protected boolean logOutCleanup(HttpServletRequest request, UtilActionForm form) {
        HttpSession hsess = request.getSession();
        BwCallback cb = (BwCallback)hsess.getAttribute("org.bedework.webcommon.SvciFilter");
        if (cb == null) {
            if (form.getDebug()) {
                this.debugMsg("No cb object for logout");
            }
        } else {
            if (form.getDebug()) {
                this.debugMsg("cb object found for logout");
            }
            try {
                cb.out(request);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                cb.close(request, true);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return true;
    }

    protected String checkLogOut(Request request) throws Throwable {
        String temp = request.getReqPar(this.requestLogout);
        if (temp != null) {
            HttpSession sess = request.getRequest().getSession(false);
            if (sess != null) {
                sess.invalidate();
            }
            return "loggedOut";
        }
        return null;
    }

    protected void invalidateSession(Request request) {
        HttpSession sess = request.getRequest().getSession(false);
        if (sess != null) {
            sess.invalidate();
        }
    }

    protected void gotoDateView(BwRequest request, String date, String newViewType) throws Throwable {
        int year;
        MyCalendarVO dt;
        Date jdt;
        BwModuleState mstate = request.getModule().getState();
        boolean newView = false;
        if (this.debug) {
            this.debugMsg("ViewType=" + newViewType);
        }
        if ("todayView".equals(newViewType)) {
            jdt = new Date(System.currentTimeMillis());
            dt = new MyCalendarVO(jdt);
            newView = true;
            newViewType = "dayView";
        } else if (date == null) {
            if ("dayView".equals(newViewType)) {
                jdt = BwDateTimeUtil.getDate((BwDateTime)mstate.getViewStartDate().getDateTime());
                dt = new MyCalendarVO(jdt);
                newView = true;
            } else {
                if (this.debug) {
                    this.debugMsg("No date supplied: go with current date");
                }
                if ((dt = mstate.getViewMcDate()) == null) {
                    dt = new MyCalendarVO(new Date(System.currentTimeMillis()));
                }
            }
        } else {
            if (this.debug) {
                this.debugMsg("Date=" + date + ": go with that");
            }
            if (!this.checkDateInRange(request, (dt = new MyCalendarVO(jdt = DateTimeUtil.fromISODate((String)date))).getYear())) {
                jdt = new Date(System.currentTimeMillis());
                dt = new MyCalendarVO(jdt);
            }
            newView = true;
        }
        if (!newView) {
            if (mstate.getCurTimeView() == null) {
                newView = true;
            } else if (newViewType != null && !newViewType.equals(mstate.getCurTimeView().getViewType())) {
                newView = true;
            }
        }
        if (newView && newViewType == null && (newViewType = mstate.getViewType()) == null) {
            newViewType = BedeworkDefs.viewPeriodNames[2];
        }
        TimeDateComponents viewStart = mstate.getViewStartDate();
        if (!newView && this.checkDateInRange(request, year = viewStart.getYear())) {
            String vsdate = viewStart.getDateTime().getDtval().substring(0, 8);
            if (this.debug) {
                this.debugMsg("vsdate=" + vsdate);
            }
            if (!vsdate.equals(request.getSess().getCurTimeView(request).getFirstDayFmt().getDateDigits())) {
                newView = true;
                newViewType = mstate.getViewType();
                Date jdt2 = DateTimeUtil.fromISODate((String)vsdate);
                dt = new MyCalendarVO(jdt2);
            }
        }
        if (newView) {
            mstate.setViewType(newViewType);
            mstate.setViewMcDate(dt);
            mstate.setRefresh(true);
            request.getClient().clearSearchEntries();
            request.getClient().clearSearch();
        }
        TimeView tv = request.getSess().getCurTimeView(request);
        Calendar firstDay = tv.getFirstDay();
        viewStart.setDay(firstDay.get(5));
        viewStart.setMonth(firstDay.get(2) + 1);
        viewStart.setYear(firstDay.get(1));
    }

    protected void setViewDate(BwRequest request, String date) throws Throwable {
        BwModuleState mstate = request.getModule().getState();
        Date jdt = DateTimeUtil.fromISODate((String)date);
        MyCalendarVO dt = new MyCalendarVO(jdt);
        if (this.debug) {
            this.debugMsg("calvo dt = " + dt);
        }
        if (!this.checkDateInRange(request, dt.getYear())) {
            jdt = new Date(System.currentTimeMillis());
            dt = new MyCalendarVO(jdt);
        }
        mstate.setViewMcDate(dt);
        mstate.setRefresh(true);
    }

    private boolean checkDateInRange(BwRequest req, int year) throws Throwable {
        BwActionFormBase form = req.getBwForm();
        int thisYear = form.getToday().getFormatted().getYear();
        if (year < thisYear - 50 || year > thisYear + 50) {
            form.getErr().emit("org.bedework.validation.error.invalid.date", year);
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BwSession getState(Request request, BwActionFormBase form, MessageResources messages, String adminUserId) throws Throwable {
        BwActionFormBase bwActionFormBase = form;
        synchronized (bwActionFormBase) {
            BwSession s = BwWebUtil.getState(request.getRequest());
            HttpSession sess = request.getRequest().getSession(false);
            String appName = this.getAppName(sess);
            if (s != null) {
                if (this.debug) {
                    this.debugMsg("getState-- obtainedfrom session");
                    this.debugMsg("getState-- timeout interval = " + sess.getMaxInactiveInterval());
                }
                form.assignNewSession(false);
            } else {
                if (this.debug) {
                    this.debugMsg("getState-- get new object");
                }
                form.assignNewSession(true);
                s = new BwSessionImpl(form.getConfig(), form.getCurrentUser(), appName);
                BwWebUtil.setState(request.getRequest(), s);
                String raddr = request.getRemoteAddr();
                String rhost = request.getRemoteHost();
                this.info("===============" + appName + ": New session (" + s.getSessionNum() + ") from " + rhost + "(" + raddr + ")");
                if (!form.getConfig().getPublicAdmin()) {
                    int refInt = 60;
                    int timeout = sess.getMaxInactiveInterval();
                    if (timeout <= 60) {
                        this.debugMsg("@+@+@+@+@+ set timeout to 120");
                        sess.setMaxInactiveInterval(120);
                    }
                }
            }
            this.checkSvci(request, s, adminUserId, false);
            return s;
        }
    }

    private String getAppName(HttpSession sess) {
        ServletContext sc = sess.getServletContext();
        String appname = sc.getInitParameter(appNameInitParameter);
        if (appname == null) {
            appname = "?";
        }
        return appname;
    }

    boolean checkSvci(Request request, BwSession sess, String user, boolean canSwitch) throws Throwable {
        BwActionFormBase form = (BwActionFormBase)request.getForm();
        ConfigCommon conf = form.getConfig();
        boolean publicAdmin = conf.getPublicAdmin();
        boolean guestMode = conf.getGuestMode();
        String calSuiteName = null;
        BwCallback cb = this.getCb(request, form);
        BwModule module = form.fetchModule(request.getModuleName());
        BwModuleState mstate = module.getState();
        Object client = module.getClient();
        if ("feeder".equals(conf.getAppType())) {
            calSuiteName = request.getReqPar("cs", conf.getCalSuite());
        } else if (guestMode) {
            calSuiteName = conf.getCalSuite();
        } else if (publicAdmin & client != null) {
            BwCalSuiteWrapper cs = AdminUtil.findCalSuite(request, client);
            form.setCurrentCalSuite(cs);
            if (cs != null) {
                boolean adminGroupImpliesApprover;
                calSuiteName = cs.getName();
                client.setCalSuite((BwCalSuite)cs);
                List approvers = client.getCalsuitePreferences().getCalsuiteApproversList();
                if (approvers.contains(form.getCurrentUser())) {
                    form.assignCurUserApproverUser(true);
                }
                if ((adminGroupImpliesApprover = ((AdminConfig)form.getConfig()).getAdminGroupApprovers()) && cs.getGroup() != null && cs.getGroup().getAccount().equals(form.getAdminGroupName())) {
                    form.assignCurUserApproverUser(true);
                }
            }
            form.setCalSuiteName(calSuiteName);
            if (this.debug) {
                if (cs != null) {
                    this.debugOut("Found calSuite " + cs);
                } else {
                    this.debugOut("No calsuite found");
                }
            }
        } else if (!user.equals(form.getCurrentUser())) {
            return false;
        }
        boolean reinitClient = false;
        try {
            BwPrincipal pr;
            if (client != null) {
                if (publicAdmin) {
                    pr = client.getCurrentPrincipal();
                    if (pr == null) {
                        throw new CalFacadeException("Null user for public admin.");
                    }
                    canSwitch = canSwitch || form.getCurUserContentAdminUser() || form.getCurUserSuperUser();
                    String curUser = pr.getAccount();
                    if (!user.equals(curUser)) {
                        if (!canSwitch) {
                            return false;
                        }
                        client.endTransaction();
                        client.close();
                        reinitClient = true;
                        sess.reset(request);
                        cb.close(request.getRequest(), true);
                    }
                }
                if (this.debug) {
                    this.debugMsg("Client interface -- Obtained from session for user " + client.getCurrentPrincipalHref());
                }
                if (reinitClient) {
                    if (this.debug) {
                        this.debugMsg("Client-- reinit for user " + user);
                    }
                    form.flushModules(request.getModuleName());
                    if (guestMode) {
                        ((ROClientImpl)client).reinit(form.getCurrentUser(), user, calSuiteName, form.getAppType(), true);
                    } else if (publicAdmin) {
                        ((AdminClientImpl)client).reinit(form.getCurrentUser(), user, calSuiteName, (AdminConfig)form.getConfig());
                    } else {
                        ((ClientImpl)client).reinit(form.getCurrentUser(), user, form.getAppType());
                    }
                    cb.in(request);
                    mstate.setRefresh(true);
                }
            } else {
                if (this.debug) {
                    this.debugMsg("Client-- getResource new object for user " + user);
                }
                client = guestMode ? new ROClientImpl(module.getModuleName(), form.getCurrentUser(), user, calSuiteName, form.getAppType(), true) : (publicAdmin ? new AdminClientImpl(module.getModuleName(), form.getCurrentUser(), user, calSuiteName, (AdminConfig)form.getConfig()) : new ClientImpl(module.getModuleName(), form.getCurrentUser(), user, form.getAppType()));
                module.setClient((Client)client);
                module.setRequest(request);
                module.requestIn();
                mstate.setRefresh(true);
                sess.reset(request);
            }
            if (client.getPublicAdmin()) {
                pr = client.getCurrentPrincipal();
                form.assignCurrentAdminUser(pr.getAccount());
            }
        }
        catch (CalFacadeException cfe) {
            throw cfe;
        }
        catch (Throwable t) {
            throw new CalFacadeException(t);
        }
        return true;
    }

    private BwCallback getCb(Request request, BwActionFormBase form) throws Throwable {
        HttpSession hsess = request.getRequest().getSession();
        BwCallback cb = (BwCallback)hsess.getAttribute("org.bedework.webcommon.SvciFilter");
        if (cb == null) {
            cb = new BwCallbackImpl(form, request.getMapping());
            hsess.setAttribute("org.bedework.webcommon.SvciFilter", (Object)cb);
        }
        if (this.debug) {
            this.debugMsg("checkSvci-- set req in cb - form action path = " + request.getActionPath() + " conv-type = " + request.getConversationType());
        }
        return cb;
    }

    private boolean checkMvarReq(BwRequest request) throws Throwable {
        List mvs = request.getReqPars("setmvar");
        if (mvs == null) {
            return true;
        }
        BwModuleState state = request.getModule().getState();
        for (String reqpar : mvs) {
            int start;
            if (reqpar.endsWith("}")) {
                start = reqpar.indexOf(123);
            } else if (reqpar.endsWith(")")) {
                start = reqpar.indexOf(40);
            } else {
                return false;
            }
            if (start < 0) {
                return false;
            }
            String varName = reqpar.substring(0, start);
            String varVal = reqpar.substring(start + 1, reqpar.length() - 1);
            if (varVal.length() == 0) {
                varVal = null;
            }
            if (state.setVar(varName, varVal)) continue;
            return false;
        }
        return true;
    }

    private String suffixRoot(Request req, String val) throws Throwable {
        String calSuite;
        BwActionFormBase form = (BwActionFormBase)req.getForm();
        StringBuilder sb = new StringBuilder(val);
        String portalPlatform = form.getConfig().getPortalPlatform();
        if (this.isPortlet && portalPlatform != null) {
            sb.append(".");
            sb.append(portalPlatform);
        }
        if (!"websubmit".equals(form.getConfig().getAppType()) && (calSuite = form.getConfig().getCalSuite()) != null) {
            sb.append(".");
            sb.append(calSuite);
        }
        return sb.toString();
    }

    public String validViewPeriod(String val) {
        Integer i;
        int vt = 2;
        if ((val = Util.checkNull((String)val)) != null && (i = BwRequest.viewTypeMap.get(val)) != null) {
            vt = i;
        }
        return BedeworkDefs.viewPeriodNames[vt];
    }

    protected <T extends Response> T errorReturn(T resp, Throwable t, Response.Status st) {
        return this.errorReturn(resp, t.getLocalizedMessage(), st);
    }

    protected <T extends Response> T errorReturn(T resp, String msg, Response.Status st) {
        resp.setMessage(msg);
        resp.setStatus(st);
        return resp;
    }

    protected <T extends Response> T okReturn(T resp) {
        resp.setStatus(Response.Status.ok);
        return resp;
    }

    private static class Filenames {
        String fn;
        String thumbFn;

        private Filenames() {
        }
    }

    public static class ProcessedImage {
        public boolean OK;
        public boolean retry;
        public BwResource image;
        public BwResource thumbnail;
    }

    protected static class SetEntityCategoriesResult {
        public int rcode = 9;
        public int numCreated;
        public int numAdded;
        public int numRemoved;

        protected SetEntityCategoriesResult() {
        }
    }
}

