/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.webcommon;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.config.ForwardConfig;
import org.apache.struts.util.RequestUtils;
import org.bedework.util.struts.Request;
import org.bedework.webcommon.BwActionFormBase;
import org.bedework.webcommon.BwCallback;
import org.bedework.webcommon.BwModule;

public class BwCallbackImpl
extends BwCallback {
    protected boolean debug = false;
    private transient Logger log;
    final BwActionFormBase form;
    ActionForward errorForward;

    BwCallbackImpl(BwActionFormBase form, ActionMapping mapping) {
        this.form = form;
        this.debug = this.getLogger().isDebugEnabled();
        this.errorForward = mapping.findForward("error");
        if (this.errorForward == null) {
            throw new RuntimeException("Forward \"error\" must be defined in struts-comfig");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int in(Request req) throws Throwable {
        BwActionFormBase bwActionFormBase = this.form;
        synchronized (bwActionFormBase) {
            BwModule module = this.form.fetchModule(req.getModuleName());
            if (this.debug) {
                this.getLogger().debug((Object)("About to claim module " + module.getModuleName()));
            }
            if (!module.claim()) {
                return 503;
            }
            req.setRequestAttr("mdl", (Object)module.getModuleName());
            module.setRequest(req);
            module.requestIn();
            return 200;
        }
    }

    @Override
    public void out(HttpServletRequest hreq) throws Throwable {
        BwModule module = this.form.fetchModule((String)hreq.getAttribute("mdl"));
        if (this.debug) {
            this.getLogger().debug((Object)("Request out for module " + module.getModuleName()));
        }
        module.requestOut();
    }

    @Override
    public void close(HttpServletRequest hreq, boolean cleanUp) throws Throwable {
        BwModule module = this.form.fetchModule((String)hreq.getAttribute("mdl"));
        if (this.debug) {
            this.getLogger().debug((Object)("Close for module " + module.getModuleName()));
        }
        module.close(cleanUp);
    }

    @Override
    public void error(HttpServletRequest hreq, HttpServletResponse hresp, Throwable t) throws Throwable {
        this.form.getErr().emit(t);
        String forwardPath = this.errorForward.getPath();
        String uri = forwardPath.startsWith("/") ? RequestUtils.forwardURL((HttpServletRequest)hreq, (ForwardConfig)this.errorForward, null) : forwardPath;
        if (uri.startsWith("/")) {
            uri = hreq.getContextPath() + uri;
        }
        try {
            hresp.sendRedirect(hresp.encodeRedirectURL(uri));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public Logger getLogger() {
        if (this.log == null) {
            this.log = Logger.getLogger(this.getClass());
        }
        return this.log;
    }
}

