/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.webcommon;

import java.io.Serializable;
import javax.servlet.http.HttpSession;
import org.bedework.appcommon.client.Client;
import org.bedework.util.misc.Logged;
import org.bedework.util.misc.Util;
import org.bedework.util.struts.Request;
import org.bedework.webcommon.BwModuleState;

public class BwModule
extends Logged
implements Serializable {
    public static final String defaultModuleName = "default";
    private final String moduleName;
    private Client cl;
    private final BwModuleState state;
    private String whenClaimed;
    private int waiters;
    private boolean inuse;
    private long timeIn;
    private Request currentReq;

    public BwModule(String moduleName, Client cl) {
        this.moduleName = moduleName;
        this.cl = cl;
        this.state = new BwModuleState(moduleName);
    }

    public String getModuleName() {
        return this.moduleName;
    }

    public void setClient(Client val) {
        this.cl = val;
    }

    public Client getClient() {
        return this.cl;
    }

    public BwModuleState getState() {
        return this.state;
    }

    public void setRequest(Request val) {
        this.currentReq = val;
    }

    public Request getRequest() {
        return this.currentReq;
    }

    public void incWaiters() {
        ++this.waiters;
    }

    public void decWaiters() {
        --this.waiters;
    }

    public int getWaiters() {
        return this.waiters;
    }

    public void setInuse(boolean val) {
        this.inuse = val;
    }

    public boolean getInuse() {
        return this.inuse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean claim() {
        int attempts = 0;
        while (this.getInuse()) {
            if (this.debug) {
                this.debug("Module " + this.getModuleName() + " in use by " + this.getWaiters() + " Timestamp: " + this.whenClaimed);
            }
            if (this.getWaiters() > 10 || attempts > 3) {
                return false;
            }
            this.incWaiters();
            try {
                this.wait(5000L);
                ++attempts;
            }
            catch (InterruptedException e) {
                boolean bl = false;
                return bl;
            }
            finally {
                this.decWaiters();
            }
        }
        this.setInuse(true);
        this.whenClaimed = Util.icalUTCTimestamp();
        return true;
    }

    public void requestIn() throws Throwable {
        if (this.getClient() == null) {
            return;
        }
        this.setInuse(true);
        this.timeIn = System.currentTimeMillis();
        this.getClient().requestIn(this.currentReq.getConversationType());
    }

    public void requestOut() throws Throwable {
        if (this.getClient() == null) {
            return;
        }
        this.cl.requestOut(this.currentReq.getConversationType(), this.currentReq.getActionType(), System.currentTimeMillis() - this.timeIn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close(boolean cleanUp) throws Throwable {
        HttpSession sess;
        int convType = this.currentReq.getConversationType();
        try {
            if (cleanUp) {
                this.closeNow();
            } else if (convType == 0) {
                if (this.currentReq.getActionType() != 2) {
                    this.closeNow();
                }
            } else if (convType == 3 || convType == 4) {
                this.closeNow();
            }
        }
        finally {
            BwModule bwModule = this;
            synchronized (bwModule) {
                this.setInuse(false);
                this.notify();
            }
        }
        if ((this.getClient() == null || "feeder".equals(this.getClient().getAppType())) && (sess = this.currentReq.getRequest().getSession(false)) != null) {
            sess.invalidate();
        }
    }

    private void closeNow() throws Throwable {
        Throwable t = null;
        try {
            Client cl = this.getClient();
            if (cl != null) {
                cl.close();
            }
        }
        catch (Throwable t1) {
            t = t1;
        }
        if (t != null) {
            throw t;
        }
    }
}

