/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.webcommon;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bedework.appcommon.BedeworkDefs;
import org.bedework.appcommon.CalendarInfo;
import org.bedework.appcommon.MyCalendarVO;
import org.bedework.appcommon.TimeView;
import org.bedework.calfacade.indexing.SearchResult;
import org.bedework.calfacade.indexing.SearchResultEntry;
import org.bedework.util.misc.Util;
import org.bedework.util.servlet.filters.ConfiguredXSLTFilter;
import org.bedework.util.servlet.filters.PresentationState;
import org.bedework.webcommon.BwRequest;
import org.bedework.webcommon.EventDates;
import org.bedework.webcommon.TimeDateComponents;

public class BwModuleState
implements Serializable {
    private String moduleName;
    private boolean refresh;
    private PresentationState ps;
    private ConfiguredXSLTFilter.XSLTConfig xsltConfig;
    private static final int maxAppVars = 50;
    Map<String, String> vars = new HashMap<String, String>();
    private TimeDateComponents viewStartDate;
    private CalendarInfo calInfo;
    private EventDates eventDates;
    private String selectionType = "view";
    private String date;
    private String viewType;
    private int curViewPeriod = -1;
    private MyCalendarVO viewMcDate;
    private TimeView curTimeView;
    private String query;
    private SearchResult searchResult;
    private List<SearchResultEntry> searchResultEntries;
    private String searchLimits = "fromToday";
    private TimeView.CalFmt curDayFmt;
    private TimeView.CalFmt firstDayFmt;
    private TimeView.CalFmt lastDayFmt;

    public BwModuleState(String moduleName) {
        this.moduleName = moduleName;
    }

    public void setRefresh(boolean val) {
        this.refresh = val;
    }

    public boolean getRefresh() {
        return this.refresh;
    }

    public void setPresentationState(PresentationState val) {
        this.ps = val;
    }

    public PresentationState getPresentationState() {
        return this.ps;
    }

    public void setXsltConfig(ConfiguredXSLTFilter.XSLTConfig val) {
        this.xsltConfig = val;
    }

    public ConfiguredXSLTFilter.XSLTConfig getXsltConfig() {
        return this.xsltConfig;
    }

    public String getModuleName() {
        return this.moduleName;
    }

    public void setCalInfo(CalendarInfo val) {
        this.calInfo = val;
    }

    public CalendarInfo getCalInfo() {
        return this.calInfo;
    }

    public void assignEventDates(EventDates val) {
        this.eventDates = val;
    }

    public EventDates getEventDates() {
        return this.eventDates;
    }

    public TimeDateComponents getViewStartDate() {
        if (this.viewStartDate == null) {
            this.viewStartDate = this.getEventDates().getNowTimeComponents();
        }
        return this.viewStartDate;
    }

    public void updateViewStartDate(BwRequest req) throws Throwable {
        if (req.present("viewStartDate.year")) {
            this.getViewStartDate().setYear(req.getIntReqPar("viewStartDate.year"));
        }
        if (req.present("viewStartDate.month")) {
            this.getViewStartDate().setMonth(req.getIntReqPar("viewStartDate.month"));
        }
        if (req.present("viewStartDate.day")) {
            this.getViewStartDate().setDay(req.getIntReqPar("viewStartDate.day"));
        }
    }

    public void setViewMcDate(MyCalendarVO val) {
        this.viewMcDate = val;
    }

    public MyCalendarVO getViewMcDate() {
        return this.viewMcDate;
    }

    public void setCurTimeView(TimeView val) {
        this.curTimeView = val;
        if (val != null) {
            this.curDayFmt = val.getCurDayFmt();
            this.firstDayFmt = val.getFirstDayFmt();
            this.lastDayFmt = val.getLastDayFmt();
        }
    }

    public TimeView getCurTimeView() {
        return this.curTimeView;
    }

    public TimeView.CalFmt getCurDayFmt() {
        return this.curDayFmt;
    }

    public TimeView.CalFmt getFirstDayFmt() {
        return this.firstDayFmt;
    }

    public TimeView.CalFmt getLastDayFmt() {
        return this.lastDayFmt;
    }

    public void setViewType(String val) {
        this.viewType = Util.checkNull((String)val);
        if (this.viewType == null) {
            return;
        }
        Integer i = BwRequest.viewTypeMap.get(this.viewType);
        if (i == null) {
            i = 2;
            this.viewType = BedeworkDefs.viewPeriodNames[i];
        }
        if (i != this.curViewPeriod) {
            this.curViewPeriod = i;
            this.refresh = true;
        }
    }

    public String getViewType() {
        return this.viewType;
    }

    public void setCurViewPeriod(int val) {
        this.curViewPeriod = val;
    }

    public int getCurViewPeriod() {
        return this.curViewPeriod;
    }

    public boolean setVar(String name, String val) {
        if (val == null) {
            this.vars.remove(name);
            return true;
        }
        if (this.vars.size() > 50) {
            return false;
        }
        this.vars.put(name, val);
        return true;
    }

    public String getVar(String name) {
        return this.vars.get(name);
    }

    public void setSearchResult(SearchResult val) {
        this.searchResult = val;
    }

    public SearchResult getSearchResult() {
        return this.searchResult;
    }

    public void setQuery(String val) {
        this.query = val;
    }

    public String getQuery() {
        return this.query;
    }

    public void setSearchLimits(String val) {
        this.searchLimits = val;
    }

    public String getSearchLimits() {
        return this.searchLimits;
    }

    public void setSelectionType(String val) {
        this.selectionType = val;
    }

    public String getSelectionType() {
        return this.selectionType;
    }

    public void setDate(String val) {
        this.date = val;
    }

    public String getDate() {
        return this.date;
    }
}

