/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.webcommon;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.apache.struts.action.Action;
import org.bedework.appcommon.BedeworkDefs;
import org.bedework.appcommon.EventKey;
import org.bedework.appcommon.client.Client;
import org.bedework.calfacade.BwCalendar;
import org.bedework.calfacade.BwDateTime;
import org.bedework.calfacade.BwEvent;
import org.bedework.calfacade.BwFilterDef;
import org.bedework.calfacade.filter.SimpleFilterParser;
import org.bedework.calfacade.responses.GetFilterDefResponse;
import org.bedework.calfacade.responses.Response;
import org.bedework.calfacade.svc.EventInfo;
import org.bedework.calfacade.util.ChangeTable;
import org.bedework.util.calendar.PropertyIndex;
import org.bedework.util.misc.Util;
import org.bedework.util.struts.Request;
import org.bedework.util.timezones.Timezones;
import org.bedework.webcommon.BwActionFormBase;
import org.bedework.webcommon.BwModule;
import org.bedework.webcommon.BwSession;

public class BwRequest
extends Request {
    private BwSession sess;
    private Request req;
    private BwModule module;
    private Client cl;
    static HashMap<String, Integer> viewTypeMap = new HashMap();
    public static final String embeddedClientName = "bw_embedded_client";
    public static final String eventStateName = "bw_event_state";
    public static final String moduleStateName = "bw_module_state";
    public static final String bwFeatureFlagsName = "bw_feature_flags";
    public static final String bwCachePrefixName = "bw_cache_prefix";
    public static final String bwAuthUsersListName = "bw_auth_users";
    public static final String bwAdminGroupsInfoName = "bw_admin_groups";
    public static final String bwCsAdminGroupsInfoName = "bw_suite_admin_groups";
    public static final String bwPreferredAdminGroupsInfoName = "bw_preferred_admin_groups";
    public static final String bwUserAdminGroupsInfoName = "bw_user_admin_groups";
    public static final String bwUserSearchableAdminGroups = "bw_user_admin_search_groups";
    public static final String bwSearchParamsName = "bw_search_params";
    public static final String bwSearchResultName = "bw_search_result";
    public static final String bwSearchListName = "bw_search_list";
    public static final String bwFiltersListName = "bw_filters_list";
    public static final String bwCollectionListName = "bw_collection_list";
    public static final String bwPublicCollectionListName = "bw_public_collection_list";
    public static final String bwUserCollectionListName = "bw_user_collection_list";
    public static final String bwAddContentCollectionListName = "bw_addcontent_collection_list";
    public static final String bwPreferencesName = "bw_preferences";
    public static final String bwViewsListName = "bw_views_list";
    public static final String bwCategoriesListName = "bw_categories_list";
    public static final String bwDefaultCategoriesListName = "bw_default_categories_list";
    public static final String bwEditableCategoriesListName = "bw_editable_categories_list";
    public static final String bwPreferredCategoriesListName = "bw_preferred_categories_list";
    public static final String bwContactsListName = "bw_contacts_list";
    public static final String bwEditableContactsListName = "bw_editable_contacts_list";
    public static final String bwPreferredContactsListName = "bw_preferred_contacts_list";
    public static final String bwLocationsListName = "bw_locations_list";
    public static final String bwPreferredLocationsListName = "bw_preferred_locations_list";
    public static final String bwEditableLocationsListName = "bw_editable_locations_list";
    public static final String bwReqUidName = "bw_req_uid";
    public static final String bwReqVpollTabName = "bw_req_vpoll_tab";
    public static final String bwDefaultEventCalendar = "bw_default_event_calendar";
    public static final String bwSubscriptionStatus = "bw_subscription_status";

    public BwRequest(Request request, BwSession sess, Action action) {
        super(request.getRequest(), request.getResponse(), request.getForm(), action, request.getMapping());
        this.req = request;
        this.sess = sess;
    }

    public BwSession getSess() {
        return this.sess;
    }

    public BwModule getModule() {
        if (this.module == null) {
            this.module = this.getBwForm().fetchModule(this.req.getModuleName());
            this.request.setAttribute(moduleStateName, (Object)this.module.getState());
        }
        return this.module;
    }

    public Client getClient() {
        if (this.cl == null) {
            this.cl = this.getBwForm().fetchClient(this.req.getModuleName());
            this.request.setAttribute(embeddedClientName, (Object)this.cl);
        }
        return this.cl;
    }

    public BwActionFormBase getBwForm() {
        return (BwActionFormBase)this.getForm();
    }

    public void refresh() {
        this.getModule().getState().setRefresh(true);
    }

    public boolean hasCopy() {
        return this.present("copy");
    }

    public boolean hasDelete() {
        return this.present("delete");
    }

    public boolean hasMarkDeleted() {
        return this.present("markDeleted");
    }

    public boolean hasExport() {
        return this.present("export");
    }

    public int getEntityType() {
        String s = this.getReqPar("entityType");
        if (s == null || "event".equals(s)) {
            return 0;
        }
        if ("task".equals(s)) {
            return 2;
        }
        if ("journal".equals(s)) {
            return 3;
        }
        if ("freebusy".equals(s)) {
            return 4;
        }
        this.getErr().emit("org.bedework.validation.error.invalid.entitytype", (Object)s);
        return 0;
    }

    public GetFilterDefResponse getFilterDef() {
        BwFilterDef fd;
        GetFilterDefResponse gfdr;
        Client cl = this.getClient();
        String name = this.getReqPar("filterName");
        String fexpr = this.getReqPar("fexpr");
        if (name == null && (fexpr == null || fexpr.equals("no--filter"))) {
            return new GetFilterDefResponse();
        }
        if (name != null) {
            gfdr = cl.getFilter(name);
            if (gfdr.getStatus() == Response.Status.notFound) {
                this.form.getErr().emit("org.bedework.client.error.unknown.filter", (Object)name);
                return gfdr;
            }
            if (gfdr.getStatus() != Response.Status.ok) {
                this.form.getErr().emit("org.bedework.client.error.exc", (Object)gfdr.getMessage());
                return gfdr;
            }
        } else {
            fexpr = fexpr.replace("-_", "|");
            gfdr = new GetFilterDefResponse();
            gfdr.setFilterDef(new BwFilterDef());
            gfdr.getFilterDef().setDefinition(fexpr);
        }
        if ((fd = gfdr.getFilterDef()).getFilters() == null) {
            SimpleFilterParser.ParseResult pr = cl.parseFilter(fd);
            if (!pr.ok) {
                gfdr.setStatus(Response.Status.failed);
                gfdr.setMessage(pr.message + " expression: " + fd.getDefinition());
                this.getErr().emit(gfdr.getMessage());
                return gfdr;
            }
        }
        return gfdr;
    }

    public Collection<BwDateTime> getRdates(boolean evDateOnly) throws Throwable {
        return this.getRExdates(true, evDateOnly);
    }

    public Collection<BwDateTime> getExdates(boolean evDateOnly) throws Throwable {
        return this.getRExdates(false, evDateOnly);
    }

    private Collection<BwDateTime> getRExdates(boolean rdates, boolean evDateOnly) throws Throwable {
        String[] dts;
        String token = "DATE\t";
        ArrayList<BwDateTime> bwdts = new ArrayList<BwDateTime>();
        String reqPar = rdates ? "rdates" : "exdates";
        String dtsPar = this.getReqPar(reqPar);
        if (dtsPar == null) {
            return bwdts;
        }
        for (String dtVal : dts = dtsPar.split(token)) {
            if (dtVal == null || dtVal.length() == 0) continue;
            String[] dtParts = dtVal.split("\t");
            StringBuilder dtm = new StringBuilder(dtParts[0]);
            boolean dateOnly = true;
            if (!evDateOnly && Util.checkNull((String)dtParts[1]) != null) {
                dtm.append("T");
                dtm.append(dtParts[1]);
                dtm.append("00");
                dateOnly = false;
            }
            String tzid = null;
            if (!evDateOnly && dtParts.length > 2) {
                tzid = Util.checkNull((String)dtParts[2]);
            }
            bwdts.add(BwDateTime.makeBwDateTime((boolean)dateOnly, (String)dtm.toString(), tzid));
        }
        return bwdts;
    }

    public String getDate() {
        String date = this.getReqPar("date");
        return date;
    }

    public String getViewType() throws Throwable {
        String vt = this.getReqPar("viewType");
        if (vt == null) {
            return null;
        }
        if (viewTypeMap.get(vt) == null) {
            return null;
        }
        return vt;
    }

    public BwDateTime getDateTime(String dtPar, String tzidPar) throws Throwable {
        String dt = this.getReqPar(dtPar);
        if (dt == null) {
            return null;
        }
        String tzid = this.getReqPar(tzidPar);
        if (tzid == null) {
            tzid = Timezones.getThreadDefaultTzid();
        }
        return BwDateTime.makeBwDateTime((dt.indexOf("T") < 0 ? 1 : 0) != 0, (String)dt, (String)tzid);
    }

    public BwCalendar getNewCal(boolean required) throws Throwable {
        String newCalPath = this.getReqPar("newCalPath");
        BwCalendar newCal = null;
        if (newCalPath == null) {
            if (required) {
                this.getErr().emit("org.bedework.validation.error.missingcalendar");
            }
            return null;
        }
        newCal = this.getClient().getCollection(newCalPath);
        if (newCal == null) {
            this.getErr().emit("org.bedework.client.error.unknown.calendar", (Object)newCalPath);
            return null;
        }
        return newCal;
    }

    public boolean setEventCalendar(EventInfo ei, ChangeTable changes) throws Throwable {
        BwEvent ev = ei.getEvent();
        BwCalendar cal = this.getNewCal(false);
        if (this.form.getErrorsEmitted()) {
            return false;
        }
        if (cal == null && ev.getColPath() == null) {
            this.getErr().emit("org.bedework.validation.error.missingcalendar");
            return false;
        }
        if (cal != null) {
            changes.changed(PropertyIndex.PropertyInfoIndex.COLLECTION, (Object)ev.getColPath(), (Object)cal.getPath());
            ev.setColPath(cal.getPath());
        }
        return true;
    }

    public Collection<BwCalendar> getCalendars() throws Throwable {
        List calPaths = this.getReqPars("calPath");
        ArrayList<BwCalendar> cals = new ArrayList<BwCalendar>();
        if (calPaths == null) {
            return cals;
        }
        for (String calPath : calPaths) {
            BwCalendar cal = this.getClient().getCollection(calPath);
            if (cal == null) continue;
            cals.add(cal);
        }
        return cals;
    }

    public BwCalendar getCollection(boolean required) throws Throwable {
        return this.getCalendar("colHref", required);
    }

    public String getCua(boolean required) throws Throwable {
        String cua = this.getReqPar("cua");
        if (cua == null) {
            this.getErr().emit("org.bedework.client.error.badrequest", (Object)"Missing cua");
            return null;
        }
        return cua;
    }

    public BwCalendar getCalendar(boolean required) throws Throwable {
        if (this.present("calPath")) {
            return this.getCalendar("calPath", required);
        }
        return this.getCalendar("colPath", required);
    }

    public BwCalendar getCalendar(String reqParName, boolean required) throws Throwable {
        String calPath = this.getReqPar(reqParName);
        if (calPath == null) {
            if (required) {
                this.getErr().emit("org.bedework.validation.error.missingcalendarpath");
            }
            return null;
        }
        BwCalendar cal = this.getClient().getCollection(calPath);
        if (cal == null) {
            this.getErr().emit("org.bedework.client.error.unknown.calendar", (Object)calPath);
            return null;
        }
        return cal;
    }

    public int getSchedule() throws Throwable {
        String schedStr = this.getReqPar("schedule");
        if (schedStr == null) {
            return 0;
        }
        if ("none".equals(schedStr)) {
            return 0;
        }
        if ("request".equals(schedStr)) {
            return 2;
        }
        if ("reconfirm".equals(schedStr)) {
            return 6;
        }
        if ("publish".equals(schedStr)) {
            return 1;
        }
        this.getErr().emit("org.bedework.validation.error.invalid.schedmethod", (Object)schedStr);
        return 0;
    }

    public EventKey makeEventKey(boolean forExport) throws Throwable {
        EventKey ekey;
        String href = this.getReqPar("href");
        if (href != null) {
            return new EventKey(href, forExport);
        }
        String calPath = this.getReqPar("calPath");
        if (calPath == null) {
            this.getErr().emit("org.bedework.validation.error.missingcalendarpath");
            return null;
        }
        BwCalendar cal = this.getClient().getCollection(calPath);
        if (cal == null) {
            this.getErr().emit("org.bedework.client.error.noaccess");
            return null;
        }
        String guid = this.getReqPar("guid");
        String rid = null;
        String eventName = this.getReqPar("eventName");
        if (guid != null) {
            if (this.getReqPar("master") != null) {
                forExport = true;
            }
            if (!forExport) {
                rid = this.getReqPar("recurrenceId");
            }
            ekey = new EventKey(calPath, guid, rid, forExport);
        } else if (eventName != null) {
            ekey = new EventKey(calPath, eventName, forExport);
        } else {
            this.getErr().emit("org.bedework.client.error.missingeventkeyfields");
            return null;
        }
        return ekey;
    }

    public void embedCalsuiteAdminGroups() throws Throwable {
        this.setSessionAttr(bwCsAdminGroupsInfoName, this.getClient().getCalsuiteAdminGroups());
    }

    public void embedAdminGroups() throws Throwable {
        this.setSessionAttr(bwAdminGroupsInfoName, this.getClient().getAdminGroups());
    }

    static {
        for (int i = 0; i < BedeworkDefs.viewPeriodNames.length; ++i) {
            viewTypeMap.put(BedeworkDefs.viewPeriodNames[i], i);
        }
    }
}

