/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.webcommon;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import org.bedework.appcommon.BedeworkDefs;
import org.bedework.appcommon.CollectionCollator;
import org.bedework.appcommon.ConfigCommon;
import org.bedework.appcommon.DayView;
import org.bedework.appcommon.MonthView;
import org.bedework.appcommon.MyCalendarVO;
import org.bedework.appcommon.TimeView;
import org.bedework.appcommon.WeekView;
import org.bedework.appcommon.YearView;
import org.bedework.appcommon.client.Client;
import org.bedework.caldav.util.filter.FilterBase;
import org.bedework.calfacade.BwCalendar;
import org.bedework.calfacade.BwCategory;
import org.bedework.calfacade.BwContact;
import org.bedework.calfacade.BwEvent;
import org.bedework.calfacade.BwFilterDef;
import org.bedework.calfacade.BwLocation;
import org.bedework.calfacade.BwPrincipal;
import org.bedework.calfacade.configs.AuthProperties;
import org.bedework.calfacade.filter.SimpleFilterParser;
import org.bedework.calfacade.responses.CollectionsResponse;
import org.bedework.calfacade.responses.GetFilterDefResponse;
import org.bedework.calfacade.responses.Response;
import org.bedework.calfacade.svc.prefs.BwAuthUserPrefs;
import org.bedework.calfacade.svc.wrappers.BwCalSuiteWrapper;
import org.bedework.util.misc.Logged;
import org.bedework.util.struts.Request;
import org.bedework.webcommon.BwActionFormBase;
import org.bedework.webcommon.BwModuleState;
import org.bedework.webcommon.BwRequest;
import org.bedework.webcommon.BwSession;
import org.bedework.webcommon.ColCloner;
import org.bedework.webcommon.EventDates;

public class BwSessionImpl
extends Logged
implements BwSession {
    private final ConfigCommon config;
    private final boolean publicAdmin;
    private BwAuthUserPrefs curAuthUserPrefs;
    private static final ConcurrentHashMap<String, Counts> countsMap = new ConcurrentHashMap();
    private long sessionNum = 0L;
    private static final String[] publicCollectionsChangeToken = new String[]{null, null};
    private static final BwCalendar[] clonedPublicCollections = new BwCalendar[]{null, null};
    private String user;
    private AuthProperties authpars;
    private transient CollectionCollator<BwContact> contactCollator;
    private transient CollectionCollator<BwCategory> categoryCollator;
    private transient CollectionCollator<BwLocation> locationCollator;

    public BwSessionImpl(ConfigCommon config, String user, String appName) throws Throwable {
        this.config = config;
        this.user = user;
        this.debug = this.getLogger().isDebugEnabled();
        this.publicAdmin = config.getPublicAdmin();
        this.setSessionNum(appName);
    }

    @Override
    public void reset(Request req) {
        req.setSessionAttr("bw_change_token", (Object)"");
    }

    @Override
    public long getSessionNum() {
        return this.sessionNum;
    }

    @Override
    public void setUser(String val) {
        this.user = val;
    }

    @Override
    public String getUser() {
        return this.user;
    }

    @Override
    public boolean isGuest() {
        return this.user == null;
    }

    @Override
    public void prepareRender(BwRequest req) {
        BwActionFormBase form = req.getBwForm();
        Client cl = req.getClient();
        BwModuleState mstate = req.getModule().getState();
        req.setRequestAttr("bw_search_params", cl.getSearchParams());
        req.setRequestAttr("bw_search_result", mstate.getSearchResult());
        try {
            boolean needRefresh;
            BwPrincipal p;
            String featureFlags;
            mstate.updateViewStartDate(req);
            String cacheUrl = cl.getSystemProperties().getCacheUrlPrefix();
            if (cacheUrl != null) {
                req.setSessionAttr("bw_cache_prefix", cacheUrl);
            }
            if ((featureFlags = cl.getSystemProperties().getFeatureFlags()) != null) {
                req.setSessionAttr("bw_feature_flags", featureFlags);
            }
            if (cl.getPublicAdmin() && (p = cl.getAuthPrincipal()) != null) {
                Collection adgs = !cl.isSuperUser() ? cl.getGroups(p) : cl.getAllGroups(false);
                req.setSessionAttr("bw_user_admin_search_groups", adgs);
            }
            form.assignCalendarUserAddress(cl.getCurrentCalendarAddress());
            if (form.getEventDates() == null) {
                form.assignEventDates(new EventDates(cl.getCurrentPrincipalHref(), mstate.getCalInfo(), form.getHour24(), form.getEndDateType(), this.config.getMinIncrement(), form.getErr()));
            }
            if (mstate.getEventDates() == null) {
                mstate.assignEventDates(form.getEventDates());
            }
            mstate.getEventDates().setHour24(form.getHour24());
            String lastChangeToken = (String)req.getSessionAttr("bw_change_token");
            String changeToken = cl.getCurrentChangeToken();
            boolean bl = needRefresh = lastChangeToken == null || !lastChangeToken.equals(changeToken);
            if (needRefresh) {
                cl.flushCached();
            }
            req.setSessionAttr("bw_change_token", changeToken);
            if (!mstate.getRefresh() || needRefresh) {
                String appType = cl.getAppType();
                if (!"feeder".equals(appType)) {
                    this.embedFilters(req);
                    if (cl.getPublicAdmin() || cl.getWebSubmit()) {
                        if (this.debug) {
                            this.debug("About to embed collections");
                        }
                        this.embedCollections(req);
                    }
                    if (this.debug) {
                        this.debug("About to embed public collections");
                    }
                    this.embedPublicCollections(req);
                    if (this.debug) {
                        this.debug("About to embed user collections");
                    }
                    this.embedUserCollections(req);
                    if (this.debug) {
                        this.debug("About to embed views");
                    }
                    this.embedViews(req);
                }
                if (this.debug) {
                    this.debug("About to embed prefs");
                }
                this.embedPrefs(req);
                if (this.debug) {
                    this.debug("After embed prefs");
                }
                this.authpars = cl.getAuthProperties().cloneIt();
                form.setAuthPars(this.authpars);
                form.setEventRegAdminToken(cl.getSystemProperties().getEventregAdminToken());
                form.setCurrentGroups(cl.getCurrentPrincipal().getGroups());
            }
            if (mstate.getRefresh() || mstate.getCurTimeView() == null) {
                this.refreshView(req);
            }
        }
        catch (Throwable t) {
            form.getErr().emit(t);
        }
    }

    @Override
    public CollectionsResponse getCollections(BwRequest req) {
        CollectionsResponse cols = new CollectionsResponse();
        if ("true".equals(req.getStringActionPar("public="))) {
            if (req.getReqPar("cs") != null) {
                cols.setCollections(this.getUserCollections(req));
            } else {
                cols.setPublicCollections(this.getPublicCollections(req));
            }
        } else {
            cols.setUserCollections(this.getUserCollections(req));
        }
        cols.setStatus(Response.Status.ok);
        return cols;
    }

    @Override
    public void embedFilters(BwRequest req) throws Throwable {
        req.setSessionAttr("bw_filters_list", req.getClient().getAllFilters());
    }

    @Override
    public TimeView getCurTimeView(BwRequest req) {
        BwModuleState mstate = req.getModule().getState();
        if (mstate.getCurTimeView() == null) {
            this.refreshView(req);
        }
        return mstate.getCurTimeView();
    }

    @Override
    public AuthProperties getAuthpars() {
        return this.authpars;
    }

    @Override
    public void embedAddContentCalendarCollections(BwRequest request) throws Throwable {
        request.setSessionAttr("bw_addcontent_collection_list", request.getClient().getAddContentCollections(!this.publicAdmin));
    }

    @Override
    public void embedCollections(BwRequest request) {
        BwCalendar cloned = this.getAppCollections(request);
        if (cloned != null) {
            request.setSessionAttr("bw_collection_list", cloned);
        }
    }

    protected void embedPublicCollections(BwRequest request) {
        BwCalendar cloned = this.getPublicCollections(request);
        if (cloned != null) {
            request.setSessionAttr("bw_public_collection_list", cloned);
        }
    }

    @Override
    public void embedUserCollections(BwRequest request) {
        BwCalendar cloned = this.getUserCollections(request);
        if (cloned != null) {
            request.setSessionAttr("bw_user_collection_list", cloned);
        }
    }

    public BwCalendar getAppCollections(BwRequest request) {
        BwActionFormBase form = request.getBwForm();
        Client cl = request.getClient();
        try {
            BwCalendar cloned;
            BwCalendar col = form.getSubmitApp() ? cl.getCollection(form.getConfig().getSubmissionRoot()) : cl.getHome();
            if (col == null) {
                request.getErr().emit("No home collection");
                return null;
            }
            if (col.getPath().equals(cl.getPublicCalendarsRootPath())) {
                if (this.debug) {
                    this.debug("Return public root");
                }
                return this.getPublicCollections(request);
            }
            if (this.debug) {
                this.debug("About to clone: " + col.getPath());
            }
            if ((cloned = this.getClonedCollection(request, col, false)) == null) {
                this.warn("Unable to clone " + col);
                request.getErr().emit("Unable to clone home collection");
                return null;
            }
            if (this.debug) {
                this.debug("Cloned: " + col.getPath());
            }
            return cloned;
        }
        catch (Throwable t) {
            request.getErr().emit(t);
            return null;
        }
    }

    protected BwCalendar getPublicCollections(BwRequest request) {
        try {
            BwCalendar root;
            boolean fromCopy;
            Client cl = request.getClient();
            String changeToken = cl.getCurrentChangeToken();
            int accessIndex = cl.isSuperUser() ? 0 : 1;
            boolean bl = fromCopy = clonedPublicCollections[accessIndex] != null && publicCollectionsChangeToken[accessIndex] != null && publicCollectionsChangeToken[accessIndex].equals(changeToken);
            if (!fromCopy) {
                this.debug("Discarding cached public and rebuilding");
                root = cl.getPublicCalendars();
            } else {
                root = clonedPublicCollections[accessIndex];
            }
            if (root == null) {
                request.getErr().emit("Unable to access public collections");
                this.warn("Unable to access public collections");
                return null;
            }
            BwSessionImpl.clonedPublicCollections[accessIndex] = this.getClonedCollection(request, root, fromCopy);
            if (clonedPublicCollections[accessIndex] == null) {
                return null;
            }
            BwSessionImpl.publicCollectionsChangeToken[accessIndex] = changeToken;
            return clonedPublicCollections[accessIndex];
        }
        catch (Throwable t) {
            request.getErr().emit(t);
            return null;
        }
    }

    public BwCalendar getUserCollections(BwRequest request) {
        BwActionFormBase form = request.getBwForm();
        Client cl = request.getClient();
        boolean publicAdmin = cl.getPublicAdmin();
        try {
            BwCalendar col;
            BwPrincipal p;
            if (cl.getWebSubmit()) {
                String calSuiteName = form.getCalSuiteName();
                if (calSuiteName == null) {
                    calSuiteName = form.getConfig().getCalSuite();
                    form.setCalSuiteName(calSuiteName);
                }
                if (calSuiteName == null) {
                    this.error("No default calendar suite - nor one requested");
                    return null;
                }
                BwCalSuiteWrapper cs = cl.getCalSuite(calSuiteName);
                if (cs == null) {
                    form.getErr().emit("No calendar suite with name ", (Object)calSuiteName);
                    return null;
                }
                form.setCurrentCalSuite(cs);
                p = cl.getPrincipal(cs.getGroup().getOwnerHref());
                if (this.debug) {
                    this.debug("Get Calendar home for " + p.getPrincipalRef());
                }
                col = cl.getHome(p, false);
            } else {
                p = publicAdmin && form.getCurrentCalSuite() != null ? cl.getPrincipal(form.getCurrentCalSuite().getGroup().getOwnerHref()) : cl.getCurrentPrincipal();
                if (this.debug) {
                    this.debug("Get Calendar home for " + p.getPrincipalRef());
                }
                col = cl.getHome(p, false);
            }
            if (col == null) {
                this.warn("No home collection for " + p.getPrincipalRef());
                return null;
            }
            BwCalendar cloned = this.getClonedCollection(request, col, false);
            if (cloned == null) {
                this.warn("Unable to clone " + col);
                request.getErr().emit("Unable to clone user collection");
                return null;
            }
            return cloned;
        }
        catch (Throwable t) {
            request.getErr().emit(t);
            return null;
        }
    }

    @Override
    public Collection<BwCategory> embedCategories(BwRequest request, boolean refresh, int kind) throws Throwable {
        TreeSet<BwCategory> vals;
        String attrName;
        if (kind == 1) {
            attrName = "bw_categories_list";
            vals = (Set)request.getSessionAttr(attrName);
            if (!refresh && vals != null) {
                return vals;
            }
            vals = this.getCategoryCollection(request, 1, true);
        } else if (kind == 2) {
            attrName = "bw_editable_categories_list";
            vals = (Collection)request.getSessionAttr(attrName);
            if (!refresh && vals != null) {
                return vals;
            }
            vals = this.getCategoryCollection(request, 2, false);
        } else if (kind == 3) {
            attrName = "bw_preferred_categories_list";
            vals = this.curAuthUserPrefs.getCategoryPrefs().getPreferred();
        } else if (kind == 4) {
            attrName = "bw_default_categories_list";
            vals = (Set)request.getSessionAttr(attrName);
            if (!refresh && vals != null) {
                return vals;
            }
            vals = new TreeSet<BwCategory>();
            Client cl = request.getClient();
            Set catuids = cl.getPreferences().getDefaultCategoryUids();
            for (String uid : catuids) {
                BwCategory cat = cl.getCategory(uid);
                if (cat == null) continue;
                vals.add(cat);
            }
        } else {
            throw new Exception("Software error - bad kind " + kind);
        }
        request.setSessionAttr(attrName, vals);
        return vals;
    }

    @Override
    public Collection<BwCategory> getCategoryCollection(BwRequest request, int kind, boolean forEventUpdate) throws Throwable {
        BwActionFormBase form = request.getBwForm();
        Client cl = request.getClient();
        Collection vals = null;
        if (kind == 1) {
            String appType = cl.getAppType();
            if (cl.getWebSubmit() || "webpublic".equals(appType) || "feeder".equals(appType)) {
                vals = cl.getPublicCategories();
            } else {
                vals = cl.getCategories();
                BwEvent ev = form.getEvent();
                if (!this.publicAdmin && forEventUpdate && ev != null && ev.getCategories() != null) {
                    for (BwCategory cat : ev.getCategories()) {
                        if (cat.getOwnerHref().equals(cl.getCurrentPrincipalHref())) continue;
                        vals.add(cat);
                    }
                }
            }
        } else if (kind == 2) {
            vals = cl.getEditableCategories();
        }
        if (vals == null) {
            return null;
        }
        return this.getCategoryCollator().getCollatedCollection(vals);
    }

    @Override
    public void embedContactCollection(BwRequest request, int kind) throws Throwable {
        Collection vals;
        String attrName;
        Client cl = request.getClient();
        if (kind == 1) {
            attrName = "bw_contacts_list";
            vals = cl.getWebSubmit() ? cl.getPublicContacts() : cl.getContacts();
        } else if (kind == 2) {
            attrName = "bw_editable_contacts_list";
            vals = cl.getEditableContacts();
        } else if (kind == 3) {
            attrName = "bw_preferred_contacts_list";
            vals = this.curAuthUserPrefs.getContactPrefs().getPreferred();
        } else {
            throw new RuntimeException("Software error - bad kind " + kind);
        }
        request.setSessionAttr(attrName, this.getContactCollator().getCollatedCollection(vals));
    }

    @Override
    public void embedLocations(BwRequest request, int kind) throws Throwable {
        Collection vals;
        String attrName;
        if (kind == 1) {
            attrName = "bw_locations_list";
            vals = this.getLocations(request, 1, true);
        } else if (kind == 2) {
            attrName = "bw_editable_locations_list";
            vals = this.getLocations(request, 2, false);
        } else if (kind == 3) {
            attrName = "bw_preferred_locations_list";
            vals = this.curAuthUserPrefs.getLocationPrefs().getPreferred();
        } else {
            throw new Exception("Software error - bad kind " + kind);
        }
        request.setSessionAttr(attrName, this.getLocationCollator().getCollatedCollection(vals));
    }

    @Override
    public void embedViews(BwRequest request) throws Throwable {
        request.setSessionAttr("bw_views_list", request.getClient().getAllViews());
    }

    @Override
    public Collection<BwLocation> getLocations(BwRequest request, int kind, boolean forEventUpdate) {
        try {
            BwActionFormBase form = request.getBwForm();
            Client cl = request.getClient();
            Collection vals = null;
            if (kind == 1) {
                if (cl.getWebSubmit()) {
                    vals = cl.getPublicLocations();
                } else {
                    BwLocation loc;
                    vals = cl.getLocations();
                    BwEvent ev = form.getEvent();
                    if (!this.publicAdmin && forEventUpdate && ev != null && (loc = ev.getLocation()) != null && !loc.getOwnerHref().equals(cl.getCurrentPrincipalHref())) {
                        vals.add(loc);
                    }
                }
            } else if (kind == 3) {
                vals = this.curAuthUserPrefs.getLocationPrefs().getPreferred();
            } else if (kind == 2) {
                vals = cl.getEditableLocations();
            }
            if (vals == null) {
                throw new Exception("Software error - bad kind " + kind);
            }
            return this.getLocationCollator().getCollatedCollection(vals);
        }
        catch (Throwable t) {
            t.printStackTrace();
            request.getErr().emit(t);
            return new ArrayList<BwLocation>();
        }
    }

    void setCurAuthUserPrefs(BwAuthUserPrefs val) {
        this.curAuthUserPrefs = val;
    }

    private BwCalendar getClonedCollection(BwRequest request, BwCalendar col, boolean fromCopy) {
        ColCloner cc = new ColCloner(request.getClient(), request.getBwForm().getCalendarsOpenState());
        ColCloner.CloneResult clres = cc.deepClone(col, fromCopy);
        if (!clres.isOk()) {
            this.warn("getClonedCollection failed: " + clres.getStatus() + " " + clres.getMessage());
            return null;
        }
        return clres.getCol();
    }

    private void refreshView(BwRequest req) {
        BwModuleState mstate = req.getModule().getState();
        BwActionFormBase form = req.getBwForm();
        Client cl = req.getClient();
        try {
            if (mstate.getCurTimeView() == null) {
                String vn;
                try {
                    vn = cl.getPreferences().getPreferredViewPeriod();
                    if (vn == null) {
                        vn = "week";
                    }
                }
                catch (Throwable t) {
                    System.out.println("Exception setting current view");
                    vn = "week";
                }
                if (mstate.getCurViewPeriod() < 0) {
                    for (int i = 1; i < BedeworkDefs.viewPeriodNames.length; ++i) {
                        String bwvt = BedeworkDefs.viewPeriodNames[i];
                        if (!bwvt.startsWith(vn)) continue;
                        mstate.setViewType(bwvt);
                        break;
                    }
                    if (mstate.getViewType() == null) {
                        mstate.setViewType(BedeworkDefs.viewPeriodNames[2]);
                    }
                    mstate.setViewMcDate(new MyCalendarVO(new Date(System.currentTimeMillis())));
                }
            }
            if (mstate.getViewMcDate() == null) {
                mstate.setViewMcDate(new MyCalendarVO(new Date(System.currentTimeMillis())));
            }
            if ("todayView".equals(mstate.getViewType())) {
                mstate.setViewType("dayView");
            }
            FilterBase filter = this.getFilter(req, null);
            DayView tv = null;
            switch (mstate.getViewType()) {
                case "todayView": 
                case "dayView": {
                    tv = new DayView(form.getErr(), mstate.getViewMcDate(), filter);
                    break;
                }
                case "weekView": {
                    tv = new WeekView(form.getErr(), mstate.getViewMcDate(), filter);
                    break;
                }
                case "monthView": {
                    tv = new MonthView(form.getErr(), mstate.getViewMcDate(), filter);
                    break;
                }
                case "yearView": {
                    tv = new YearView(form.getErr(), mstate.getViewMcDate(), form.getShowYearData(), filter);
                }
            }
            mstate.setCurTimeView((TimeView)tv);
            if ("webuser".equals(cl.getAppType())) {
                cl.clearSearchEntries();
            }
        }
        catch (Throwable t) {
            req.getErr().emit(t);
        }
    }

    private FilterBase getFilter(BwRequest req, String filterName) {
        BwActionFormBase form = req.getBwForm();
        Client cl = req.getClient();
        BwFilterDef fdef = null;
        if (filterName != null) {
            GetFilterDefResponse gfdr = cl.getFilter(filterName);
            if (gfdr.getStatus() == Response.Status.notFound) {
                form.getErr().emit("org.bedework.client.error.unknown.filter", (Object)filterName);
                return null;
            }
            if (gfdr.getStatus() != Response.Status.ok) {
                form.getErr().emit("org.bedework.client.error.exc", (Object)gfdr.getMessage());
                return null;
            }
            fdef = gfdr.getFilterDef();
        }
        if (fdef == null) {
            fdef = form.getCurrentFilter();
        }
        if (fdef == null) {
            return null;
        }
        if (fdef.getFilters() == null) {
            SimpleFilterParser.ParseResult pr = cl.parseFilter(fdef);
            if (!pr.ok) {
                req.getErr().emit(pr.message);
            }
        }
        return fdef.getFilters();
    }

    private void setSessionNum(String name) {
        try {
            Counts c = countsMap.get(name);
            if (c == null) {
                c = new Counts();
                c = countsMap.putIfAbsent(name, c);
            }
            this.sessionNum = c.totalSessions++;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private CollectionCollator<BwCategory> getCategoryCollator() {
        if (this.categoryCollator == null) {
            this.categoryCollator = new CollectionCollator();
        }
        return this.categoryCollator;
    }

    private CollectionCollator<BwContact> getContactCollator() {
        if (this.contactCollator == null) {
            this.contactCollator = new CollectionCollator();
        }
        return this.contactCollator;
    }

    private CollectionCollator<BwLocation> getLocationCollator() {
        if (this.locationCollator == null) {
            this.locationCollator = new CollectionCollator();
        }
        return this.locationCollator;
    }

    private void embedPrefs(BwRequest request) throws Throwable {
        request.setSessionAttr("bw_preferences", request.getClient().getPreferences());
    }

    private static class Counts {
        long totalSessions = 0L;

        private Counts() {
        }
    }
}

