/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.webcommon;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Logger;
import org.bedework.webcommon.BwCallback;

public class BwSvciFilter
implements Filter {
    protected ServletContext ctx;
    protected boolean debug = false;
    private transient Logger log;

    public void init(FilterConfig cnfg) throws ServletException {
        this.ctx = cnfg.getServletContext();
        this.debug = this.getLogger().isDebugEnabled();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest req, ServletResponse resp, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest hreq = (HttpServletRequest)req;
        HttpServletResponse hresp = (HttpServletResponse)resp;
        HttpSession sess = hreq.getSession();
        BwCallback cb = null;
        Throwable thr = null;
        try {
            req.setCharacterEncoding("UTF-8");
            try {
                chain.doFilter(req, resp);
            }
            catch (Throwable dft) {
                this.getLogger().error((Object)"Exception in filter: ", dft);
                thr = dft;
                try {
                    cb.error(hreq, hresp, dft);
                }
                catch (Throwable t1) {
                    this.getLogger().error((Object)"Callback exception: ", t1);
                }
            }
            cb = this.getCb(sess, "out");
            if (cb != null) {
                cb.out(hreq);
            }
        }
        catch (Throwable t) {
            this.getLogger().error((Object)"Callback exception: ", t);
            thr = t;
            try {
                cb.error(hreq, hresp, t);
            }
            catch (Throwable t1) {
                this.getLogger().error((Object)"Callback exception: ", t1);
            }
        }
        finally {
            try {
                cb = this.getCb(sess, "close");
                if (cb != null) {
                    cb.close(hreq, false);
                }
            }
            catch (Throwable t) {
                this.getLogger().error((Object)"Callback exception: ", t);
                thr = t;
            }
            if (thr != null) {
                if (thr instanceof ServletException) {
                    throw (ServletException)thr;
                }
                throw new ServletException(thr);
            }
        }
    }

    public void destroy() {
    }

    private BwCallback getCb(HttpSession sess, String tracer) throws Throwable {
        if (sess == null) {
            if (this.debug) {
                this.getLogger().debug((Object)(tracer + " no session object"));
            }
            return null;
        }
        try {
            BwCallback cb = (BwCallback)sess.getAttribute("org.bedework.webcommon.SvciFilter");
            if (this.debug) {
                if (cb != null) {
                    this.getLogger().debug((Object)(tracer + " Obtained BwCallback object"));
                } else {
                    this.getLogger().debug((Object)(tracer + " no BwCallback available"));
                }
            }
            return cb;
        }
        catch (IllegalStateException ise) {
            if (this.debug) {
                this.getLogger().debug((Object)(tracer + " Invalidated session - assume logged out"));
            }
            return null;
        }
    }

    public Logger getLogger() {
        if (this.log == null) {
            this.log = Logger.getLogger(this.getClass());
        }
        return this.log;
    }
}

