/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.webcommon;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import net.fortuna.ical4j.model.Dur;
import net.fortuna.ical4j.model.property.DtEnd;
import net.fortuna.ical4j.model.property.DtStart;
import net.fortuna.ical4j.model.property.Duration;
import org.apache.log4j.Logger;
import org.bedework.appcommon.CheckData;
import org.bedework.appcommon.client.Client;
import org.bedework.calfacade.BwAttendee;
import org.bedework.calfacade.BwContact;
import org.bedework.calfacade.BwDateTime;
import org.bedework.calfacade.BwEvent;
import org.bedework.calfacade.BwLocation;
import org.bedework.calfacade.BwLongString;
import org.bedework.calfacade.BwOrganizer;
import org.bedework.calfacade.BwPrincipal;
import org.bedework.calfacade.BwString;
import org.bedework.calfacade.base.BwStringBase;
import org.bedework.calfacade.configs.AuthProperties;
import org.bedework.calfacade.exc.CalFacadeException;
import org.bedework.calfacade.exc.ValidationError;
import org.bedework.calfacade.svc.EventInfo;
import org.bedework.icalendar.IcalUtil;
import org.bedework.util.misc.Util;
import org.bedework.webcommon.BwActionFormBase;
import org.bedework.webcommon.BwRequest;
import org.bedework.webcommon.BwSession;

public class BwWebUtil {
    public static final String sessStateAttr = "org.bedework.sessstate";
    public static final String sessCalSvcIAttr = "org.bedework.calsvci";

    public static BwSession getState(HttpServletRequest request) {
        HttpSession sess = request.getSession(false);
        if (sess != null) {
            Object o = sess.getAttribute(sessStateAttr);
            if (o != null && o instanceof BwSession) {
                return (BwSession)o;
            }
        } else {
            BwWebUtil.noSession();
        }
        return null;
    }

    public static void dropState(HttpServletRequest request) {
        HttpSession sess = request.getSession(false);
        if (sess == null) {
            return;
        }
        sess.removeAttribute(sessStateAttr);
    }

    public static void setState(HttpServletRequest request, BwSession s) {
        HttpSession sess = request.getSession(false);
        if (sess != null) {
            sess.setAttribute(sessStateAttr, (Object)s);
        } else {
            BwWebUtil.noSession();
        }
    }

    public static boolean validateEventDates(BwRequest request, EventInfo ei) throws CalFacadeException {
        BwEvent ev = ei.getEvent();
        boolean ok = true;
        BwDateTime evstart = ev.getDtstart();
        DtStart start = evstart.makeDtStart();
        DtEnd end = null;
        Duration dur = null;
        char endType = ev.getEndType();
        if (endType != 'N') {
            if (endType == 'E') {
                BwDateTime evend = ev.getDtend();
                if (evstart.after(evend)) {
                    request.getErr().emit("org.bedework.validation.error.startafterend");
                    ok = false;
                } else {
                    end = evend.makeDtEnd();
                }
            } else if (endType == 'D') {
                dur = new Duration(new Dur(ev.getDuration()));
            } else {
                request.getErr().emit("org.bedework.validation.error.invalid.endtype");
                ok = false;
            }
        }
        if (ok) {
            IcalUtil.setDates((String)request.getClient().getCurrentPrincipalHref(), (EventInfo)ei, (DtStart)start, end, dur);
        }
        return ok;
    }

    public static List<ValidationError> validateEvent(Client cl, boolean prePublish, boolean publicAdmin, BwEvent ev) throws CalFacadeException {
        BwOrganizer org;
        List<ValidationError> ves;
        block15: {
            Set descs;
            int maxDescLen;
            block14: {
                boolean nullOk;
                block13: {
                    Set sums;
                    block12: {
                        ves = null;
                        ev.setLink(BwWebUtil.checkNull(ev.getLink()));
                        AuthProperties apars = cl.getAuthProperties();
                        maxDescLen = publicAdmin || prePublish ? apars.getMaxPublicDescriptionLength() : apars.getMaxUserDescriptionLength();
                        nullOk = !publicAdmin && !prePublish;
                        sums = ev.getSummaries();
                        if (sums != null && sums.size() != 0) break block12;
                        if (nullOk) break block13;
                        ves = BwWebUtil.addError(ves, "org.bedework.validation.error.missingtitle");
                        break block13;
                    }
                    for (Object s : sums) {
                        if (s.getValue().length() <= maxDescLen) continue;
                        ves = BwWebUtil.addError(ves, "org.bedework.validation.error.toolong.summary", String.valueOf(maxDescLen));
                        break;
                    }
                }
                if ((descs = ev.getDescriptions()) != null && descs.size() != 0) break block14;
                if (nullOk) break block15;
                ves = BwWebUtil.addError(ves, "org.bedework.validation.error.missingdescription");
                break block15;
            }
            for (BwLongString s : descs) {
                if (s.getValue().length() <= maxDescLen) continue;
                ves = BwWebUtil.addError(ves, "org.bedework.validation.error.toolong.description", String.valueOf(maxDescLen));
                break;
            }
        }
        if (publicAdmin && !prePublish) {
            if (ev.getLocation() == null) {
                ves = BwWebUtil.addError(ves, "org.bedework.validation.error.missinglocation");
            }
            if (ev.getContact() == null) {
                ves = BwWebUtil.addError(ves, "org.bedework.validation.error.missingcontact");
            }
        }
        if (!CheckData.checkTransparency((String)ev.getTransparency())) {
            ves = BwWebUtil.addError(ves, "org.bedework.validation.error.invalid.transparency", ev.getTransparency());
        }
        if (!CheckData.checkStatus((String)ev.getStatus())) {
            ves = BwWebUtil.addError(ves, "org.bedework.validation.error.invalid.status", ev.getStatus());
        }
        if (ev.getNumRecipients() > 0) {
            for (String recip : ev.getRecipients()) {
                if (BwWebUtil.validateUserHref(cl, recip)) continue;
                ves = BwWebUtil.addError(ves, "org.bedework.validation.error.invalid.recipient", recip);
            }
        }
        if (ev.getNumAttendees() > 0) {
            for (BwAttendee att : ev.getAttendees()) {
                if (BwWebUtil.validateUserHref(cl, att.getAttendeeUri())) continue;
                ves = BwWebUtil.addError(ves, "org.bedework.validation.error.invalid.attendee", att.getAttendeeUri());
            }
        }
        if ((org = ev.getOrganizer()) != null && !BwWebUtil.validateUserHref(cl, org.getOrganizerUri())) {
            ves = BwWebUtil.addError(ves, "org.bedework.validation.error.invalid.organizer", org.getOrganizerUri());
        }
        return ves;
    }

    private static List<ValidationError> addError(List<ValidationError> ves, String errorCode) {
        return BwWebUtil.addError(ves, errorCode, null);
    }

    private static List<ValidationError> addError(List<ValidationError> ves, String errorCode, String extra) {
        if (ves == null) {
            ves = new ArrayList<ValidationError>();
        }
        ves.add(new ValidationError(errorCode, extra));
        return ves;
    }

    public static boolean validateUserHref(Client cl, String href) throws CalFacadeException {
        BwPrincipal p = cl.calAddrToPrincipal(href);
        if (p == null) {
            return true;
        }
        return cl.validPrincipal(p.getPrincipalRef());
    }

    public static ValidateResult validateLocation(BwActionFormBase form) {
        ValidateResult vr = new ValidateResult();
        BwLocation loc = form.getLocation();
        BwString addr = loc.getAddress();
        if (addr == null) {
            form.getErr().emit("org.bedework.validation.error.missingaddress");
            vr.ok = false;
        } else {
            String formSt = Util.checkNull((String)form.getCategoryStatus());
            if (formSt == null) {
                vr.changed = addr.getLang() != null;
                addr.setLang(null);
            } else if (!formSt.equals(addr.getLang())) {
                addr.setLang(formSt);
                vr.changed = true;
            }
        }
        vr.changed = true;
        return vr;
    }

    public static ValidateResult validateContact(BwActionFormBase form) {
        ValidateResult vr = new ValidateResult();
        BwContact contact = form.getContact();
        BwString str = contact.getCn();
        BwString frmstr = form.getContactName();
        if (frmstr != null && frmstr.checkNulls() && frmstr.getValue() == null) {
            frmstr = null;
        }
        if (str == null) {
            if (frmstr != null) {
                vr.changed = true;
                contact.setCn(frmstr);
            } else {
                form.getErr().emit("org.bedework.validation.error.missingcontactname");
                vr.ok = false;
            }
        } else if (frmstr == null) {
            vr.changed = true;
            contact.deleteName();
            form.getErr().emit("org.bedework.validation.error.missingcontactname");
            vr.ok = false;
        } else if (str.update((BwStringBase)frmstr)) {
            vr.changed = true;
        }
        if (str != null) {
            String formSt = Util.checkNull((String)form.getCategoryStatus());
            if (formSt == null) {
                vr.changed = str.getLang() != null;
                str.setLang(null);
            } else if (!formSt.equals(str.getLang())) {
                str.setLang(formSt);
                vr.changed = true;
            }
        }
        contact.setPhone(Util.checkNull((String)contact.getPhone()));
        contact.setEmail(Util.checkNull((String)contact.getEmail()));
        contact.setLink(Util.checkNull((String)contact.getLink()));
        contact.setLink(BwWebUtil.fixLink(contact.getLink()));
        return vr;
    }

    public static String fixLink(String val) {
        if ((val = BwWebUtil.checkNull(val)) == null) {
            return val;
        }
        if (val.indexOf("://") > 0) {
            return val;
        }
        return "http://" + val;
    }

    public static String checkNull(String val) {
        if (val == null) {
            return null;
        }
        if (val.length() == 0) {
            return null;
        }
        return val;
    }

    private static void noSession() {
        Logger.getLogger((String)"org.bedework.webcommon.BwWebUtil").warn((Object)"No session!!!!!!!");
    }

    public static class ValidateResult {
        public boolean ok = true;
        public boolean changed;
    }
}

