/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.webcommon;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.bedework.appcommon.client.Client;
import org.bedework.calfacade.BwCalendar;
import org.bedework.calfacade.BwCategory;
import org.bedework.calfacade.BwProperty;
import org.bedework.calfacade.responses.Response;
import org.bedework.util.misc.Logged;
import org.bedework.util.misc.Util;

public class ColCloner
extends Logged {
    private final Map<String, BwCalendar> clonedCols = new HashMap<String, BwCalendar>();
    private final Map<String, BwCategory> clonedCats = new HashMap<String, BwCategory>();
    private final Client cl;
    private final Set<String> openStates;
    private int numCloned;
    private int numCached;
    private int numCopied;
    private int numNodes;
    private int numSearches;
    private int numAliasResolve;

    ColCloner(Client cl, Set<String> openStates) {
        this.cl = cl;
        this.openStates = openStates;
    }

    CloneResult deepClone(BwCalendar val, boolean fromCopy) {
        long start = System.currentTimeMillis();
        if (this.debug) {
            this.debug("start clone. fromCopy: " + fromCopy);
        }
        CloneResult cr = this.deepClone(new CloneStatus(), val, fromCopy);
        if (this.debug) {
            this.debug("================================");
            this.debug("          cloned: " + this.numCloned);
            this.debug("          cached: " + this.numCached);
            this.debug("          copied: " + this.numCopied);
            this.debug("           nodes: " + this.numNodes);
            this.debug("        searches: " + this.numSearches);
            this.debug("aliases resolved: " + this.numAliasResolve);
            this.debug("            time: " + (System.currentTimeMillis() - start));
            this.debug("================================");
        }
        return cr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CloneResult deepClone(CloneStatus status, BwCalendar val, boolean fromCopy) {
        try {
            CloneResult gccr;
            status.pushVp(val);
            CloneResult cr = this.cloneOne(status, val, fromCopy);
            if (cr.getStatus() != Response.Status.ok) {
                CloneResult cloneResult = cr;
                return cloneResult;
            }
            cr.getCol().setVirtualPath(status.getVp());
            if (val.getCalType() != 8 && !(gccr = this.getChildren(status, cr.col, fromCopy)).isOk()) {
                CloneResult cloneResult = gccr;
                return cloneResult;
            }
            CloneResult cloneResult = cr;
            return cloneResult;
        }
        finally {
            status.popVp();
        }
    }

    private CloneResult cloneOne(CloneStatus status, BwCalendar val, boolean fromCopy) {
        ++this.numNodes;
        if (fromCopy) {
            ++this.numCopied;
            BwCalendar clCol = val.cloneWrapper();
            this.clonedCols.put(val.getPath(), clCol);
            if (this.openStates != null) {
                clCol.setOpen(this.openStates.contains(clCol.getPath()));
            }
            return new CloneResult(clCol, true);
        }
        BwCalendar clCol = this.clonedCols.get(val.getPath());
        if (clCol != null) {
            ++this.numCached;
            if (this.openStates != null) {
                clCol.setOpen(this.openStates.contains(clCol.getPath()));
            }
            clCol = clCol.cloneWrapper();
            return new CloneResult(clCol, true);
        }
        ++this.numCloned;
        clCol = val.shallowClone();
        clCol.setCategories(this.cloneCategories(val));
        clCol.setProperties(this.cloneProperties(val));
        if (this.openStates != null) {
            clCol.setOpen(this.openStates.contains(clCol.getPath()));
        }
        this.clonedCols.put(val.getPath(), clCol);
        if (val.getCalType() == 7 && val.getAliasUri() != null) {
            BwCalendar aliased;
            try {
                ++this.numAliasResolve;
                aliased = this.cl.resolveAlias(val, false, false);
            }
            catch (Throwable t) {
                if (this.debug) {
                    this.error(t);
                }
                return (CloneResult)Response.error((Response)new CloneResult(), (String)t.getMessage());
            }
            if (aliased != null) {
                CloneResult resp = this.deepClone(status, aliased, false);
                if (!resp.isOk()) {
                    return resp;
                }
                BwCalendar clonedAlias = resp.getCol();
                clCol.setAliasCalType(clonedAlias.getCalType());
                clCol.setAliasTarget(clonedAlias);
                clonedAlias.setAliasOrigin(clCol);
            }
        }
        return new CloneResult(clCol, false);
    }

    private CloneResult getChildren(CloneStatus status, BwCalendar col, boolean fromCopy) {
        int size;
        Collection children = col.getChildren();
        if (Util.isEmpty((Collection)children) && col.getCalType() == 7 && col.getAliasTarget() != null) {
            children = col.getAliasTarget().getChildren();
        }
        if (children != null || !col.getCollectionInfo().childrenAllowed) {
            size = 0;
        } else {
            try {
                ++this.numSearches;
                children = this.cl.getChildren(col);
            }
            catch (Throwable t) {
                if (this.debug) {
                    this.error(t);
                }
                return (CloneResult)Response.error((Response)new CloneResult(), (String)t.getMessage());
            }
            size = children.size();
        }
        ArrayList<BwCalendar> cloned = new ArrayList<BwCalendar>(size);
        col.setChildren(cloned);
        if (Util.isEmpty((Collection)children)) {
            return this.okReturn();
        }
        for (BwCalendar c : children) {
            CloneResult cr = this.deepClone(status, c, fromCopy);
            if (!cr.isOk()) {
                return cr;
            }
            cloned.add(cr.col);
        }
        return this.okReturn();
    }

    private CloneResult okReturn() {
        CloneResult cr = new CloneResult();
        cr.setStatus(Response.Status.ok);
        return cr;
    }

    private Set<BwCategory> cloneCategories(BwCalendar val) {
        if (val.getNumCategories() == 0) {
            return null;
        }
        TreeSet<BwCategory> ts = new TreeSet<BwCategory>();
        for (BwCategory cat : val.getCategories()) {
            BwCategory clCat = this.clonedCats.computeIfAbsent(cat.getUid(), k -> (BwCategory)cat.clone());
            ts.add(clCat);
        }
        return ts;
    }

    private Set<BwProperty> cloneProperties(BwCalendar val) {
        if (val.getNumProperties() == 0) {
            return null;
        }
        TreeSet<BwProperty> ts = new TreeSet<BwProperty>();
        for (BwProperty p : val.getProperties()) {
            ts.add((BwProperty)p.clone());
        }
        return ts;
    }

    private static class CloneStatus {
        Deque<String> virtualPath = new ArrayDeque<String>();

        private CloneStatus() {
        }

        void pushVp(BwCalendar col) {
            if (this.virtualPath.isEmpty()) {
                this.virtualPath.push(Util.buildPath((boolean)true, (String[])new String[]{"/", col.getName()}));
                return;
            }
            this.virtualPath.push(Util.buildPath((boolean)true, (String[])new String[]{"/", this.virtualPath.peek(), "/", col.getName()}));
        }

        void popVp() {
            this.virtualPath.pop();
        }

        String getVp() {
            return this.virtualPath.peek();
        }
    }

    public static class CloneResult
    extends Response {
        boolean alreadyCloned;
        private BwCalendar col;

        CloneResult() {
        }

        CloneResult(BwCalendar col, boolean alreadyCloned) {
            this.setStatus(Response.Status.ok);
            this.col = col;
            this.alreadyCloned = alreadyCloned;
        }

        public BwCalendar getCol() {
            return this.col;
        }
    }
}

