/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.webcommon;

import org.bedework.calfacade.BwDuration;
import org.bedework.calfacade.exc.CalFacadeException;

public class DurationBean
extends BwDuration {
    public static final String weekDuration = "weeks";
    public static final String dayTimeDuration = "daytime";
    private String type;
    boolean valueError;

    public void setType(String val) {
        this.type = val;
        if (dayTimeDuration.equals(val)) {
            this.setWeeks(0);
        }
    }

    public String getType() {
        return this.type;
    }

    public void setDaysStr(String val) {
        this.setDays(this.makeInt(val));
    }

    public String getDaysStr() {
        return String.valueOf(this.getDays());
    }

    public void setHoursStr(String val) {
        this.setHours(this.makeInt(val));
    }

    public String getHoursStr() {
        return String.valueOf(this.getHours());
    }

    public void setMinutesStr(String val) {
        this.setMinutes(this.makeInt(val));
    }

    public String getMinutesStr() {
        return String.valueOf(this.getMinutes());
    }

    public void setSecondsStr(String val) {
        this.setSeconds(this.makeInt(val));
    }

    public String getSecondsStr() {
        return String.valueOf(this.getSeconds());
    }

    public void setWeeksStr(String val) {
        this.setWeeks(this.makeInt(val));
    }

    public String getWeeksStr() {
        return String.valueOf(this.getWeeks());
    }

    public void setNegativeStr(String val) {
        this.setNegative(this.makeBool(val));
    }

    public String getNegativeStr() {
        return String.valueOf(this.getNegative());
    }

    public void reset() {
        this.valueError = false;
    }

    public boolean getValueError() {
        return this.valueError;
    }

    public static DurationBean makeDurationBean(String val) throws CalFacadeException {
        DurationBean db = new DurationBean();
        DurationBean.populate((BwDuration)db, (String)val);
        if (db.getWeeks() != 0) {
            db.setType(weekDuration);
        } else {
            db.setType(dayTimeDuration);
        }
        return db;
    }

    public static DurationBean makeOneHour() throws CalFacadeException {
        DurationBean db = new DurationBean();
        db.setType(dayTimeDuration);
        db.setHours(1);
        return db;
    }

    public static DurationBean makeOneDay() throws CalFacadeException {
        DurationBean db = new DurationBean();
        db.setType(dayTimeDuration);
        db.setDays(1);
        return db;
    }

    private int makeInt(String val) {
        try {
            return Integer.parseInt(val);
        }
        catch (Throwable t) {
            this.valueError = true;
            return 0;
        }
    }

    private boolean makeBool(String val) {
        try {
            return Boolean.valueOf(val);
        }
        catch (Throwable t) {
            this.valueError = true;
            return false;
        }
    }
}

