/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.webcommon;

import java.util.Date;
import org.bedework.appcommon.CalendarInfo;
import org.bedework.calfacade.BwDateTime;
import org.bedework.calfacade.BwDuration;
import org.bedework.calfacade.BwEvent;
import org.bedework.calfacade.base.BwTimeRange;
import org.bedework.calfacade.exc.CalFacadeException;
import org.bedework.calfacade.svc.EventInfo;
import org.bedework.calfacade.util.ChangeTable;
import org.bedework.util.calendar.PropertyIndex;
import org.bedework.util.misc.Util;
import org.bedework.util.servlet.MessageEmit;
import org.bedework.util.timezones.DateTimeUtil;
import org.bedework.webcommon.DurationBean;
import org.bedework.webcommon.EntityDates;
import org.bedework.webcommon.ForwardDefs;
import org.bedework.webcommon.TimeDateComponents;

public class EventDates
extends EntityDates
implements ForwardDefs {
    private TimeDateComponents startDate;
    private String endType = String.valueOf('D');
    private TimeDateComponents endDate;
    private DurationBean duration;

    public EventDates(String principalHref, CalendarInfo calInfo, boolean hour24, String endTypeName, int minIncrement, MessageEmit err) {
        super(principalHref, calInfo, hour24, minIncrement, err);
        if (endTypeName != null) {
            if ("duration".equals(endTypeName)) {
                this.endType = String.valueOf('D');
            } else if ("date".equals(endTypeName)) {
                this.endType = String.valueOf('E');
            }
        }
    }

    public void setFromEvent(BwEvent val) {
        try {
            this.getStartDate().setDateTime(val.getDtstart());
            BwDateTime dtEnd = val.getDtend();
            if (val.getDtstart().getDateType()) {
                dtEnd = dtEnd.getPreviousDay();
            }
            this.getEndDate().setDateTime(dtEnd);
            this.duration = DurationBean.makeDurationBean(val.getDuration());
            this.setEndType(String.valueOf(val.getEndType()));
        }
        catch (Throwable t) {
            this.err.emit(t);
        }
    }

    public void setFromDate(String val) {
        try {
            this.getStartDate().setDateTime(val);
            this.getEndDate().setDateTime(val);
        }
        catch (Throwable t) {
            this.err.emit(t);
        }
    }

    public void setNewEvent(BwEvent val) {
        try {
            Date now = new Date(System.currentTimeMillis());
            this.getStartDate().setDateTime(DateTimeUtil.isoDateTime((Date)now));
            this.duration = DurationBean.makeOneHour();
            BwDateTime end = this.getStartDate().getDateTime().addDuration((BwDuration)this.duration);
            this.getEndDate().setDateTime(end);
        }
        catch (Throwable t) {
            this.err.emit(t);
        }
    }

    public int updateEvent(EventInfo ei) throws Throwable {
        BwEvent ev = ei.getEvent();
        ChangeTable changes = ei.getChangeset(this.principalHref);
        int res = 9;
        PropertyIndex.PropertyInfoIndex endPi = ev.getEntityType() != 2 ? PropertyIndex.PropertyInfoIndex.DTEND : PropertyIndex.PropertyInfoIndex.DUE;
        try {
            BwDateTime esdt = ev.getDtstart();
            BwDateTime eedt = ev.getDtend();
            String edur = ev.getDuration();
            char evEndtype = ev.getEndType();
            BwDateTime start = this.getStartDate().getDateTime();
            if (esdt == null || !esdt.equals((Object)start)) {
                ev.setDtstart(start);
                res = 12;
            }
            ev.setNoStart(Boolean.valueOf(false));
            TimeDateComponents eTdc = this.getEndDate();
            eTdc.setDateOnly(start.getDateType());
            BwDateTime end = eTdc.getDateTime();
            if (this.getEndType() == null || this.getEndType().length() != 1) {
                this.err.emit("org.bedework.validation.error.invalid.endtype");
                return 17;
            }
            char endtype = this.getEndType().charAt(0);
            if (evEndtype != endtype) {
                ev.setEndType(endtype);
                res = 12;
            }
            if (start.getDateType() && ev.getEndType() == 'D') {
                this.getDuration().setHours(0);
                this.getDuration().setMinutes(0);
                this.getDuration().setSeconds(0);
                if (this.getDuration().isZero()) {
                    this.err.emit("org.bedework.validation.error.invalid.duration");
                    return 17;
                }
            }
            if (ev.getEndType() == 'E' && end.getDateType()) {
                end = end.getNextDay();
            }
            if (eedt == null || !eedt.equals((Object)end)) {
                ev.setDtend(end);
                res = 12;
            }
            String dur = this.getDuration().toString();
            if (edur == null || !edur.equals(dur)) {
                ev.setDuration(dur);
                res = 12;
            }
            if (esdt == null || !esdt.equals((Object)start)) {
                changes.changed(PropertyIndex.PropertyInfoIndex.DTSTART, (Object)esdt, (Object)start);
            }
            if (evEndtype != endtype) {
                if (endtype == 'D') {
                    end = null;
                    edur = null;
                } else {
                    eedt = null;
                    dur = null;
                }
                changes.changed(endPi, (Object)eedt, (Object)end);
                changes.changed(PropertyIndex.PropertyInfoIndex.DURATION, (Object)edur, (Object)dur);
            } else if (endtype == 'D') {
                if (Util.cmpObjval((Comparable)((Object)edur), (Comparable)((Object)dur)) != 0) {
                    changes.changed(PropertyIndex.PropertyInfoIndex.DURATION, (Object)edur, (Object)dur);
                }
            } else if (!eedt.equals((Object)end)) {
                changes.changed(endPi, (Object)eedt, (Object)end);
            }
            return res;
        }
        catch (Throwable t) {
            this.err.emit(t);
            return 17;
        }
    }

    public TimeDateComponents getStartDate() {
        if (this.startDate == null) {
            this.startDate = this.getNowTimeComponents();
        }
        return this.startDate;
    }

    public TimeDateComponents getEndDate() {
        if (this.endDate == null) {
            this.endDate = this.getNowTimeComponents();
        }
        return this.endDate;
    }

    public DurationBean getDuration() {
        if (this.duration == null) {
            this.duration = new DurationBean();
        }
        return this.duration;
    }

    public void setEndType(String val) {
        this.endType = val;
    }

    public String getEndType() {
        return this.endType;
    }

    public BwTimeRange getTimeRange() throws CalFacadeException {
        return new BwTimeRange(this.getStartDate().getDateTime(), this.getEndDate().getDateTime());
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("EventDates{startDate=");
        sb.append(this.startDate);
        sb.append(" endType=");
        sb.append(this.getEndType());
        sb.append(", endDate=");
        sb.append(this.endDate);
        sb.append(", ");
        sb.append((Object)this.duration);
        sb.append("}");
        return sb.toString();
    }
}

