/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.webcommon;

import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.Locale;
import org.bedework.calfacade.BwDateTime;
import org.bedework.calfacade.exc.CalFacadeException;
import org.bedework.calfacade.util.CalFacadeUtil;
import org.bedework.calfacade.util.Granulator;
import org.bedework.calsvci.SchedulingI;

public class FormattedFreeBusy
implements Serializable {
    private String account;
    private BwDateTime start;
    private BwDateTime end;
    private Collection<FbDayPeriod> days = new ArrayList<FbDayPeriod>();

    public FormattedFreeBusy(SchedulingI.FbGranulatedResponse fbresp, Locale loc) throws CalFacadeException {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
        if (fbresp.getAttendee() != null) {
            this.setAccount(fbresp.getAttendee().getAttendeeUri());
        } else {
            this.setAccount(null);
        }
        this.setStart(fbresp.getStart());
        this.setEnd(fbresp.getEnd());
        Calendar startCal = Calendar.getInstance(loc);
        Calendar endDayCal = Calendar.getInstance(loc);
        startCal.setTime((Date)this.getStart().makeDate());
        endDayCal.setTime((Date)this.getStart().makeDate());
        endDayCal.add(5, 1);
        long startMillis = this.getStart().makeDate().getTime();
        FbDayPeriod day = new FbDayPeriod(sdf.format(startCal.getTime()));
        this.days.add(day);
        int dayStartMinutes = -1;
        for (Granulator.EventPeriod ep : fbresp.eps) {
            if (!startCal.before(endDayCal)) {
                day = new FbDayPeriod(sdf.format(startCal.getTime()));
                this.days.add(day);
                endDayCal.add(5, 1);
                dayStartMinutes = -1;
            }
            long pstartMillis = ep.getStart().getTime();
            int plen = Math.round((ep.getEnd().getTime() - pstartMillis) / 60000L);
            int pstart = Math.round((pstartMillis - startMillis) / 60000L);
            if (dayStartMinutes < 0) {
                dayStartMinutes = pstart;
            }
            day.getPeriods().add(new FbPeriod(pstart -= dayStartMinutes, plen, ep.getType(), ep.getNumBusy(), ep.getNumTentative()));
            startCal.add(12, plen);
        }
    }

    public void setAccount(String val) {
        this.account = val;
    }

    public String getAccount() {
        return this.account;
    }

    public void setStart(BwDateTime val) {
        this.start = val;
    }

    public BwDateTime getStart() {
        return this.start;
    }

    public void setEnd(BwDateTime val) {
        this.end = val;
    }

    public BwDateTime getEnd() {
        return this.end;
    }

    public Collection<FbDayPeriod> getDays() {
        if (this.days == null) {
            this.days = new ArrayList<FbDayPeriod>();
        }
        return this.days;
    }

    public static class FbPeriod
    implements Serializable {
        int minutesStart;
        int minutesLength;
        int type;
        private int numBusy;
        private int numTentative;

        public FbPeriod(int minutesStart, int minutesLength, int type, int numBusy, int numTentative) {
            this.minutesStart = minutesStart;
            this.minutesLength = minutesLength;
            this.type = type;
            this.numBusy = numBusy;
            this.numTentative = numTentative;
        }

        public int getMinutesStart() {
            return this.minutesStart;
        }

        public int getMinutesLength() {
            return this.minutesLength;
        }

        public int getType() {
            return this.type;
        }

        public void setNumBusy(int val) {
            this.numBusy = val;
        }

        public int getNumBusy() {
            return this.numBusy;
        }

        public void setNumTentative(int val) {
            this.numTentative = val;
        }

        public int getNumTentative() {
            return this.numTentative;
        }

        public String getStartTime() {
            return CalFacadeUtil.getTimeFromMinutes((int)this.getMinutesStart());
        }
    }

    public static class FbDayPeriod
    implements Serializable {
        private String dateString;
        private Collection<FbPeriod> periods = new ArrayList<FbPeriod>();

        FbDayPeriod(String dateString) {
            this.dateString = dateString;
        }

        public String getDateString() {
            return this.dateString;
        }

        public Collection<FbPeriod> getPeriods() {
            if (this.periods == null) {
                this.periods = new ArrayList<FbPeriod>();
            }
            return this.periods;
        }
    }
}

