/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.webcommon;

import org.bedework.appcommon.TimeView;
import org.bedework.appcommon.client.Client;
import org.bedework.appcommon.client.SearchParams;
import org.bedework.calfacade.exc.CalFacadeException;
import org.bedework.webcommon.BwActionFormBase;
import org.bedework.webcommon.BwModuleState;
import org.bedework.webcommon.BwRequest;
import org.bedework.webcommon.RenderAction;

public class RenderMainAction
extends RenderAction {
    @Override
    public int doAction(BwRequest request, BwActionFormBase form) throws Throwable {
        BwModuleState mstate = request.getModule().getState();
        Client cl = request.getClient();
        TimeView tv = mstate.getCurTimeView();
        boolean fetch = mstate.getRefresh();
        SearchParams params = cl.getSearchParams();
        if (params == null) {
            params = new SearchParams();
            int forward = this.setSearchParams(request, params, "grid".equals(cl.getViewMode()));
            if (forward != 0) {
                return forward;
            }
            if (tv != null) {
                tv.refreshEvents();
            }
            fetch = true;
        }
        if (fetch) {
            try {
                mstate.setSearchResult(cl.search(params));
                request.setRequestAttr("bw_search_result", mstate.getSearchResult());
            }
            catch (CalFacadeException cfe) {
                request.getErr().emit((Throwable)cfe);
            }
        }
        if (tv != null) {
            tv.getEvents(cl, fetch);
        }
        mstate.setRefresh(false);
        return 0;
    }
}

