/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.webcommon;

import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.TreeSet;
import org.bedework.appcommon.CalendarInfo;
import org.bedework.calfacade.BwDateTime;
import org.bedework.calfacade.exc.CalFacadeBadDateException;
import org.bedework.calfacade.exc.CalFacadeException;
import org.bedework.calfacade.util.BwDateTimeUtil;
import org.bedework.util.timezones.DateTimeUtil;
import org.bedework.util.timezones.TimeZoneName;
import org.bedework.util.timezones.Timezones;

public class TimeDateComponents
implements Serializable {
    private static final String[] DEFAULT_AMPM_LABELS = new String[]{"am", "pm"};
    private CalendarInfo calInfo;
    private String[] minuteLabels;
    private String[] minuteVals;
    private int minuteIncrement;
    private String[] ampmLabels;
    private boolean hour24;
    private boolean isAm = true;
    private boolean dateOnly;
    private boolean floating;
    private boolean storeUTC;
    private String tzid;
    private int year;
    private int month;
    private int day;
    private int hour;
    private int minute;
    private String fieldInError;

    public TimeDateComponents(CalendarInfo calInfo, int minuteIncrement, boolean hour24) throws TimeDateException {
        this.calInfo = calInfo;
        this.hour24 = hour24;
        this.setMinutes(minuteIncrement);
        this.ampmLabels = DEFAULT_AMPM_LABELS;
    }

    public CalendarInfo getCalInfo() {
        return this.calInfo;
    }

    public void resetError() {
        this.fieldInError = null;
    }

    public String getError() {
        return this.fieldInError;
    }

    public Collection<TimeZoneName> getTimeZoneNames() {
        TreeSet<TimeZoneName> nms = new TreeSet<TimeZoneName>();
        try {
            nms.addAll(Timezones.getTzNames());
        }
        catch (Throwable t) {
            this.fieldInError = "TimeZoneNames";
        }
        return nms;
    }

    public String[] getDayLabels() {
        return this.getCalInfo().getDayLabels();
    }

    public String[] getDayVals() {
        return this.getCalInfo().getDayVals();
    }

    public String[] getMonthLabels() {
        return this.getCalInfo().getMonthLabels();
    }

    public String[] getMonthVals() {
        return this.getCalInfo().getMonthVals();
    }

    public String[] getHourLabels() {
        if (this.hour24) {
            return this.getCalInfo().getHour24Labels();
        }
        return this.getCalInfo().getHourLabels();
    }

    public String[] getHourVals() {
        if (this.hour24) {
            return this.getCalInfo().getHour24Vals();
        }
        return this.getCalInfo().getHourVals();
    }

    public String[] getMinuteLabels() {
        return this.minuteLabels;
    }

    public String[] getMinuteVals() {
        return this.minuteVals;
    }

    public String[] getAmpmLabels() {
        return this.ampmLabels;
    }

    public void setDateOnly(boolean val) {
        this.dateOnly = val;
    }

    public boolean getDateOnly() {
        return this.dateOnly;
    }

    public void setTzid(String val) {
        this.tzid = val;
    }

    public String getTzid() {
        try {
            if (this.tzid == null) {
                this.tzid = Timezones.getThreadDefaultTzid();
            }
        }
        catch (Throwable t) {
            this.fieldInError = "Tzid";
        }
        return this.tzid;
    }

    public void setFloating(boolean val) {
        this.floating = val;
    }

    public boolean getFloating() {
        return this.floating;
    }

    public void setStoreUTC(boolean val) {
        this.storeUTC = val;
    }

    public boolean getStoreUTC() {
        return this.storeUTC;
    }

    public void setNow() throws CalFacadeException {
        this.setDateTime(DateTimeUtil.isoDateTime((Date)new Date(System.currentTimeMillis())));
    }

    public void setDateTime(String val) throws CalFacadeException {
        try {
            if (DateTimeUtil.isISODateTime((String)val)) {
                this.setDateOnly(false);
            } else if (DateTimeUtil.isISODate((String)val)) {
                this.setDateOnly(true);
            } else {
                throw new CalFacadeException("org.bedework.error.bad.date", val);
            }
            this.setTzid(null);
            this.storeUTC = false;
            this.floating = false;
            this.initTimeParts(val);
        }
        catch (CalFacadeException cfe) {
            throw cfe;
        }
        catch (DateTimeUtil.BadDateException bde) {
            throw new CalFacadeBadDateException();
        }
    }

    public void setDateTime(BwDateTime val) throws CalFacadeException {
        this.setTzid(val.getTzid());
        this.storeUTC = val.isUTC();
        this.floating = val.getFloating();
        this.setDateOnly(val.getDateType());
        this.initTimeParts(val.getDtval());
    }

    public BwDateTime getDateTime() throws CalFacadeException {
        StringBuilder sb = new StringBuilder();
        TimeDateComponents.getFourDigit(sb, this.getYear());
        TimeDateComponents.getTwoDigit(sb, this.getMonth());
        TimeDateComponents.getTwoDigit(sb, this.getDay());
        if (!this.getDateOnly()) {
            sb.append("T");
            TimeDateComponents.getTwoDigit(sb, this.get24Hourval());
            TimeDateComponents.getTwoDigit(sb, this.getMinute());
            sb.append("00");
        }
        if (this.storeUTC) {
            sb.append("Z");
            return BwDateTimeUtil.getDateTimeUTC((String)sb.toString());
        }
        return BwDateTimeUtil.getDateTime((String)sb.toString(), (boolean)this.getDateOnly(), (boolean)this.floating, (String)this.tzid);
    }

    public int get24Hourval() {
        int hr = this.getHour();
        if (!this.hour24 && !this.isAm) {
            hr += 12;
        }
        return hr;
    }

    public String getRfc3339DateTime() {
        StringBuilder sb = new StringBuilder();
        TimeDateComponents.getFourDigit(sb, this.getYear());
        sb.append("-");
        TimeDateComponents.getTwoDigit(sb, this.getMonth());
        sb.append("-");
        TimeDateComponents.getTwoDigit(sb, this.getDay());
        sb.append("T");
        if (this.getDateOnly()) {
            sb.append("00:00:00");
        } else {
            TimeDateComponents.getTwoDigit(sb, this.get24Hourval());
            sb.append(":");
            TimeDateComponents.getTwoDigit(sb, this.getMinute());
            sb.append(":");
            sb.append("00");
        }
        return sb.toString();
    }

    public void setYear(int val) {
        this.year = val;
    }

    public int getYear() {
        return this.year;
    }

    public void setMonth(int val) {
        this.month = val;
    }

    public int getMonth() {
        return this.month;
    }

    public void setDay(int val) {
        this.day = val;
    }

    public int getDay() {
        return this.day;
    }

    public void setHour(int val) {
        this.hour = val;
    }

    public int getHour() {
        return this.hour;
    }

    public void setMinute(int val) {
        this.minute = this.validMinute(val);
    }

    public int getMinute() {
        return this.minute;
    }

    public void setAmpm(String val) {
        this.isAm = val.equals(this.ampmLabels[0]);
    }

    public String getAmpm() {
        if (this.isAm) {
            return this.ampmLabels[0];
        }
        return this.ampmLabels[1];
    }

    private void initTimeParts(String iso) throws CalFacadeException {
        try {
            this.year = this.getInt(iso.substring(0, 4));
            this.month = this.getInt(iso.substring(4, 6));
            this.day = this.getInt(iso.substring(6, 8));
            if (this.getDateOnly()) {
                this.hour = 0;
                this.minute = 0;
            } else {
                this.hour = this.getInt(iso.substring(9, 11));
                this.minute = this.getInt(iso.substring(11, 13));
            }
            boolean bl = this.isAm = this.hour < 12;
            if (!this.hour24 && this.hour > 11) {
                this.hour -= 12;
            }
        }
        catch (Throwable t) {
            throw new CalFacadeException("org.bedework.error.bad.date", iso);
        }
    }

    private int getInt(String val) throws Throwable {
        return Integer.parseInt(val);
    }

    private int validMinute(int val) {
        if (this.minuteIncrement > 1) {
            return (val + 1) / this.minuteIncrement * this.minuteIncrement;
        }
        return val;
    }

    private static void getTwoDigit(StringBuilder sb, int i) {
        if (i < 10) {
            sb.append("0");
        }
        sb.append(i);
    }

    private static void getFourDigit(StringBuilder sb, int i) {
        if (i < 10) {
            sb.append("000");
        } else if (i < 100) {
            sb.append("00");
        } else if (i < 1000) {
            sb.append("0");
        }
        sb.append(i);
    }

    private void setMinutes(int increment) throws TimeDateException {
        this.minuteIncrement = increment <= 1 ? 1 : increment;
        String[] labels = this.getCalInfo().getMinuteLabels();
        String[] vals = this.getCalInfo().getMinuteVals();
        if (this.minuteIncrement == 1) {
            this.minuteLabels = labels;
            this.minuteVals = vals;
            return;
        }
        int sz = labels.length / this.minuteIncrement;
        this.minuteLabels = new String[sz];
        this.minuteVals = new String[sz];
        int i = 0;
        for (int j = 0; j < labels.length; j += this.minuteIncrement) {
            this.minuteLabels[i] = labels[j];
            this.minuteVals[i] = vals[j];
            ++i;
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("TimeDateComponents{");
        try {
            sb.append(this.getDateTime());
        }
        catch (Throwable t) {
            sb.append("Exception " + t);
        }
        sb.append("}");
        return sb.toString();
    }

    public static class TimeDateException
    extends CalFacadeException {
        public TimeDateException(String msg) {
            super(msg);
        }
    }
}

