/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.webcommon.admingroup;

import org.bedework.appcommon.client.Client;
import org.bedework.calfacade.BwGroup;
import org.bedework.calfacade.BwPrincipal;
import org.bedework.calfacade.DirectoryInfo;
import org.bedework.calfacade.exc.CalFacadeException;
import org.bedework.calfacade.svc.BwAdminGroup;
import org.bedework.calfacade.svc.BwAuthUser;
import org.bedework.util.misc.Util;
import org.bedework.webcommon.BwAbstractAction;
import org.bedework.webcommon.BwActionFormBase;
import org.bedework.webcommon.BwRequest;
import org.bedework.webcommon.BwWebUtil;

public class UpdateAGAction
extends BwAbstractAction {
    @Override
    public int doAction(BwRequest request, BwActionFormBase form) throws Throwable {
        Client cl = request.getClient();
        if (!cl.isSuperUser()) {
            return 4;
        }
        if (request.getReqPar("delete") != null) {
            return 18;
        }
        cl.setChoosingGroup(false);
        boolean add = form.getAddingAdmingroup();
        BwAdminGroup updgrp = form.getUpdAdminGroup();
        if (updgrp == null) {
            return 35;
        }
        try {
            if (request.getReqPar("addGroupMember") != null) {
                BwGroup newMbr;
                String mbr = BwWebUtil.checkNull(form.getUpdGroupMember());
                if (mbr == null) {
                    return 1;
                }
                String kind = request.getReqPar("kind");
                if (!this.validateKind(kind, form)) {
                    return 2;
                }
                if (updgrp.isMember(mbr, "group".equals(kind))) {
                    form.getErr().emit("org.bedework.client.error.alreadymember", (Object)mbr);
                    return 2;
                }
                if ("user".equals(kind)) {
                    BwAuthUser au;
                    BwPrincipal p = cl.getUser(mbr);
                    if (p == null) {
                        cl.addUser(mbr);
                        p = cl.getUser(mbr);
                    }
                    if ((au = cl.getAuthUser(p)) != null && au.isUnauthorized()) {
                        return 26;
                    }
                    if (au == null) {
                        au = BwAuthUser.makeAuthUser((String)p.getPrincipalRef(), (int)64);
                        cl.addAuthUser(au);
                    }
                    newMbr = p;
                } else {
                    newMbr = cl.findGroup(mbr);
                    if (newMbr == null) {
                        form.getErr().emit("org.bedework.client.error.unknown.group", (Object)mbr);
                        return 2;
                    }
                }
                cl.addAdminGroupMember(updgrp, (BwPrincipal)newMbr);
                updgrp.addGroupMember((BwPrincipal)newMbr);
            } else if (request.getReqPar("removeGroupMember") != null) {
                String mbr = request.getReqPar("removeGroupMember");
                String kind = request.getReqPar("kind");
                if (!this.validateKind(kind, form)) {
                    return 2;
                }
                Object oldMbr = "user".equals(kind) ? cl.getUser(mbr) : cl.findAdminGroup(mbr);
                if (oldMbr != null) {
                    cl.removeAdminGroupMember(updgrp, oldMbr);
                    updgrp.removeGroupMember(oldMbr);
                }
            } else if (add) {
                if (!this.validateNewAdminGroup(cl, form)) {
                    return 2;
                }
                cl.addAdminGroup(updgrp);
                form.assignAddingAdmingroup(false);
            } else {
                if (!this.validateAdminGroup(cl, form)) {
                    return 2;
                }
                if (this.debug) {
                    this.debugMsg("About to update " + updgrp);
                }
                cl.updateAdminGroup(updgrp);
            }
            cl.refreshAdminGroups();
        }
        catch (CalFacadeException cfe) {
            String msg;
            switch (msg = cfe.getMessage()) {
                case "org.bedework.exception.duplicateadmingroup": {
                    form.getErr().emit("org.bedework.client.error.duplicategroup", (Object)updgrp.getAccount());
                    return 2;
                }
                case "org.bedework.exception.alreadyonagrouppath": {
                    form.getErr().emit("org.bedework.client.error.ongrouppath", (Object)updgrp.getAccount());
                    return 2;
                }
            }
            throw cfe;
        }
        form.getMsg().emit("org.bedework.client.message.updated.group");
        return 1;
    }

    private boolean validateNewAdminGroup(Client cl, BwActionFormBase form) throws Throwable {
        String adminGroupGroupOwner;
        boolean ok = true;
        BwAdminGroup updAdminGroup = form.getUpdAdminGroup();
        if (updAdminGroup == null) {
            return false;
        }
        updAdminGroup.setAccount(Util.checkNull((String)updAdminGroup.getAccount()));
        if (updAdminGroup.getAccount() == null) {
            form.getErr().emit("org.bedework.validation.error.missingname");
            ok = false;
        } else {
            DirectoryInfo di = cl.getDirectoryInfo();
            String href = di.getBwadmingroupPrincipalRoot();
            if (!href.endsWith("/")) {
                href = href + "/";
            }
            updAdminGroup.setPrincipalRef(href + updAdminGroup.getAccount());
        }
        updAdminGroup.setDescription(Util.checkNull((String)updAdminGroup.getDescription()));
        if (updAdminGroup.getDescription() == null) {
            form.getErr().emit("org.bedework.validation.error.missingdescription");
            ok = false;
        }
        if ((adminGroupGroupOwner = Util.checkNull((String)form.getAdminGroupGroupOwner())) == null) {
            form.getErr().emit("org.bedework.validation.error.missinggroupowner");
            ok = false;
        } else {
            updAdminGroup.setGroupOwnerHref(cl.getUserAlways(adminGroupGroupOwner).getPrincipalRef());
        }
        String adminGroupEventOwner = Util.checkNull((String)form.getAdminGroupEventOwner());
        if (adminGroupEventOwner == null) {
            adminGroupEventOwner = updAdminGroup.getAccount();
        }
        if (adminGroupEventOwner == null) {
            form.getErr().emit("org.bedework.validation.error.missingeventowner");
            ok = false;
        } else {
            String prefix = cl.getAdminGroupsIdPrefix();
            if (cl.isPrincipal(adminGroupEventOwner)) {
                adminGroupEventOwner = adminGroupEventOwner.substring(adminGroupEventOwner.lastIndexOf("/") + 1);
            }
            if (!adminGroupEventOwner.startsWith(prefix)) {
                adminGroupEventOwner = prefix + adminGroupEventOwner;
            }
            updAdminGroup.setOwnerHref(cl.getUserAlways(adminGroupEventOwner).getPrincipalRef());
        }
        return ok;
    }

    private boolean validateAdminGroup(Client cl, BwActionFormBase form) throws Throwable {
        String adminGroupEventOwner;
        boolean ok = true;
        BwAdminGroup updAdminGroup = form.getUpdAdminGroup();
        if (updAdminGroup == null) {
            return false;
        }
        updAdminGroup.setDescription(Util.checkNull((String)updAdminGroup.getDescription()));
        if (updAdminGroup.getDescription() == null) {
            form.getErr().emit("org.bedework.validation.error.missingdescription");
            ok = false;
        }
        String adminGroupGroupOwner = Util.checkNull((String)form.getAdminGroupGroupOwner());
        BwPrincipal updAgowner = cl.getPrincipal(updAdminGroup.getGroupOwnerHref());
        if (adminGroupGroupOwner != null && !adminGroupGroupOwner.equals(updAgowner.getAccount())) {
            BwPrincipal aggo = cl.getUser(adminGroupGroupOwner);
            if (aggo == null) {
                form.getErr().emit("org.bedework.client.error.unknown.user", (Object)adminGroupGroupOwner);
                return false;
            }
            updAdminGroup.setGroupOwnerHref(aggo.getPrincipalRef());
        }
        if ((adminGroupEventOwner = Util.checkNull((String)form.getAdminGroupEventOwner())) == null) {
            return ok;
        }
        BwPrincipal ageo = cl.getUser(adminGroupEventOwner);
        String prefix = cl.getAdminGroupsIdPrefix();
        if (!adminGroupEventOwner.startsWith(prefix)) {
            adminGroupEventOwner = prefix + adminGroupEventOwner;
        }
        if (ageo == null) {
            form.getErr().emit("org.bedework.client.error.unknown.user", (Object)adminGroupEventOwner);
            return false;
        }
        if (ageo.getPrincipalRef().equals(updAdminGroup.getOwnerHref())) {
            return ok;
        }
        updAdminGroup.setOwnerHref(ageo.getPrincipalRef());
        return ok;
    }

    private boolean validateKind(String kind, BwActionFormBase form) {
        if (kind == null) {
            form.getErr().emit("org.bedework.client.error.missingrequestpar", (Object)"kind");
            return false;
        }
        if ("group".equals(kind) || "user".equals(kind)) {
            return true;
        }
        form.getErr().emit("org.bedework.client.error.badrequest", (Object)kind);
        return false;
    }
}

