/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.webcommon.calendars;

import java.util.List;
import org.bedework.appcommon.client.Client;
import org.bedework.calfacade.BwCalendar;
import org.bedework.calfacade.exc.CalFacadeException;
import org.bedework.calfacade.svc.BwView;
import org.bedework.webcommon.BwAbstractAction;
import org.bedework.webcommon.BwActionFormBase;
import org.bedework.webcommon.BwRequest;

public class DeleteCalendarAction
extends BwAbstractAction {
    @Override
    public int doAction(BwRequest request, BwActionFormBase form) throws Throwable {
        Client cl = request.getClient();
        if (cl.isGuest()) {
            return 4;
        }
        String calPath = form.getCalendarPath();
        BwCalendar cal = cl.getCollection(calPath);
        if (cal == null) {
            form.getErr().emit("org.bedework.client.error.unknown.calendar", (Object)calPath);
            return 5;
        }
        if (cal.equals((Object)cl.getHome())) {
            form.getErr().emit("org.bedework.client.error.cannotdeletehome", (Object)calPath);
            return 27;
        }
        if (cal.getUnremoveable() && !form.getCurUserSuperUser()) {
            return 4;
        }
        boolean reffed = false;
        boolean autoRemove = !cl.getPublicAdmin() && cl.getPreferences().getUserMode() == 0;
        for (BwView v : cl.getAllViews()) {
            List paths = v.getCollectionPaths();
            if (paths == null || !paths.contains(cal.getPath())) continue;
            if (autoRemove) {
                if (cl.removeViewCollection(v.getName(), cal.getPath())) continue;
                form.getErr().emit("org.bedework.client.error.unknown.view", (Object)v.getName());
                return 3;
            }
            form.getErr().emit("org.bedework.client.error.referenced.subscription", (Object)v.getName());
            reffed = true;
        }
        if (reffed) {
            return 10;
        }
        try {
            if (!cl.deleteCollection(cal, request.getBooleanReqPar("deleteContent", false))) {
                form.getErr().emit("org.bedework.client.error.unknown.calendar", (Object)calPath);
                return 5;
            }
        }
        catch (CalFacadeException cfe) {
            if ("org.bedework.exception.calendarnotempty".equals(cfe.getMessage())) {
                form.getErr().emit("org.bedework.client.error.referenced.calendar", (Object)calPath);
                return 27;
            }
            if ("org.bedework.exception.cannotdeletedefaultcalendar".equals(cfe.getMessage())) {
                form.getErr().emit("org.bedework.client.error.referenced.calendar", (Object)"default calendar");
                return 27;
            }
            throw cfe;
        }
        form.getMsg().emit("org.bedework.client.message.deleted.calendar", (Object)calPath);
        return 1;
    }
}

