/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.webcommon.calendars;

import java.io.PrintWriter;
import java.util.Collection;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringEscapeUtils;
import org.bedework.appcommon.client.Client;
import org.bedework.calfacade.BwCalendar;
import org.bedework.calfacade.BwCategory;
import org.bedework.calfacade.BwPrincipal;
import org.bedework.calfacade.configs.BasicSystemProperties;
import org.bedework.calfacade.exc.CalFacadeException;
import org.bedework.calfacade.responses.CollectionsResponse;
import org.bedework.util.misc.Util;
import org.bedework.webcommon.BwAbstractAction;
import org.bedework.webcommon.BwActionFormBase;
import org.bedework.webcommon.BwRequest;
import org.bedework.webcommon.BwSession;

public class FetchCollectionsAction
extends BwAbstractAction {
    @Override
    public int doAction(BwRequest request, BwActionFormBase form) throws Throwable {
        BwSession sess = request.getSess();
        CollectionsResponse cols = sess.getCollections(request);
        Client cl = request.getClient();
        HttpServletResponse resp = request.getResponse();
        String format = request.getReqPar("format");
        if (format == null) {
            resp.setContentType("application/json; charset=UTF-8");
            cl.writeJson(resp, (Object)cols);
            resp.getOutputStream().close();
            return 47;
        }
        if (format.equals("cmds")) {
            Object col = cols.getCollections() != null ? cols.getCollections() : (cols.getPublicCollections() != null ? cols.getPublicCollections() : (cols.getUserCollections() != null ? cols.getUserCollections() : null));
            resp.setContentType("application/text; charset=UTF-8");
            if (col == null) {
                return 47;
            }
            PrintWriter pw = resp.getWriter();
            this.writeCols(cl, (BwCalendar)col, pw);
        }
        return 47;
    }

    private void writeCols(Client cl, BwCalendar col, PrintWriter pw) {
        this.writeCol(cl, col, pw);
        if (Util.isEmpty((Collection)col.getChildren())) {
            return;
        }
        for (BwCalendar child : col.getChildren()) {
            this.writeCols(cl, child, pw);
        }
    }

    private void writeCol(Client cl, BwCalendar col, PrintWriter pw) {
        if (col.getColPath() == null) {
            return;
        }
        pw.print("create collection ");
        if (col.getCalType() == 0) {
            pw.print(" folder ");
        } else if (col.getCalType() == 1) {
            pw.print(" calendar ");
        } else if (col.getCalType() == 7) {
            if (col.getIsTopicalArea()) {
                pw.print(" topic ");
            } else {
                pw.print(" alias ");
            }
        } else {
            pw.print(" *" + col.getCalType() + "* ");
        }
        pw.print("\"" + col.getColPath() + "\" ");
        pw.print("\"" + col.getName() + "\" ");
        pw.print("\"" + StringEscapeUtils.escapeJava((String)col.getSummary()) + "\" ");
        if (col.getCalType() == 7) {
            String uri = col.getAliasUri();
            if (!uri.startsWith("bwcal://")) {
                pw.print(" \"" + col.getAliasUri() + "\" ");
            } else {
                pw.print(" \"" + col.getAliasUri().substring(8) + "\" ");
            }
        }
        pw.print("\"" + col.getOwnerHref() + "\" ");
        pw.print("\"" + col.getCreatorHref() + "\" ");
        if (col.getDescription() != null) {
            pw.print(" desc=\"" + StringEscapeUtils.escapeJava((String)col.getDescription()) + "\"");
        }
        StringBuilder filterExpr = new StringBuilder();
        if (!Util.isEmpty((Collection)col.getCategoryUids())) {
            try {
                BasicSystemProperties basicSysprops = cl.getBasicSystemProperties();
                BwPrincipal principal = cl.getCurrentPrincipal();
                for (String cuid : col.getCategoryUids()) {
                    BwCategory cat = cl.getCategory(cuid);
                    cat.fixNames(basicSysprops, principal);
                    pw.print(" category=\"" + cat.getHref() + "\"");
                    if (filterExpr.length() == 0) {
                        filterExpr.append("(");
                    } else {
                        filterExpr.append(" | ");
                    }
                    filterExpr.append("categories.href=\"");
                    filterExpr.append(cat.getHref());
                    filterExpr.append("\"");
                }
            }
            catch (CalFacadeException cfe) {
                pw.print(" category-error=\"" + cfe.getDetailMessage() + "\"");
            }
        }
        if (filterExpr.length() != 0) {
            filterExpr.append(")");
            pw.print(" filter=\"");
            pw.print(StringEscapeUtils.escapeJava((String)filterExpr.toString()));
            pw.print("\"");
        }
        pw.println();
    }
}

