/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.webcommon.calendars;

import java.util.Set;
import org.bedework.appcommon.client.Client;
import org.bedework.calfacade.BwCalendar;
import org.bedework.calfacade.wrappers.CalendarWrapper;
import org.bedework.calsvci.CalendarsI;
import org.bedework.webcommon.BwAbstractAction;
import org.bedework.webcommon.BwActionFormBase;
import org.bedework.webcommon.BwRequest;

public class RenderCalendarAction
extends BwAbstractAction {
    @Override
    public int doAction(BwRequest request, BwActionFormBase form) throws Throwable {
        String calPath = form.getCalPath();
        if (calPath == null) {
            form.getErr().emit("org.bedework.client.error.missingcalendarpath");
            return 5;
        }
        Client cl = request.getClient();
        BwCalendar calendar = cl.getCollection(calPath);
        if (this.debug) {
            if (calendar == null) {
                this.logIt("No calendar with path " + calPath);
            } else {
                this.logIt("Retrieved calendar " + calendar.getId());
                Set<String> cos = form.getCalendarsOpenState();
                if (cos != null && calendar instanceof CalendarWrapper) {
                    CalendarWrapper ccw = (CalendarWrapper)calendar;
                    ccw.setOpen(cos.contains(calendar.getPath()));
                }
            }
        }
        form.assignAddingCalendar(false);
        form.setCalendarPath(calPath);
        form.setCalendar(calendar);
        request.getSess().embedCategories(request, false, 1);
        if (calendar == null) {
            form.getErr().emit("org.bedework.client.error.unknown.calendar", (Object)calPath);
            return 5;
        }
        form.assignBeforeCalendar((BwCalendar)calendar.clone());
        CalendarsI.SynchStatusResponse ssr = cl.getSynchStatus(calPath);
        request.setSessionAttr("bw_subscription_status", ssr);
        return 0;
    }
}

