/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.webcommon.calendars;

import org.bedework.access.Acl;
import org.bedework.appcommon.AccessXmlUtil;
import org.bedework.appcommon.client.Client;
import org.bedework.calfacade.BwCalendar;
import org.bedework.calfacade.base.BwShareableDbentity;
import org.bedework.calfacade.base.CategorisedEntity;
import org.bedework.calfacade.exc.CalFacadeException;
import org.bedework.calfacade.responses.GetFilterDefResponse;
import org.bedework.calfacade.responses.Response;
import org.bedework.util.misc.Util;
import org.bedework.util.xml.tagdefs.WebdavTags;
import org.bedework.webcommon.BwAbstractAction;
import org.bedework.webcommon.BwActionFormBase;
import org.bedework.webcommon.BwRequest;

public class UpdateCalendarAction
extends BwAbstractAction {
    @Override
    public int doAction(BwRequest request, BwActionFormBase form) throws Throwable {
        GetFilterDefResponse gfdr;
        BwCalendar newCal;
        Client cl = request.getClient();
        if (cl.isGuest()) {
            return 4;
        }
        if (request.present("access")) {
            return 4;
        }
        String reqpar = request.getReqPar("delete");
        if (reqpar != null) {
            return 18;
        }
        boolean add = form.getAddingCalendar();
        BwCalendar cal = form.getCalendar();
        if (!add && (newCal = request.getNewCal(false)) != null) {
            if (newCal.getPath().equals(cal.getColPath())) {
                return 1;
            }
            if (newCal.equals((Object)cal)) {
                form.getErr().emit("org.bedework.client.error.badrequest");
                return 1;
            }
            if (newCal.getCalendarCollection() || !newCal.getCollectionInfo().childrenAllowed) {
                form.getErr().emit("org.bedework.client.error.badrequest");
                return 1;
            }
            cl.moveCollection(cal, newCal);
            form.getMsg().emit("org.bedework.client.message.updated.calendar");
            return 1;
        }
        Boolean bool = request.getBooleanReqPar("unremoveable");
        if (bool != null) {
            if (!form.getCurUserSuperUser()) {
                return 4;
            }
            if (cal.getUnremoveable() != bool.booleanValue()) {
                cal.setUnremoveable(bool.booleanValue());
            }
        }
        if ((gfdr = request.getFilterDef()).getStatus() == Response.Status.notFound) {
            cal.setFilterExpr(null);
        } else {
            if (gfdr.getStatus() != Response.Status.ok) {
                return 2;
            }
            if (gfdr.getFilterDef() == null) {
                cal.setFilterExpr(null);
            } else {
                String fdef = gfdr.getFilterDef().getDefinition();
                if (!Util.equalsString((String)fdef, (String)cal.getFilterExpr())) {
                    cal.setFilterExpr(fdef);
                }
            }
        }
        BwAbstractAction.SetEntityCategoriesResult secr = this.setEntityCategories(request, null, (CategorisedEntity)cal, null);
        if (secr.rcode != 0) {
            return secr.rcode;
        }
        this.typeAndAlias(request, add);
        cal.setSummary(Util.checkNull((String)cal.getSummary()));
        cal.setDescription(Util.checkNull((String)cal.getDescription()));
        if (!this.validateCalendar(request)) {
            if (add) {
                return 28;
            }
            return 2;
        }
        if (add) {
            String parentPath = form.getParentCalendarPath();
            if (parentPath == null) {
                return 2;
            }
            try {
                form.setCalendar(cl.addCollection(cal, parentPath));
            }
            catch (CalFacadeException cfe) {
                if (cfe.getMessage().equals("org.bedework.exception.duplicatecalendar")) {
                    form.getErr().emit("org.bedework.exception.duplicatecalendar", (Object)cal.getName());
                    return 2;
                }
                throw cfe;
            }
            form.assignAddingCalendar(false);
        } else {
            cl.updateCollection(cal);
        }
        String aclStr = request.getReqPar("acl");
        if (aclStr != null) {
            AccessXmlUtil axu = new AccessXmlUtil(null, cl);
            Acl acl = axu.getAcl(aclStr, true);
            if (axu.getErrorTag() != null) {
                if (axu.getErrorTag().equals(WebdavTags.recognizedPrincipal)) {
                    form.getErr().emit("org.bedework.exception.principalnotfound", (Object)axu.getErrorMsg());
                } else {
                    form.getErr().emit("org.bedework.exception.badrequest", (Object)axu.getErrorTag());
                }
                return 2;
            }
            cl.changeAccess((BwShareableDbentity)cal, acl.getAces(), true);
        }
        form.setParentCalendarPath(null);
        if (cal.getCalendarCollection()) {
            if (add) {
                form.getMsg().emit("org.bedework.client.message.added.calendar");
            } else {
                form.getMsg().emit("org.bedework.client.message.updated.calendar");
            }
        } else if (add) {
            form.getMsg().emit("org.bedework.client.message.added.folder");
        } else {
            form.getMsg().emit("org.bedework.client.message.updated.folder");
        }
        cl.flushState();
        return 1;
    }

    private void typeAndAlias(BwRequest request, boolean add) throws Throwable {
        boolean orgSyncV2;
        String remotePw;
        String remoteId;
        BwActionFormBase form = request.getBwForm();
        BwCalendar cal = form.getCalendar();
        boolean extSub = false;
        String aliasUri = request.getReqPar("aliasUri");
        if (add) {
            int calType;
            boolean cc = request.getBooleanReqPar("calendarCollection", false);
            if (aliasUri != null) {
                boolean internal = aliasUri.startsWith("bwcal://");
                if (internal) {
                    calType = 7;
                } else {
                    calType = 8;
                    extSub = true;
                }
            } else {
                calType = cc ? 1 : 0;
            }
            cal.setName(Util.checkNull((String)cal.getName()));
            cal.setCalType(calType);
        }
        if (!Util.equalsString((String)aliasUri, (String)cal.getAliasUri())) {
            cal.setAliasUri(aliasUri);
        }
        if (extSub) {
            cal.setSynchAdminCreateEprops(request.present("adminAllowCreateEprops"));
            cal.setSynchXlocXcontacts(request.present("xlocxcontact"));
            cal.setSynchXcategories(request.present("xcategories"));
            cal.setSynchDeleteSuppressed(request.present("deleteSuppressed"));
        }
        int refreshRate = request.getIntReqPar("refinterval", 15) * 60;
        if (cal.getRefreshRate() != refreshRate) {
            cal.setRefreshRate(refreshRate);
        }
        if (!Util.equalsString((String)(remoteId = request.getReqPar("remoteId")), (String)cal.getRemoteId())) {
            cal.setRemoteId(remoteId);
        }
        if ((remotePw = request.getReqPar("remotePw")) != null) {
            cal.setRemotePw(remotePw);
            cal.setPwNeedsEncrypt(true);
            remotePw = null;
        }
        if (orgSyncV2 = request.present("orgSyncV2")) {
            cal.setSubscriptionTargetType("orgSyncV2");
        } else {
            cal.setSubscriptionTargetType("file");
        }
        cal.setOrgSyncPublicOnly(Boolean.valueOf(request.present("orgSyncPublicOnly")));
        cal.setLocationKey(request.getReqPar("locKey"));
    }

    private boolean validateCalendar(BwRequest request) throws Throwable {
        BwActionFormBase form = request.getBwForm();
        boolean ok = true;
        BwCalendar cal = form.getCalendar();
        if (cal.getName() == null) {
            form.getErr().emit("org.bedework.validation.error.missingname");
            ok = false;
        }
        return ok;
    }
}

