/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.webcommon.calsuite;

import org.bedework.appcommon.client.Client;
import org.bedework.calfacade.BwSystem;
import org.bedework.calfacade.svc.BwCalSuite;
import org.bedework.calfacade.svc.wrappers.BwCalSuiteWrapper;
import org.bedework.webcommon.BwAbstractAction;
import org.bedework.webcommon.BwActionFormBase;
import org.bedework.webcommon.BwRequest;
import org.bedework.webcommon.calsuite.CalSuiteContextHelper;

public class AddCalSuiteAction
extends BwAbstractAction {
    @Override
    public int doAction(BwRequest request, BwActionFormBase form) throws Throwable {
        boolean newDefContext;
        String newContextName;
        Client cl = request.getClient();
        if (cl.isGuest()) {
            return 4;
        }
        String name = request.getReqPar("name");
        if (name == null) {
            form.getErr().emit("org.bedework.validation.error.missingname");
            return 28;
        }
        if (name.length() > 255) {
            form.getErr().emit("org.bedework.validation.error.toolong.name");
            return 28;
        }
        String groupName = request.getReqPar("groupName");
        if (groupName == null) {
            form.getErr().emit("org.bedework.validation.error.missinggroupname");
            request.setErrFlag(true);
            return 28;
        }
        BwCalSuiteWrapper suite = cl.addCalSuite(name, groupName, request.getReqPar("calPath"), request.getReqPar("subroot"));
        if (suite == null) {
            form.getErr().emit("org.bedework.client.error.calsuitenotadded");
            return 28;
        }
        BwSystem syspars = cl.getSyspars();
        CalSuiteContextHelper contextHelper = new CalSuiteContextHelper(syspars);
        if (contextHelper.updateSuiteContext((BwCalSuite)suite, newContextName = request.getReqPar("context"), newDefContext = "true".equals(request.getReqPar("defaultContext")))) {
            cl.updateSyspars(syspars);
        }
        form.setEditCalSuiteName(name);
        return 0;
    }
}

