/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.webcommon.calsuite;

import java.util.Set;
import org.bedework.calfacade.BwSystem;
import org.bedework.calfacade.SubContext;
import org.bedework.calfacade.svc.BwCalSuite;

public class CalSuiteContextHelper {
    private BwSystem syspars;

    public CalSuiteContextHelper(BwSystem syspars) {
        this.syspars = syspars;
    }

    public boolean updateSuiteContext(BwCalSuite suite, String newContextName, boolean newDefContext) {
        boolean hasOldContext;
        boolean somethingChanged = false;
        boolean hasNewContext = newContextName != null && newContextName.trim().length() > 0;
        SubContext oldContext = null;
        SubContext oldDefaultContext = null;
        Set contexts = this.syspars.getContexts();
        for (SubContext subContext : contexts) {
            if (subContext.getCalSuite().equals(suite.getName())) {
                oldContext = subContext;
            }
            if (!subContext.getDefaultContext()) continue;
            oldDefaultContext = subContext;
        }
        boolean bl = hasOldContext = oldContext != null;
        if (hasOldContext || !hasNewContext) {
            // empty if block
        }
        if (!hasOldContext && hasNewContext) {
            if (newDefContext && oldDefaultContext != null) {
                this.syspars.removeContext(oldDefaultContext);
                this.syspars.addContext(new SubContext(oldDefaultContext.getContextName(), oldDefaultContext.getCalSuite(), false));
            }
            this.syspars.addContext(new SubContext(newContextName, suite.getName(), newDefContext));
            somethingChanged = true;
        }
        if (hasOldContext && !hasNewContext) {
            this.syspars.removeContext(oldContext);
            somethingChanged = true;
        }
        if (hasOldContext && hasNewContext) {
            boolean oldDefContext = oldContext.getDefaultContext();
            if (newDefContext && newDefContext != oldDefContext && oldDefaultContext != null) {
                this.syspars.removeContext(oldDefaultContext);
                this.syspars.addContext(new SubContext(oldDefaultContext.getContextName(), oldDefaultContext.getCalSuite(), false));
            }
            this.syspars.removeContext(oldContext);
            this.syspars.addContext(new SubContext(newContextName, suite.getName(), newDefContext));
            somethingChanged = true;
        }
        return somethingChanged;
    }

    public boolean removeSuiteContext(String ctxName) {
        SubContext oldContext = null;
        Set contexts = this.syspars.getContexts();
        for (SubContext subContext : contexts) {
            if (!subContext.getContextName().equals(ctxName)) continue;
            oldContext = subContext;
        }
        if (oldContext != null) {
            this.syspars.removeContext(oldContext);
            return true;
        }
        return false;
    }
}

