/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.webcommon.calsuite;

import java.util.Set;
import org.bedework.appcommon.client.Client;
import org.bedework.calfacade.BwSystem;
import org.bedework.calfacade.SubContext;
import org.bedework.calfacade.svc.wrappers.BwCalSuiteWrapper;
import org.bedework.webcommon.BwActionFormBase;
import org.bedework.webcommon.BwRequest;
import org.bedework.webcommon.RenderAction;

public class RenderCalSuiteAction
extends RenderAction {
    @Override
    public int doAction(BwRequest request, BwActionFormBase form) throws Throwable {
        Client cl = request.getClient();
        String name = form.getEditCalSuiteName();
        if (name == null) {
            form.getErr().emit("org.bedework.validation.error.missingname");
            return 2;
        }
        BwCalSuiteWrapper cs = cl.getCalSuite(name);
        if (cs == null) {
            form.getErr().emit("org.bedework.client.error.unknown.calendarsuite");
            return 5;
        }
        SubContext suiteCtx = null;
        BwSystem syspars = cl.getSyspars();
        Set contexts = syspars.getContexts();
        for (SubContext subContext : contexts) {
            if (!subContext.getCalSuite().equals(cs.getName())) continue;
            suiteCtx = subContext;
        }
        if (suiteCtx != null) {
            cs.setContext(suiteCtx.getContextName());
            cs.setDefaultContext(suiteCtx.getDefaultContext());
        } else {
            cs.setContext(null);
            cs.setDefaultContext(false);
        }
        form.setCalSuite(cs);
        String reqpar = request.getReqPar("delete");
        if (reqpar != null) {
            return 18;
        }
        return 0;
    }
}

