/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.webcommon.category;

import org.bedework.appcommon.client.Client;
import org.bedework.calfacade.BwCategory;
import org.bedework.calfacade.BwString;
import org.bedework.calfacade.base.BwStringBase;
import org.bedework.util.misc.Util;
import org.bedework.webcommon.BwAbstractAction;
import org.bedework.webcommon.BwActionFormBase;
import org.bedework.webcommon.BwRequest;

public class UpdateCategoryAction
extends BwAbstractAction {
    @Override
    public int doAction(BwRequest request, BwActionFormBase form) throws Throwable {
        String deleted;
        Client cl = request.getClient();
        if (cl.isGuest() || cl.getPublicAdmin() && !form.getAuthorisedUser()) {
            return 4;
        }
        String reqpar = request.getReqPar("delete");
        if (reqpar != null) {
            return 18;
        }
        boolean add = form.getAddingCategory();
        boolean added = false;
        ValidateCategoryResult vcr = this.validateCategory(form);
        if (!vcr.ok) {
            return 2;
        }
        BwCategory cat = form.getCategory();
        if (cl.isSuperUser() && "true".equals(deleted = request.getReqPar("deleted"))) {
            cat.setStatus("deleted");
        }
        if (add) {
            cat.setPublick(Boolean.valueOf(cl.getPublicAdmin()));
            if (cl.addCategory(cat)) {
                added = true;
            }
        } else if (vcr.changed) {
            cl.updateCategory(cat);
        }
        form.assignAddingCategory(false);
        if (add) {
            if (added) {
                form.getMsg().emit("org.bedework.client.message.added.categories", 1);
            } else {
                form.getErr().emit("org.bedework.client.error.duplicatecategory");
            }
        } else if (vcr.changed) {
            form.getMsg().emit("org.bedework.client.message.updated.category");
        }
        request.getSess().embedCategories(request, true, 1);
        request.getSess().embedCategories(request, true, 4);
        return 1;
    }

    private ValidateCategoryResult validateCategory(BwActionFormBase form) throws Throwable {
        ValidateCategoryResult vcr = new ValidateCategoryResult();
        BwCategory cat = form.getCategory();
        BwString str = cat.getWord();
        BwString formstr = form.getCategoryWord();
        if (formstr != null && formstr.checkNulls() && formstr.getValue() == null) {
            formstr = null;
        }
        if (str == null) {
            if (formstr != null) {
                vcr.changed = true;
                cat.setWord(formstr);
            }
        } else if (formstr == null) {
            vcr.changed = true;
            cat.deleteWord();
        } else if (str.update((BwStringBase)formstr)) {
            vcr.changed = true;
        }
        BwString desc = cat.getDescription();
        String formDesc = Util.checkNull((String)form.getCategoryDescription());
        if (desc == null) {
            if (formDesc != null) {
                vcr.changed = true;
                cat.setDescriptionVal(formDesc);
                desc = cat.getDescription();
            }
        } else if (formDesc == null) {
            vcr.changed = desc.getValue() != null;
            desc.setValue(null);
        } else if (!formDesc.equals(desc.getValue())) {
            desc.setValue(formDesc);
            vcr.changed = true;
        }
        String formSt = Util.checkNull((String)form.getCategoryStatus());
        if (desc == null) {
            if (formSt != null) {
                vcr.changed = true;
                desc = new BwString(formSt, null);
                cat.setDescription(desc);
            }
        } else if (formSt == null) {
            vcr.changed = desc.getLang() != null;
            desc.setLang(null);
        } else if (!formSt.equals(desc.getLang())) {
            desc.setLang(formSt);
            vcr.changed = true;
        }
        if (cat.getWord() == null) {
            form.getErr().emit("org.bedework.validation.error.missingcategorykeyword");
            vcr.ok = false;
        } else if (desc != null && desc.getLang() == null && desc.getValue() == null) {
            cat.deleteDescription();
        }
        return vcr;
    }

    private static class ValidateCategoryResult {
        public boolean ok = true;
        public boolean changed;

        private ValidateCategoryResult() {
        }
    }
}

