/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.webcommon.config;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.management.ObjectName;
import org.bedework.appcommon.ConfigCommon;
import org.bedework.calfacade.exc.CalFacadeException;
import org.bedework.util.jmx.ConfBase;
import org.bedework.webcommon.config.ClientConf;
import org.bedework.webcommon.config.ConfigCommonImpl;

public final class ClientConfigurations
extends ConfBase {
    private static final String confuriPname = "org.bedework.clients.confuri";
    private static final Object lock = new Object();
    private final Map<String, ConfigCommon> clientConfigs = new HashMap<String, ConfigCommon>();
    private static ClientConfigurations configs;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ClientConfigurations getConfigs() throws CalFacadeException {
        if (configs != null) {
            return configs;
        }
        Object object = lock;
        synchronized (object) {
            if (configs != null) {
                return configs;
            }
            configs = new ClientConfigurations();
            return configs;
        }
    }

    public static void startConfigs() throws CalFacadeException {
        ClientConfigurations.getConfigs();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void stopConfigs() throws CalFacadeException {
        Object object = lock;
        synchronized (object) {
            if (configs == null) {
                return;
            }
            configs.stop();
            configs = null;
        }
    }

    public String loadConfig() {
        return null;
    }

    private ClientConfigurations() throws CalFacadeException {
        super("org.bedework.clients:service=System");
        try {
            this.setConfigPname(confuriPname);
            this.loadClientConfigs();
        }
        catch (CalFacadeException cfe) {
            throw cfe;
        }
        catch (Throwable t) {
            throw new CalFacadeException(t);
        }
    }

    public ConfigCommon getClientConfig(String name) throws CalFacadeException {
        return this.clientConfigs.get(name);
    }

    private void loadClientConfigs() throws Throwable {
        List names = this.getStore().getConfigs();
        for (String cn : names) {
            ObjectName objectName = this.createObjectName("client-config", cn);
            ConfigCommonImpl cCfg = (ConfigCommonImpl)this.getStore().getConfig(cn);
            if (cCfg == null) {
                this.error("Unable to read client configuration " + cn);
                continue;
            }
            String mbeanClassName = cCfg.getMbeanClassName();
            if (mbeanClassName == null) {
                this.error("Must set the mbean class name for config " + cn);
                this.error("Falling back to base class for " + cn);
                mbeanClassName = ClientConf.class.getCanonicalName();
            }
            ClientConf cc = (ClientConf)ClientConfigurations.makeObject((String)mbeanClassName);
            cc.init(this.getStore(), objectName.toString(), cCfg);
            this.clientConfigs.put(cn, cc);
            this.register(new ObjectName(cc.getServiceName()), cc);
        }
    }

    public void stop() {
        try {
            ClientConfigurations.getManagementContext().stop();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }
}

