/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.webcommon.contact;

import org.bedework.appcommon.client.Client;
import org.bedework.calfacade.BwContact;
import org.bedework.calfacade.BwString;
import org.bedework.webcommon.BwAbstractAction;
import org.bedework.webcommon.BwActionFormBase;
import org.bedework.webcommon.BwRequest;

public class FetchContactAction
extends BwAbstractAction {
    @Override
    public int doAction(BwRequest request, BwActionFormBase form) throws Throwable {
        Client cl = request.getClient();
        if (cl.getPublicAdmin() && !form.getAuthorisedUser()) {
            return 4;
        }
        String uid = request.getReqPar("uid");
        BwContact contact = null;
        if (uid != null) {
            contact = cl.getContact(uid);
        }
        if (this.debug) {
            if (contact == null) {
                this.logIt("No contact with id " + uid);
            } else {
                this.logIt("Retrieved contact " + contact.getUid());
            }
        }
        form.assignAddingContact(false);
        form.setContact(contact);
        if (contact == null) {
            form.getErr().emit("org.bedework.client.error.unknown.contact", (Object)uid);
            return 5;
        }
        if (contact.getCn() != null) {
            form.setContactName((BwString)contact.getCn().clone());
            form.setContactStatus(contact.getCn().getLang());
        } else {
            form.setContactName(null);
        }
        return 1;
    }
}

