/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.webcommon.event;

import org.bedework.appcommon.EventKey;
import org.bedework.appcommon.client.Client;
import org.bedework.calfacade.BwEvent;
import org.bedework.calfacade.BwEventProxy;
import org.bedework.calfacade.exc.CalFacadeException;
import org.bedework.calfacade.svc.EventInfo;
import org.bedework.util.calendar.IcalDefs;
import org.bedework.webcommon.BwActionFormBase;
import org.bedework.webcommon.BwRequest;
import org.bedework.webcommon.event.EventActionBase;

public class AddEventRefAction
extends EventActionBase {
    @Override
    public int doAction(BwRequest request, BwActionFormBase form) throws Throwable {
        int fwd = this.addEventRef(request, form);
        if (fwd != 0) {
            return fwd;
        }
        String start = form.getEvent().getDtstart().getDate().substring(0, 8);
        this.gotoDateView(request, start, "dayView");
        request.refresh();
        return 0;
    }

    private int addEventRef(BwRequest request, BwActionFormBase form) throws Throwable {
        Client cl = request.getClient();
        if (cl.isGuest()) {
            return 4;
        }
        EventKey ekey = form.getEventKey();
        if (ekey == null) {
            return 9;
        }
        EventInfo ei = this.findEvent(request, ekey);
        if (ei == null) {
            return 24;
        }
        BwEventProxy proxy = BwEventProxy.makeAnnotation((BwEvent)ei.getEvent(), (String)ei.getEvent().getOwnerHref(), (boolean)false);
        EventInfo eref = new EventInfo((BwEvent)proxy);
        form.setEventInfo(eref, false);
        String calPath = this.getReqPar(request.getRequest(), "newCalPath");
        if (calPath == null) {
            String icalName = IcalDefs.entityTypeIcalNames[proxy.getEntityType()];
            calPath = cl.getPreferredCollectionPath(icalName);
        }
        proxy.setOwnerHref(cl.getCurrentPrincipalHref());
        String transparency = request.getReqPar("transparency");
        if (transparency != null) {
            if (!BwEvent.validTransparency((String)transparency)) {
                form.getErr().emit("org.bedework.validation.error.invalid.transparency", (Object)transparency);
                return 22;
            }
            proxy.setTransparency(transparency);
        }
        eref.getEvent().setColPath(calPath);
        try {
            cl.addEvent(eref, true, false);
            form.getMsg().emit("org.bedework.client.message.added.eventrefs", 1);
        }
        catch (CalFacadeException cfe) {
            if ("org.bedework.exception.duplicateguid".equals(cfe.getMessage())) {
                form.getErr().emit("org.bedework.client.error.duplicateuid");
                return 16;
            }
            if ("org.bedework.exception.calendarnotfound".equals(cfe.getMessage())) {
                form.getErr().emit("org.bedework.validation.error.missingcalendar");
                return 16;
            }
            throw cfe;
        }
        return 0;
    }
}

