/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.webcommon.event;

import java.util.SortedSet;
import org.bedework.appcommon.EventKey;
import org.bedework.appcommon.client.Client;
import org.bedework.calfacade.BwCalendar;
import org.bedework.calfacade.svc.EventInfo;
import org.bedework.webcommon.BwActionFormBase;
import org.bedework.webcommon.BwRequest;
import org.bedework.webcommon.event.EventActionBase;

public class AddEventSubAction
extends EventActionBase {
    @Override
    public int doAction(BwRequest request, BwActionFormBase form) throws Throwable {
        int fwd = this.addEventSub(request, form);
        if (fwd != 0) {
            return fwd;
        }
        String start = form.getEvent().getDtstart().getDate().substring(0, 8);
        this.gotoDateView(request, start, "dayView");
        request.refresh();
        return 0;
    }

    private int addEventSub(BwRequest request, BwActionFormBase form) throws Throwable {
        Client cl = request.getClient();
        if (cl.isGuest()) {
            return 4;
        }
        EventKey ekey = form.getEventKey();
        if (ekey == null) {
            return 9;
        }
        EventInfo ei = this.findEvent(request, ekey);
        if (ei == null) {
            return 24;
        }
        String subColPath = request.getReqPar("subColPath");
        BwCalendar col = null;
        if (subColPath != null) {
            col = cl.getCollection(subColPath);
            if (col == null) {
                form.getErr().emit("org.bedework.client.error.unknown.calendar");
                return 9;
            }
            if (col.getCalType() != 11) {
                form.getErr().emit("org.bedework.client.error.badrequest");
                return 9;
            }
        } else {
            col = cl.getSpecial(11, true);
        }
        SortedSet refs = col.getEventList();
        String href = request.getReqPar("href");
        if (request.getReqPar("recurrenceId") != null) {
            href = href + "#" + request.getReqPar("recurrenceId");
        }
        refs.add(new BwCalendar.EventListEntry(href));
        col.setEventList(refs);
        cl.updateCollection(col);
        return 0;
    }
}

