/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.webcommon.event;

import com.google.gson.Gson;
import java.util.List;
import org.bedework.webcommon.BwActionFormBase;
import org.bedework.webcommon.BwModuleState;
import org.bedework.webcommon.BwRequest;
import org.bedework.webcommon.event.EventActionBase;
import org.bedework.webcommon.event.JsonAttendee;

public class AttendeeAction
extends EventActionBase {
    @Override
    public int doAction(BwRequest request, BwActionFormBase form) throws Throwable {
        if (form.getGuest()) {
            return 4;
        }
        BwModuleState mstate = request.getModule().getState();
        boolean listResponseOnly = "yes".equals(request.getReqPar("list"));
        boolean noFb = "no".equals(request.getReqPar("getfb"));
        if (!listResponseOnly && !noFb) {
            this.gotoDateView(request, mstate.getDate(), mstate.getViewType());
        }
        int res = 0;
        List attjson = request.getReqPars("attjson");
        if (attjson != null) {
            Gson gson = new Gson();
            for (String s : attjson) {
                if (this.debug) {
                    this.debugMsg("json=" + s);
                }
                try {
                    JsonAttendee att = (JsonAttendee)gson.fromJson(s, JsonAttendee.class);
                    if (this.debug) {
                        this.debugMsg(att.toString());
                    }
                    if ((res = this.doAttendee(request, form, request.present("delete"), request.present("update"), false, true, false, request.getReqPar("partstat"), request.getReqPar("role"), att.uri, att.cn, null, att.cutype, null)) == 0) continue;
                    return res;
                }
                catch (Throwable t) {
                    form.getErr().emit("org.bedework.client.error.unknown.attendee", (Object)s);
                    return 9;
                }
            }
        } else {
            String uri = request.getReqPar("uri");
            if (uri != null) {
                res = this.doAttendee(request, form, request.present("delete"), request.present("update"), request.present("recipient"), request.present("attendee"), false, request.getReqPar("partstat"), request.getReqPar("role"), uri, request.getReqPar("cn"), request.getReqPar("lang"), request.getReqPar("cutype"), request.getReqPar("dir"));
            }
        }
        if (res != 0 || noFb) {
            return res;
        }
        if (listResponseOnly) {
            return 44;
        }
        String st = request.getReqPar("start");
        String et = request.getReqPar("end");
        String intunitStr = request.getReqPar("intunit");
        int interval = request.getIntReqPar("interval", 1);
        return this.doFreeBusy(request, form, form.getAttendees(), st, et, intunitStr, interval);
    }
}

