/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.webcommon.event;

import java.util.Collection;
import java.util.List;
import org.bedework.appcommon.client.Client;
import org.bedework.calfacade.BwEvent;
import org.bedework.calfacade.BwXproperty;
import org.bedework.calfacade.RecurringRetrievalMode;
import org.bedework.calfacade.exc.CalFacadeAccessException;
import org.bedework.calfacade.svc.EventInfo;
import org.bedework.util.calendar.PropertyIndex;
import org.bedework.util.misc.Util;
import org.bedework.webcommon.BwActionFormBase;
import org.bedework.webcommon.BwRequest;
import org.bedework.webcommon.event.EventActionBase;

public class DeleteEventAction
extends EventActionBase {
    @Override
    public int doAction(BwRequest request, BwActionFormBase form) throws Throwable {
        List xps;
        Client cl = request.getClient();
        if (cl.isGuest()) {
            return 4;
        }
        boolean publicAdmin = cl.getPublicAdmin();
        boolean submitApp = form.getSubmitApp();
        boolean publicEvents = publicAdmin || submitApp;
        boolean soft = request.getBooleanReqPar("soft", false) || form.getMarkDeleted();
        String submitterEmail = null;
        EventInfo ei = this.findEvent(request, RecurringRetrievalMode.Rmode.entityOnly);
        if (ei == null) {
            form.getErr().emit("org.bedework.client.error.unknown.event");
            return 9;
        }
        BwEvent ev = ei.getEvent();
        if (publicAdmin && !Util.isEmpty((Collection)(xps = ev.getXproperties("X-BEDEWORK-SUBMITTER-EMAIL")))) {
            submitterEmail = ((BwXproperty)xps.get(0)).getValue();
        }
        boolean deleted = false;
        if (!soft) {
            try {
                if (!cl.deleteEvent(ei, !publicEvents)) {
                    form.getErr().emit("org.bedework.client.error.unknown.event");
                    return 9;
                }
                deleted = true;
            }
            catch (CalFacadeAccessException calFacadeAccessException) {
                // empty catch block
            }
        }
        if (!deleted) {
            if (publicEvents) {
                ei.getChangeset(cl.getCurrentPrincipalHref()).changed(PropertyIndex.PropertyInfoIndex.DELETED, (Object)ev.getDeleted(), (Object)true);
                ev.setDeleted(true);
                try {
                    cl.updateEvent(ei, true, null);
                }
                catch (CalFacadeAccessException cfe1) {
                    form.getErr().emit("org.bedework.client.error.noaccess");
                    return 9;
                }
            }
            try {
                cl.markDeleted(ev);
            }
            catch (CalFacadeAccessException cfe1) {
                form.getErr().emit("org.bedework.client.error.noaccess");
                return 9;
            }
        }
        if (publicAdmin && request.getBooleanReqPar("submitNotification", false)) {
            this.notifySubmitter(request, ei, submitterEmail);
        }
        form.getMsg().emit("org.bedework.client.message.deleted.events", 1);
        request.refresh();
        cl.clearSearchEntries();
        return 0;
    }
}

