/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.webcommon.event;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import net.fortuna.ical4j.model.parameter.Role;
import org.bedework.appcommon.DateTimeFormatter;
import org.bedework.appcommon.EventFormatter;
import org.bedework.appcommon.EventKey;
import org.bedework.appcommon.client.Client;
import org.bedework.appcommon.client.IcalCallbackcb;
import org.bedework.calfacade.BwAttendee;
import org.bedework.calfacade.BwCalendar;
import org.bedework.calfacade.BwContact;
import org.bedework.calfacade.BwDateTime;
import org.bedework.calfacade.BwEvent;
import org.bedework.calfacade.BwGroup;
import org.bedework.calfacade.BwLocation;
import org.bedework.calfacade.BwLongString;
import org.bedework.calfacade.BwOrganizer;
import org.bedework.calfacade.BwPrincipal;
import org.bedework.calfacade.BwString;
import org.bedework.calfacade.BwXproperty;
import org.bedework.calfacade.RecurringRetrievalMode;
import org.bedework.calfacade.base.BwStringBase;
import org.bedework.calfacade.mail.Message;
import org.bedework.calfacade.svc.EventInfo;
import org.bedework.calfacade.svc.wrappers.BwCalSuiteWrapper;
import org.bedework.calfacade.util.ChangeTable;
import org.bedework.icalendar.IcalCallback;
import org.bedework.icalendar.IcalTranslator;
import org.bedework.icalendar.RecurRuleComponents;
import org.bedework.util.calendar.IcalDefs;
import org.bedework.util.calendar.PropertyIndex;
import org.bedework.util.http.BasicHttpClient;
import org.bedework.util.http.RequestBuilder;
import org.bedework.util.misc.Util;
import org.bedework.webcommon.Attendees;
import org.bedework.webcommon.BwAbstractAction;
import org.bedework.webcommon.BwActionFormBase;
import org.bedework.webcommon.BwRequest;
import org.bedework.webcommon.BwWebUtil;

public abstract class EventActionBase
extends BwAbstractAction {
    private static BasicHttpClient http;

    protected int refreshEvent(BwRequest request, EventInfo ei) throws Throwable {
        BwActionFormBase form = request.getBwForm();
        if (ei == null) {
            request.getErr().emit("org.bedework.client.error.unknown.event");
            return 5;
        }
        Client cl = request.getClient();
        BwEvent ev = ei.getEvent();
        form.setEventInfo(ei, false);
        form.assignSavedEvent((BwEvent)ev.clone());
        form.assignAddingEvent(false);
        String str = null;
        BwLongString bstr = ev.findDescription(null);
        if (bstr != null) {
            str = bstr.getValue();
        }
        form.setDescription(str);
        bstr = ev.findSummary(null);
        str = bstr != null ? bstr.getValue() : null;
        form.setSummary(str);
        form.setEventStatus(ev.getStatus());
        if (!request.setEventCalendar(ei, ei.getChangeset(cl.getCurrentPrincipalHref()))) {
            return 9;
        }
        BwLocation loc = ev.getLocation();
        if (this.debug) {
            if (loc == null) {
                this.debugMsg("Set event with null location");
            } else {
                this.debugMsg("Set event with location " + loc);
            }
        }
        form.setLocation(null);
        if (loc != null) {
            form.setLocationUid(loc.getUid());
        } else {
            form.setLocationUid(null);
        }
        if (ev.getRrules() != null) {
            Collection rrcs = RecurRuleComponents.fromEventRrules((BwEvent)ev);
            form.setRruleComponents(rrcs);
        } else {
            form.setRruleComponents(null);
        }
        EventFormatter ef = new EventFormatter(cl, new IcalTranslator((IcalCallback)new IcalCallbackcb(cl)), ei);
        form.setCurEventFmt(ef);
        if (ev.getScheduleMethod() != 0) {
            form.setMeetingCal(cl.getCollection(ev.getColPath()));
        }
        Set dates = ev.getRdates();
        TreeSet<Object> frdates = null;
        if (dates != null && !dates.isEmpty()) {
            frdates = new TreeSet<DateTimeFormatter>();
            for (BwDateTime date : dates) {
                frdates.add(new DateTimeFormatter(date));
            }
        }
        form.setFormattedRdates(frdates);
        dates = ev.getExdates();
        frdates = null;
        if (dates != null && !dates.isEmpty()) {
            frdates = new TreeSet();
            for (BwDateTime date : dates) {
                frdates.add(new DateTimeFormatter(date));
            }
        }
        form.setFormattedExdates(frdates);
        return 1;
    }

    protected void embedPreferredAdminGroups(BwRequest request) throws Throwable {
        Client cl = request.getClient();
        Set prefGroupHrefs = cl.getPreferences().getPreferredGroups();
        ArrayList<BwGroup> prefGroups = new ArrayList<BwGroup>(prefGroupHrefs.size());
        for (String href : prefGroupHrefs) {
            BwGroup group = cl.getAdminGroup(href);
            if (group == null) continue;
            prefGroups.add(group);
        }
        request.setSessionAttr("bw_preferred_admin_groups", prefGroups);
    }

    protected void copyEvent(BwRequest request, BwEvent ev) throws Throwable {
        BwActionFormBase form = request.getBwForm();
        Client cl = request.getClient();
        EventInfo ei = this.fetchEvent(request, ev);
        BwEvent evcopy = (BwEvent)ei.getEvent().clone();
        form.setAttendees(new Attendees());
        form.getAttendees().setAttendees(evcopy.getAttendees());
        evcopy.setId(-1);
        evcopy.setUid(null);
        evcopy.setName(null);
        if (cl.getPublicAdmin()) {
            evcopy.removeXproperties("X-BEDEWORK-SUGGESTED-TO");
            BwPrincipal p = cl.getPrincipal(form.getCurrentCalSuite().getGroup().getOwnerHref());
            BwCalSuiteWrapper cs = cl.getCalSuite();
            BwCalendar col = cl.getHome(p, false);
            if (col == null) {
                request.getErr().emit("No calendar home");
            } else {
                List aliases = evcopy.getXproperties("X-BEDEWORK-ALIAS");
                String homePath = Util.buildPath((boolean)true, (String[])new String[]{col.getPath()});
                for (BwXproperty xp : aliases) {
                    if (xp.getValue().startsWith(homePath)) continue;
                    evcopy.removeXproperty(xp);
                }
            }
            evcopy.getCategories().clear();
        }
        ei = new EventInfo(evcopy);
        form.setEventInfo(ei, false);
        this.resetEvent(request);
        form.assignAddingEvent(true);
    }

    protected void resetEvent(BwRequest request) throws Throwable {
        BwActionFormBase form = request.getBwForm();
        Client cl = request.getClient();
        BwEvent event = form.getEvent();
        BwContact s = event.getContact();
        String uid = null;
        if (s != null) {
            uid = s.getUid();
            form.setContact(s);
        }
        form.retrieveCtctId().reset((Object)uid, 1);
        BwLocation l = event.getLocation();
        uid = null;
        if (l != null) {
            uid = l.getUid();
            form.setLocation(l);
        }
        form.retrieveLocId().reset((Object)uid, 1);
        BwCalendar c = cl.getCollection(event.getColPath());
        String path = null;
        if (c != null) {
            path = c.getPath();
            form.setCalendar(c);
        }
        form.retrieveCalendarId().reset((Object)path, 1);
    }

    protected EventInfo findEvent(BwRequest request, EventKey ekey) throws Throwable {
        Client cl = request.getClient();
        EventInfo ev = null;
        if (ekey.getColPath() == null) {
            request.getErr().emit("org.bedework.validation.error.missingcalendarpath");
            return null;
        }
        String key = null;
        if (ekey.getGuid() != null) {
            RecurringRetrievalMode rrm;
            if (this.debug) {
                this.debugMsg("Get event by guid");
            }
            key = ekey.getGuid();
            String rid = ekey.getRecurrenceId();
            if (ekey.getForExport()) {
                rrm = RecurringRetrievalMode.overrides;
                rid = null;
            } else {
                rrm = RecurringRetrievalMode.expanded;
            }
            Collection evs = cl.getEventByUid(ekey.getColPath(), ekey.getGuid(), rid, rrm);
            if (this.debug) {
                this.debugMsg("Get event by guid found " + evs.size());
            }
            if (evs.size() == 1) {
                ev = (EventInfo)evs.iterator().next();
            }
        } else if (ekey.getName() != null) {
            if (this.debug) {
                this.debugMsg("Get event by name");
            }
            key = ekey.getName();
            ev = cl.getEvent(ekey.getColPath(), ekey.getName(), ekey.getRecurrenceId());
        }
        if (ev == null) {
            request.getErr().emit("org.bedework.client.error.unknown.event", (Object)key);
            return null;
        }
        if (this.debug) {
            this.debugMsg("Get event found " + ev.getEvent());
        }
        return ev;
    }

    protected EventInfo fetchEvent(BwRequest request, BwEvent event) throws Throwable {
        String key;
        Client cl = request.getClient();
        EventInfo ei = null;
        BwCalendar cal = cl.getCollection(event.getColPath());
        if (cal == null) {
            request.getErr().emit("org.bedework.client.error.noaccess");
            return null;
        }
        if (!cal.getCollectionInfo().uniqueKey) {
            key = event.getName();
            ei = cl.getEvent(cal.getPath(), key, null);
        } else {
            String uid;
            key = uid = event.getUid();
            if (uid == null) {
                request.getErr().emit("org.bedework.client.error.noaccess");
                return null;
            }
            String rid = event.getRecurrenceId();
            Collection evs = cl.getEventByUid(cal.getPath(), uid, rid, RecurringRetrievalMode.overrides);
            if (this.debug) {
                this.debugMsg("Get event by guid found " + evs.size());
            }
            if (evs.size() == 1) {
                ei = (EventInfo)evs.iterator().next();
            }
        }
        if (ei == null) {
            request.getErr().emit("org.bedework.client.error.unknown.event", (Object)key);
            return null;
        }
        if (this.debug) {
            this.debugMsg("Fetch event found " + ei.getEvent());
        }
        return ei;
    }

    protected EventInfo refetchEvent(BwRequest request) throws Throwable {
        EventInfo ei = request.getBwForm().getEventInfo();
        if (ei == null) {
            return null;
        }
        return this.fetchEvent(request, ei.getEvent());
    }

    protected void setEventText(BwRequest request, BwEvent ev, boolean skipNull, ChangeTable changes) throws Throwable {
        String lang;
        String text;
        int pos;
        this.setEventSummary(request.getReqPar("summaryLang"), request.getReqPar("summary"), ev, skipNull, changes);
        this.setEventDescription(request.getReqPar("descriptionLang"), request.getReqPar("description"), ev, skipNull, changes);
        List vals = request.getReqPars("localizedSummary");
        if (!Util.isEmpty((Collection)vals)) {
            for (String s : vals) {
                pos = s.indexOf(":");
                text = null;
                lang = null;
                if (pos > 0) {
                    lang = s.substring(0, pos);
                }
                text = pos >= 0 ? s.substring(pos + 1) : s;
                this.setEventSummary(lang, text, ev, skipNull, changes);
            }
        }
        if (!Util.isEmpty((Collection)(vals = request.getReqPars("localizedDescription")))) {
            for (String s : vals) {
                pos = s.indexOf(":");
                text = null;
                lang = null;
                if (pos > 0) {
                    lang = s.substring(0, pos);
                }
                text = pos >= 0 ? s.substring(pos + 1) : s;
                this.setEventDescription(lang, text, ev, skipNull, changes);
            }
        }
    }

    private void setEventSummary(String lang, String text, BwEvent ev, boolean skipNull, ChangeTable changes) {
        BwString evText = ev.findSummary(lang);
        if (!this.eventTextChanged(lang, text, (BwStringBase)evText, skipNull)) {
            return;
        }
        ev.updateSummaries(lang, text);
        if (lang == null) {
            changes.changed(PropertyIndex.PropertyInfoIndex.SUMMARY, (Object)evText, (Object)ev.findSummary(lang));
        } else {
            this.warn("No multi-language support in change table.");
        }
    }

    private void setEventDescription(String lang, String text, BwEvent ev, boolean skipNull, ChangeTable changes) {
        BwLongString evText = ev.findDescription(lang);
        if (!this.eventTextChanged(lang, text, (BwStringBase)evText, skipNull)) {
            return;
        }
        ev.updateDescriptions(lang, text);
        if (lang == null) {
            changes.changed(PropertyIndex.PropertyInfoIndex.DESCRIPTION, (Object)evText, (Object)ev.findDescription(lang));
        } else {
            this.warn("No multi-language support in change table.");
        }
    }

    private boolean eventTextChanged(String lang, String text, BwStringBase evText, boolean skipNull) {
        if (text == null && skipNull) {
            return false;
        }
        if (text == null && evText == null) {
            return false;
        }
        if (text == null || evText == null) {
            return true;
        }
        return !text.equals(evText.getValue());
    }

    protected boolean adminEventLocation(BwRequest req, EventInfo ei) throws Throwable {
        BwActionFormBase form = req.getBwForm();
        Client cl = req.getClient();
        BwEvent event = ei.getEvent();
        ChangeTable changes = ei.getChangeset(cl.getCurrentPrincipalHref());
        if (!form.retrieveLocId().getChanged()) {
            if (form.getConfig().getAutoCreateLocations()) {
                BwLocation l = form.getLocation();
                BwWebUtil.ValidateResult vr = BwWebUtil.validateLocation(form);
                if (!vr.ok) {
                    return false;
                }
                l = (BwLocation)cl.ensureLocationExists(l, cl.getCurrentPrincipalHref()).getEntity();
                if (changes.changed(PropertyIndex.PropertyInfoIndex.LOCATION, (Object)event.getLocation(), (Object)l)) {
                    event.setLocation(l);
                }
            }
            return true;
        }
        try {
            String uid = (String)form.retrieveLocId().getVal();
            BwLocation loc = cl.getPersistentLocation(uid);
            BwLocation eloc = event.getLocation();
            if (loc == null || !loc.getPublick().booleanValue()) {
                form.getErr().emit("org.bedework.validation.error.locationnotpublic");
                return false;
            }
            if (eloc == null || !loc.equals((Object)eloc)) {
                event.setLocation(loc);
                form.setLocation(loc);
                changes.changed(PropertyIndex.PropertyInfoIndex.LOCATION, (Object)eloc, (Object)loc);
            }
            return true;
        }
        catch (Throwable t) {
            form.getErr().emit(t);
            return false;
        }
    }

    protected boolean setEventLocation(BwRequest request, EventInfo ei, BwActionFormBase form, boolean webSubmit) throws Throwable {
        Client cl = request.getClient();
        BwEvent ev = ei.getEvent();
        ChangeTable changes = ei.getChangeset(cl.getCurrentPrincipalHref());
        BwLocation loc = this.getLocation(cl, form, ev.getOwnerHref(), webSubmit);
        BwLocation eloc = ev.getLocation();
        if (eloc == null && loc == null) {
            return false;
        }
        if (eloc == null || loc == null || !loc.equals((Object)eloc)) {
            changes.changed(PropertyIndex.PropertyInfoIndex.LOCATION, (Object)eloc, (Object)loc);
            ev.setLocation(loc);
            return true;
        }
        return false;
    }

    protected boolean setEventContact(BwRequest request, boolean webSubmit) throws Throwable {
        BwContact evc;
        Client cl = request.getClient();
        BwActionFormBase form = request.getBwForm();
        EventInfo ei = form.getEventInfo();
        BwEvent event = ei.getEvent();
        ChangeTable changes = ei.getChangeset(cl.getCurrentPrincipalHref());
        BwContact c = null;
        String owner = event.getOwnerHref();
        if (owner == null) {
            owner = cl.getCurrentPrincipalHref();
        }
        if (!form.retrieveCtctId().getChanged() && form.getConfig().getAutoCreateContacts()) {
            c = form.getContact();
            BwWebUtil.ValidateResult vr = BwWebUtil.validateContact(form);
            if (!vr.ok) {
                return false;
            }
            c = (BwContact)cl.ensureContactExists(c, owner).getEntity();
            if (changes.changed(PropertyIndex.PropertyInfoIndex.CONTACT, (Object)event.getContact(), (Object)c)) {
                event.setContact(c);
            }
            form.setContact(c);
        }
        if (c != null) {
            return true;
        }
        String uid = (String)form.retrieveCtctId().getVal();
        if (uid == null) {
            uid = Util.checkNull((String)form.getContactUid());
        }
        if (uid != null) {
            try {
                c = cl.getPersistentContact(uid);
            }
            catch (Throwable t) {
                form.getErr().emit(t);
                return false;
            }
        }
        if (Util.cmpObjval((Comparable)(evc = event.getContact()), (Comparable)c) != 0) {
            changes.changed(PropertyIndex.PropertyInfoIndex.CONTACT, (Object)event.getContact(), (Object)c);
            event.setContact(c);
            form.setContact(c);
        }
        return true;
    }

    public int doAttendee(BwRequest request, BwActionFormBase form, boolean delete, boolean update, boolean recipient, boolean attendee, boolean initializing, String partstat, String role, String uri, String cn, String lang, String cutype, String dir) throws Throwable {
        String calAddr;
        Client cl = request.getClient();
        if (uri == null) {
            request.getErr().emit("org.bedework.validation.error.invalid.user", (Object)"null");
            return 9;
        }
        EventInfo ei = form.getEventInfo();
        BwEvent ev = ei.getEvent();
        if (ev == null) {
            return 9;
        }
        if (!(initializing || ev.getOrganizer() != null && form.getAttendees() != null)) {
            this.initMeeting(request, form, false);
        }
        Attendees atts = form.getAttendees();
        if (!form.getAddingEvent()) {
            atts.setAttendees(ev.getAttendees());
            atts.setRecipients(ev.getRecipients());
        }
        if ((calAddr = cl.uriToCaladdr(uri)) == null) {
            form.getErr().emit("org.bedework.validation.error.invalid.user", (Object)uri);
            return 9;
        }
        if (recipient && !delete) {
            atts.addRecipient(calAddr);
        }
        if (!attendee) {
            return 0;
        }
        BwAttendee att = new BwAttendee();
        att.setAttendeeUri(calAddr);
        if (delete) {
            atts.removeRecipient(calAddr);
            atts.removeAttendee(att);
            return 0;
        }
        if (update) {
            boolean found = false;
            if (atts.getNumAttendees() > 0) {
                for (BwAttendee att1 : atts.getAttendees()) {
                    if (!att1.equals((Object)att)) continue;
                    att = att1;
                    found = true;
                    break;
                }
            }
            if (!found) {
                form.getErr().emit("org.bedework.client.error.unknown.attendee", (Object)calAddr);
                return 9;
            }
        }
        Integer maxAttendees = cl.getAuthProperties().getMaxAttendeesPerInstance() == null ? Integer.valueOf(250) : cl.getAuthProperties().getMaxAttendeesPerInstance();
        if (atts.getAttendees() != null && atts.getAttendees().size() == maxAttendees.intValue()) {
            form.getErr().emit("org.bedework.validation.error.toomany.attendees", (Object)uri);
            return 9;
        }
        att.setRole(role);
        if (partstat != null && !"undefined".equals(partstat)) {
            att.setPartstat(partstat);
        } else {
            att.setPartstat("NEEDS-ACTION");
        }
        att.setRsvp("NEEDS-ACTION".equals(att.getPartstat()));
        att.setCn(cn);
        att.setLanguage(lang);
        att.setCuType(cutype);
        att.setDir(dir);
        if (!update) {
            atts.addAttendee(att);
        }
        ev.setAttendees(atts.getAttendees());
        ev.setRecipients(atts.getRecipients());
        return 0;
    }

    public int initMeeting(BwRequest request, BwActionFormBase form, boolean freebusy) throws Throwable {
        Attendees atts;
        Client cl = request.getClient();
        BwEvent ev = form.getEvent();
        if (ev.getScheduleMethod() == 0) {
            ev.setScheduleMethod(2);
        }
        if (ev.getOrganizer() == null) {
            BwOrganizer org = new BwOrganizer();
            org.setOrganizerUri(cl.getCurrentCalendarAddress());
            ev.setOrganizer(org);
            ev.setOrganizerSchedulingObject(Boolean.valueOf(true));
            ev.setAttendeeSchedulingObject(Boolean.valueOf(false));
            ev.setOriginator(org.getOrganizerUri());
        }
        if ((atts = form.getAttendees()) == null) {
            atts = new Attendees();
            form.setAttendees(atts);
        }
        if (!form.getAddingEvent()) {
            atts.setAttendees(ev.getAttendees());
            atts.setRecipients(ev.getRecipients());
        }
        if (Util.isEmpty((Collection)form.getEvent().getAttendees())) {
            String uri = cl.getCurrentCalendarAddress();
            int res = this.doAttendee(request, form, false, false, true, true, true, IcalDefs.partstats[1], Role.CHAIR.getValue(), uri, null, null, null, null);
            if (res != 0) {
                return res;
            }
        }
        if (!freebusy) {
            return 0;
        }
        return this.doFreeBusy(request, form, form.getAttendees(), null, null, null, 1);
    }

    protected boolean notifySubmitter(BwRequest request, EventInfo ei, String submitterEmail) throws Throwable {
        if (submitterEmail == null) {
            return false;
        }
        Message emsg = new Message();
        String[] to = new String[]{submitterEmail};
        emsg.setMailTo(to);
        BwActionFormBase form = request.getBwForm();
        emsg.setFrom(form.getSnfrom());
        emsg.setSubject(form.getSnsubject());
        emsg.setContent(form.getSntext());
        request.getClient().postMessage(emsg);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean notifyEventReg(BwRequest request, EventInfo ei) throws Throwable {
        Client cl = request.getClient();
        String evregToken = cl.getSystemProperties().getEventregAdminToken();
        String evregUrl = cl.getSystemProperties().getEventregUrl();
        if (evregToken == null || evregUrl == null) {
            return false;
        }
        if (http == null) {
            http = new BasicHttpClient(30000);
        }
        http.setBaseURI(new URI(evregUrl));
        RequestBuilder rb = new RequestBuilder("info/eventChg.do");
        rb.par("atkn", evregToken);
        rb.par("href", ei.getEvent().getHref());
        try {
            int respCode = http.sendRequest("GET", rb.toString(), null, "application/xml", 0, null);
            if (respCode != 200) {
                boolean bl = false;
                return bl;
            }
        }
        finally {
            http.release();
        }
        return true;
    }
}

