/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.webcommon.event;

import org.bedework.appcommon.TimeView;
import org.bedework.appcommon.client.Client;
import org.bedework.calfacade.BwCalendar;
import org.bedework.calfacade.BwEvent;
import org.bedework.calfacade.BwEventObj;
import org.bedework.calfacade.exc.CalFacadeException;
import org.bedework.calfacade.svc.EventInfo;
import org.bedework.calfacade.util.ChangeTable;
import org.bedework.util.calendar.PropertyIndex;
import org.bedework.webcommon.Attendees;
import org.bedework.webcommon.BwActionFormBase;
import org.bedework.webcommon.BwRequest;
import org.bedework.webcommon.BwSession;
import org.bedework.webcommon.DurationBean;
import org.bedework.webcommon.EventDates;
import org.bedework.webcommon.event.EventActionBase;

public class InitAddEventAction
extends EventActionBase {
    @Override
    public int doAction(BwRequest request, BwActionFormBase form) throws Throwable {
        int res;
        request.refresh();
        BwEventObj ev = new BwEventObj();
        form.getEventDates().setNewEvent((BwEvent)ev);
        TimeView tv = request.getSess().getCurTimeView(request);
        form.getEventStartDate().setDateTime(tv.getCurDayFmt().getDateTimeString());
        form.getEventEndDate().setDateTime(tv.getCurDayFmt().getDateTimeString());
        EventInfo ei = new EventInfo((BwEvent)ev);
        form.setEventInfo(ei, true);
        form.assignSavedEvent((BwEvent)new BwEventObj());
        form.resetSelectIds();
        ChangeTable changes = ei.getChangeset(request.getClient().getCurrentPrincipalHref());
        form.assignAddingEvent(true);
        form.setAttendees(new Attendees());
        form.setFbResponses(null);
        form.setFormattedFreeBusy(null);
        ev.setEntityType(request.getEntityType());
        int sched = request.getSchedule();
        if (request.getErrFlag()) {
            return 17;
        }
        if (sched == 2 && (res = this.initMeeting(request, form, true)) != 0) {
            return res;
        }
        String date = request.getReqPar("startdate");
        EventDates evdates = form.getEventDates();
        try {
            if (date != null) {
                evdates.setFromDate(date);
            }
            if ((date = request.getReqPar("enddate")) != null) {
                evdates.getEndDate().setDateTime(date);
            }
        }
        catch (CalFacadeException cfe) {
            if ("org.bedework.error.bad.date".equals(cfe.getMessage())) {
                form.getErr().emit("org.bedework.validation.error.invalid.date", (Object)date);
                return 25;
            }
            throw cfe;
        }
        int minutes = request.getIntReqPar("minutes", -1);
        if (minutes > 0) {
            evdates.setEndType(String.valueOf('D'));
            DurationBean dur = evdates.getDuration();
            dur.setType("daytime");
            dur.setMinutes(minutes);
        }
        form.setDescription(null);
        form.setSummary(null);
        form.setEventStatus(null);
        form.setRruleComponents(null);
        form.setFormattedRdates(null);
        form.setFormattedExdates(null);
        BwCalendar cal = request.getNewCal(false);
        if (cal != null) {
            changes.changed(PropertyIndex.PropertyInfoIndex.COLLECTION, (Object)ev.getColPath(), (Object)cal.getPath());
            ev.setColPath(cal.getPath());
        }
        BwSession sess = request.getSess();
        sess.embedAddContentCalendarCollections(request);
        sess.embedUserCollections(request);
        sess.embedContactCollection(request, 1);
        Client cl = request.getClient();
        if (cl.getPublicAdmin()) {
            sess.embedContactCollection(request, 3);
            sess.embedLocations(request, 3);
            if (form.getSuggestionEnabled()) {
                this.embedPreferredAdminGroups(request);
                request.embedCalsuiteAdminGroups();
            }
        }
        sess.embedCategories(request, false, 1);
        sess.embedLocations(request, 1);
        return 0;
    }
}

