/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.webcommon.event;

import net.fortuna.ical4j.model.Calendar;
import org.bedework.appcommon.client.Client;
import org.bedework.appcommon.client.IcalCallbackcb;
import org.bedework.calfacade.BwEvent;
import org.bedework.calfacade.mail.Attachment;
import org.bedework.calfacade.mail.Message;
import org.bedework.calfacade.mail.ObjectAttachment;
import org.bedework.calfacade.svc.EventInfo;
import org.bedework.icalendar.IcalCallback;
import org.bedework.icalendar.IcalTranslator;
import org.bedework.util.misc.Util;
import org.bedework.webcommon.BwAbstractAction;
import org.bedework.webcommon.BwActionFormBase;
import org.bedework.webcommon.BwRequest;

public class MailEventAction
extends BwAbstractAction {
    @Override
    public int doAction(BwRequest request, BwActionFormBase form) throws Throwable {
        EventInfo ei = form.getEventInfo();
        if (ei == null) {
            return 9;
        }
        BwEvent ev = ei.getEvent();
        String recipient = request.getReqPar("lastEmail");
        if (recipient == null) {
            request.getErr().emit("org.bedework.client.error.mail.norecipient", 1);
            return 2;
        }
        String subject = request.getReqPar("subject");
        if (!Util.present((String)subject)) {
            subject = ev.getSummary();
        }
        Message emsg = new Message();
        String[] to = new String[]{recipient};
        emsg.setMailTo(to);
        emsg.setSubject(ev.getSummary());
        IcalTranslator trans = new IcalTranslator((IcalCallback)new IcalCallbackcb(request.getClient()));
        Calendar cal = trans.toIcal(ei, 1);
        this.mailMessage(emsg, cal.toString(), "event.ics", "text/calendar", request.getClient());
        form.getMsg().emit("org.bedework.client.message.mailed.event");
        return 0;
    }

    private void mailMessage(Message val, String att, String name, String type, Client cl) throws Throwable {
        ObjectAttachment oa = new ObjectAttachment();
        oa.setOriginalName(name);
        oa.setVal((Object)att);
        oa.setMimeType(type);
        val.addAttachment((Attachment)oa);
        if (val.getFrom() == null) {
            val.setFrom("donotreply-" + cl.getSystemProperties().getSystemid());
        }
        cl.postMessage(val);
    }
}

