/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.webcommon.event;

import java.util.Collection;
import java.util.Date;
import org.bedework.appcommon.EventFormatter;
import org.bedework.appcommon.EventKey;
import org.bedework.appcommon.client.Client;
import org.bedework.appcommon.client.IcalCallbackcb;
import org.bedework.calfacade.BwEvent;
import org.bedework.calfacade.svc.EventInfo;
import org.bedework.icalendar.IcalCallback;
import org.bedework.icalendar.IcalTranslator;
import org.bedework.icalendar.RecurRuleComponents;
import org.bedework.util.timezones.DateTimeUtil;
import org.bedework.util.timezones.Timezones;
import org.bedework.webcommon.BwActionFormBase;
import org.bedework.webcommon.BwModuleState;
import org.bedework.webcommon.BwRequest;
import org.bedework.webcommon.event.EventActionBase;

public class RenderEventAction
extends EventActionBase {
    @Override
    public int doAction(BwRequest request, BwActionFormBase form) throws Throwable {
        BwModuleState mstate = request.getModule().getState();
        EventKey ekey = form.getEventKey();
        if (ekey == null) {
            request.getErr().emit("org.bedework.client.error.unknown.event", (Object)"No key supplied");
            return 9;
        }
        EventInfo ei = this.findEvent(request, ekey);
        if (ei == null) {
            return 9;
        }
        form.setEventInfo(ei, false);
        Client cl = request.getClient();
        BwEvent ev = ei.getEvent();
        if (ev.getRrules() != null) {
            Collection rrcs = RecurRuleComponents.fromEventRrules((BwEvent)ev);
            form.setRruleComponents(rrcs);
        } else {
            form.setRruleComponents(null);
        }
        EventFormatter ef = new EventFormatter(cl, new IcalTranslator((IcalCallback)new IcalCallbackcb(cl)), ei);
        form.setCurEventFmt(ef);
        if (ev.getScheduleMethod() != 3) {
            String cur = mstate.getViewMcDate().getDateDigits();
            Date evdt = DateTimeUtil.fromISODateTimeUTC((String)ev.getDtstart().getDate());
            String evst = DateTimeUtil.isoDate((Date)evdt).substring(0, 8);
            if (this.debug) {
                this.debugMsg("******* evdt=" + evdt + " evst=" + evst + " default tz=" + Timezones.getThreadDefaultTzid());
            }
            evdt = DateTimeUtil.fromISODateTimeUTC((String)ev.getDtend().getDate());
            String evend = DateTimeUtil.isoDate((Date)evdt).substring(0, 8);
            if (cur.compareTo(evst) < 0 || cur.compareTo(evend) > 0) {
                this.setViewDate(request, evst);
            }
        }
        if (ev.getScheduleMethod() != 0) {
            form.setMeetingCal(cl.getCollection(ev.getColPath()));
        }
        return 0;
    }
}

