/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.webcommon.event;

import net.fortuna.ical4j.model.Parameter;
import net.fortuna.ical4j.model.ParameterList;
import net.fortuna.ical4j.model.parameter.Related;
import net.fortuna.ical4j.model.property.Trigger;
import org.bedework.appcommon.client.Client;
import org.bedework.calfacade.BwAlarm;
import org.bedework.calfacade.BwAttendee;
import org.bedework.calfacade.BwEvent;
import org.bedework.calfacade.svc.EventInfo;
import org.bedework.util.misc.Util;
import org.bedework.webcommon.BwAbstractAction;
import org.bedework.webcommon.BwActionFormBase;
import org.bedework.webcommon.BwRequest;
import org.bedework.webcommon.EventState;

public class SetAlarmAction
extends BwAbstractAction {
    @Override
    public int doAction(BwRequest request, BwActionFormBase form) throws Throwable {
        BwEvent ev = form.getEvent();
        EventState evstate = form.getEventState();
        if (ev == null) {
            return 9;
        }
        Client cl = request.getClient();
        BwAlarm alarm = new BwAlarm();
        if (evstate.getAlarmTriggerByDate()) {
            throw new Exception("Unimplemented");
        }
        Related rel = evstate.getAlarmRelStart() ? Related.START : Related.END;
        ParameterList plist = new ParameterList();
        plist.add((Parameter)rel);
        Trigger tr = new Trigger(plist, evstate.getTriggerDuration().toString());
        tr.setValue(evstate.getTriggerDuration().toString());
        String recipient = request.getReqPar("lastEmail");
        if (!Util.present((String)recipient)) {
            recipient = cl.getPreferences().getEmail();
        }
        if (!Util.present((String)recipient)) {
            form.getErr().emit("org.bedework.client.error.mail.norecipient", 1);
            return 2;
        }
        String subject = request.getReqPar("subject");
        if (!Util.present((String)subject)) {
            subject = ev.getSummary();
        }
        alarm.setAlarmType(2);
        alarm.setTrigger(tr.getValue());
        alarm.setTriggerStart(true);
        alarm.setSummary(subject);
        alarm.setDescription(ev.getDescription());
        BwAttendee att = new BwAttendee();
        att.setAttendeeUri(cl.getCalendarAddress(recipient));
        alarm.addAttendee(att);
        alarm.setEvent(ev);
        alarm.setOwnerHref(cl.getCurrentPrincipalHref());
        ev.addAlarm(alarm);
        cl.updateEvent(new EventInfo(ev), true, null);
        form.getMsg().emit("org.bedework.client.message.set.alarm");
        request.setRequestAttr("bw_event_state", evstate);
        return 0;
    }
}

