/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.webcommon.event;

import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.servlet.http.HttpServletResponse;
import org.bedework.appcommon.client.Client;
import org.bedework.calfacade.BwCategory;
import org.bedework.calfacade.BwEvent;
import org.bedework.calfacade.BwXproperty;
import org.bedework.calfacade.RecurringRetrievalMode;
import org.bedework.calfacade.exc.CalFacadeException;
import org.bedework.calfacade.svc.BwAdminGroup;
import org.bedework.calfacade.svc.EventInfo;
import org.bedework.calfacade.util.ChangeTable;
import org.bedework.calfacade.util.ChangeTableEntry;
import org.bedework.sysevents.events.SysEventBase;
import org.bedework.sysevents.events.publicAdmin.EntitySuggestedResponseEvent;
import org.bedework.util.calendar.PropertyIndex;
import org.bedework.util.misc.Util;
import org.bedework.webcommon.BwActionFormBase;
import org.bedework.webcommon.BwRequest;
import org.bedework.webcommon.event.EventActionBase;

public class SuggestAction
extends EventActionBase {
    @Override
    public int doAction(BwRequest request, BwActionFormBase form) throws Throwable {
        Client cl = request.getClient();
        HttpServletResponse response = request.getResponse();
        boolean publicAdmin = cl.getPublicAdmin();
        if (cl.isGuest() || !publicAdmin || !form.getCurUserApproverUser()) {
            response.setStatus(403);
            return 47;
        }
        EventInfo ei = this.findEvent(request, RecurringRetrievalMode.Rmode.overrides);
        if (ei == null) {
            response.setStatus(404);
            return 47;
        }
        BwEvent ev = ei.getEvent();
        boolean accept = request.present("accept");
        boolean reject = request.present("reject");
        if (reject && accept || !reject && !accept) {
            form.getErr().emit("org.bedework.client.error.badrequest");
            response.setStatus(400);
            return 47;
        }
        String csHref = form.getCurrentCalSuite().getGroup().getPrincipalRef();
        List props = ev.getXproperties("X-BEDEWORK-SUGGESTED-TO");
        if (Util.isEmpty((Collection)props)) {
            form.getErr().emit("org.bedework.client.error.not.suggested");
            response.setStatus(304);
            return 47;
        }
        BwXproperty theProp = null;
        BwEvent.SuggestedTo st = null;
        for (BwXproperty prop : props) {
            st = new BwEvent.SuggestedTo(prop.getValue());
            if (!st.getGroupHref().equals(csHref)) continue;
            theProp = prop;
            break;
        }
        if (theProp == null) {
            form.getErr().emit("org.bedework.client.error.not.suggested");
            response.setStatus(304);
            return 47;
        }
        ChangeTable changes = ei.getChangeset(cl.getCurrentPrincipalHref());
        char newStatus = accept ? (char)'A' : 'R';
        String newSt = new BwEvent.SuggestedTo(newStatus, st.getGroupHref(), st.getSuggestedByHref()).toString();
        theProp.setValue(newSt);
        ChangeTableEntry xpCte = changes.getEntry(PropertyIndex.PropertyInfoIndex.XPROP);
        xpCte.addChangedValue((Object)theProp);
        Set catuids = cl.getCalsuitePreferences().getDefaultCategoryUids();
        ChangeTableEntry catCte = changes.getEntry(PropertyIndex.PropertyInfoIndex.CATEGORIES);
        if (this.debug) {
            this.debugMsg("About to add " + catuids.size() + " categories");
        }
        for (String uid : catuids) {
            BwCategory cat = cl.getPersistentCategory(uid);
            if (cat != null) {
                if (this.debug) {
                    this.debugMsg("Found " + cat.getWordVal());
                }
                if (accept) {
                    ev.addCategory(cat);
                    catCte.addAddedValue((Object)cat);
                    continue;
                }
                ev.removeCategory(cat);
                catCte.addRemovedValue((Object)cat);
                continue;
            }
            this.warn("Default category uid " + uid + " is missing");
        }
        try {
            cl.updateEvent(ei, true, null, true);
        }
        catch (CalFacadeException cfe) {
            cl.rollback();
            throw cfe;
        }
        BwAdminGroup grp = (BwAdminGroup)cl.getAdminGroup(st.getSuggestedByHref());
        if (grp == null) {
            this.warn("Unable to locate group " + st.getSuggestedByHref());
        } else {
            EntitySuggestedResponseEvent esre = new EntitySuggestedResponseEvent(SysEventBase.SysCode.SUGGESTED_RESPONSE, cl.getCurrentPrincipalHref(), ev.getCreatorHref(), ev.getHref(), null, grp.getOwnerHref(), accept);
            cl.postNotification((SysEventBase)esre);
        }
        response.setStatus(204);
        response.setContentLength(0);
        return 47;
    }
}

