/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.webcommon.event;

import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import net.fortuna.ical4j.model.Dur;
import net.fortuna.ical4j.model.Recur;
import org.apache.struts.upload.FormFile;
import org.bedework.access.Acl;
import org.bedework.appcommon.AccessXmlUtil;
import org.bedework.appcommon.TimeView;
import org.bedework.appcommon.client.Client;
import org.bedework.appcommon.client.IcalCallbackcb;
import org.bedework.calfacade.BwAttendee;
import org.bedework.calfacade.BwContact;
import org.bedework.calfacade.BwDateTime;
import org.bedework.calfacade.BwEvent;
import org.bedework.calfacade.BwEventObj;
import org.bedework.calfacade.BwLocation;
import org.bedework.calfacade.BwXproperty;
import org.bedework.calfacade.base.BwShareableDbentity;
import org.bedework.calfacade.base.CategorisedEntity;
import org.bedework.calfacade.exc.CalFacadeException;
import org.bedework.calfacade.exc.ValidationError;
import org.bedework.calfacade.responses.Response;
import org.bedework.calfacade.svc.BwAdminGroup;
import org.bedework.calfacade.svc.EventInfo;
import org.bedework.calfacade.svc.wrappers.BwCalSuiteWrapper;
import org.bedework.calfacade.util.CalFacadeUtil;
import org.bedework.calfacade.util.ChangeTable;
import org.bedework.calfacade.util.ChangeTableEntry;
import org.bedework.calsvci.EventsI;
import org.bedework.icalendar.IcalCallback;
import org.bedework.icalendar.IcalTranslator;
import org.bedework.icalendar.Icalendar;
import org.bedework.sysevents.events.SysEventBase;
import org.bedework.sysevents.events.publicAdmin.EntityApprovalNeededEvent;
import org.bedework.sysevents.events.publicAdmin.EntityApprovalResponseEvent;
import org.bedework.sysevents.events.publicAdmin.EntitySuggestedEvent;
import org.bedework.util.calendar.PropertyIndex;
import org.bedework.util.misc.Util;
import org.bedework.util.timezones.DateTimeUtil;
import org.bedework.util.timezones.Timezones;
import org.bedework.webcommon.Attendees;
import org.bedework.webcommon.BwAbstractAction;
import org.bedework.webcommon.BwActionFormBase;
import org.bedework.webcommon.BwRequest;
import org.bedework.webcommon.BwWebUtil;
import org.bedework.webcommon.TimeDateComponents;
import org.bedework.webcommon.event.EventActionBase;

public class UpdateEventAction
extends EventActionBase {
    private static final String alwaysRemove1 = "BEGIN:VEVENT\r\nUID:123456\r\nDTSTART;TYPE=DATE:20080212T000000\r\n";
    private static final String alwaysRemove2 = "BEGIN:VEVENT\nUID:123456\nDTSTART;TYPE=DATE:20080212T000000\n";
    private static HashMap<String, String> validFreq = new HashMap();

    @Override
    public int doAction(BwRequest request, BwActionFormBase form) throws Throwable {
        Set rrules;
        List xps;
        int res;
        Client cl = request.getClient();
        boolean publicAdmin = cl.getPublicAdmin();
        boolean submitApp = form.getSubmitApp();
        String submitterEmail = null;
        boolean sendInvitations = request.present("submitAndSend");
        boolean publishEvent = request.present("publishEvent");
        boolean updateSubmitEvent = request.present("updateSubmitEvent");
        boolean approveEvent = request.present("approveEvent");
        boolean awaitingApprovalEvent = false;
        if (publicAdmin && !form.getAuthorisedUser() || form.getGuest()) {
            cl.rollback();
            return 4;
        }
        if (approveEvent && !form.getCurUserApproverUser()) {
            cl.rollback();
            return 4;
        }
        if (request.present("access")) {
            cl.rollback();
            return 4;
        }
        EventInfo ei = form.getEventInfo();
        BwEvent ev = ei.getEvent();
        if (ev == null) {
            return 9;
        }
        boolean eventOWner = false;
        if (!publicAdmin) {
            eventOWner = true;
        } else {
            boolean bl = eventOWner = form.getAddingEvent() || cl.isCalSuiteEntity((BwShareableDbentity)ev);
        }
        if ((publishEvent || approveEvent) && ev.getRecurrenceId() != null) {
            cl.rollback();
            return 3;
        }
        ChangeTable changes = ei.getChangeset(cl.getCurrentPrincipalHref());
        if (request.hasCopy()) {
            request.getErr().emit("copy no longer supported - use fetch action");
            return 3;
        }
        if (request.present("editEventAttendees")) {
            int res2 = this.initMeeting(request, form, true);
            if (res2 != 0) {
                return res2;
            }
            return 39;
        }
        if (request.present("makeEventIntoMeeting")) {
            int res3 = this.initMeeting(request, form, true);
            if (res3 != 0) {
                return res3;
            }
            return 40;
        }
        if (request.present("initDates")) {
            ev.setDtstart(request.getDateTime("meetingStartdt", "meetingStartTzid"));
            ev.setDuration("P" + request.getReqPar("meetingDuration") + "M");
            ev.setDtend(ev.getDtstart().addDur(new Dur(ev.getDuration())));
            ev.setEndType('D');
            form.getEventDates().setFromEvent(ev);
            return 41;
        }
        boolean adding = form.getAddingEvent();
        if (request.hasDelete()) {
            form.assignMarkDeleted(false);
            return 18;
        }
        if (request.hasMarkDeleted()) {
            form.assignMarkDeleted(true);
            return 18;
        }
        if (cl.isSuperUser() && ev.getDeleted() && !request.present("deleted")) {
            changes.changed(PropertyIndex.PropertyInfoIndex.DELETED, (Object)true, (Object)false);
            ev.setDeleted(false);
        }
        String submissionsRoot = form.getConfig().getSubmissionRoot();
        String workflowRoot = cl.getSystemProperties().getWorkflowRoot();
        String unindexLocation = null;
        if (!adding) {
            unindexLocation = ev.getHref();
        }
        String preserveColPath = ev.getColPath();
        this.setEventText(request, ev, adding, changes);
        ArrayList<BwXproperty> extras = new ArrayList<BwXproperty>();
        FormFile ff = form.getEventImageUpload();
        if (ff != null && ff.getFileSize() > 0) {
            BwAbstractAction.ProcessedImage pi = this.processImage(request, ff);
            if (!pi.OK) {
                if (!pi.retry) {
                    cl.rollback();
                    return 17;
                }
                this.restore(ev, preserveColPath);
                return 2;
            }
            BwXproperty imageXp = new BwXproperty();
            imageXp.setName("X-BEDEWORK-IMAGE");
            imageXp.setValue(pi.image.getColPath() + "/" + pi.image.getName());
            extras.add(imageXp);
            imageXp = new BwXproperty();
            imageXp.setName("X-BEDEWORK-THUMB-IMAGE");
            imageXp.setValue(pi.thumbnail.getColPath() + "/" + pi.thumbnail.getName());
            extras.add(imageXp);
        }
        if ((res = this.processXprops(request, ev, extras, publishEvent, changes)) == 17) {
            cl.rollback();
            return res;
        }
        if ((publishEvent || updateSubmitEvent) && !Util.isEmpty((Collection)(xps = ev.getXproperties("X-BEDEWORK-SUBMITTER-EMAIL")))) {
            submitterEmail = ((BwXproperty)xps.get(0)).getValue();
        }
        List<BwEvent.SuggestedTo> suggestedTo = null;
        if (eventOWner) {
            suggestedTo = this.doSuggested(request, ev, changes);
        }
        if ((res = form.getEventDates().updateEvent(ei)) == 17) {
            cl.rollback();
            return res;
        }
        if (!BwWebUtil.validateEventDates(request, ei)) {
            this.restore(ev, preserveColPath);
            return 2;
        }
        ev.setCalSuite(form.getCalSuiteName());
        if (publicAdmin) {
            if (!this.adminEventLocation(request, ei)) {
                this.restore(ev, preserveColPath);
                return 2;
            }
        } else {
            this.setEventLocation(request, ei, form, submitApp);
        }
        try {
            if (!this.setEventContact(request, submitApp)) {
                this.restore(ev, preserveColPath);
                return 2;
            }
        }
        catch (CalFacadeException cfe) {
            cl.rollback();
            request.getErr().emit("org.bedework.client.error.badrequest", (Object)cfe.getExtra());
            return 2;
        }
        Set cats = null;
        if (cl.getPublicAdmin() || request.getBwForm().getSubmitApp()) {
            EventsI.RealiasResult resp = cl.reAlias(ev);
            if (resp.getStatus() != Response.Status.ok) {
                if (this.debug) {
                    this.debugMsg("Failed to get topical areas? " + resp);
                }
                cl.rollback();
                form.getErr().emit("org.bedework.validation.error.missingtopicalarea");
                this.restore(ev, preserveColPath);
                return 2;
            }
            cats = resp.getCats();
            if (publicAdmin && !updateSubmitEvent && Util.isEmpty((Collection)cats)) {
                if (this.debug) {
                    this.debugMsg("No topical areas? " + resp);
                }
                form.getErr().emit("org.bedework.validation.error.missingtopicalarea");
                this.restore(ev, preserveColPath);
                return 2;
            }
        }
        BwAbstractAction.SetEntityCategoriesResult secr = this.setEntityCategories(request, cats, (CategorisedEntity)ev, changes);
        if (secr.rcode != 0) {
            cl.rollback();
            return secr.rcode;
        }
        String link = Util.checkNull((String)form.getEventLink());
        if (link != null && Util.validURI((String)link) == null) {
            form.getErr().emit("org.bedework.validation.error.invalid.uri");
            this.restore(ev, preserveColPath);
            return 2;
        }
        if (!Util.equalsString((String)ev.getLink(), (String)link)) {
            changes.changed(PropertyIndex.PropertyInfoIndex.URL, (Object)ev.getLink(), (Object)link);
            ev.setLink(link);
        }
        String cost = Util.checkNull((String)form.getEventCost());
        if (!Util.equalsString((String)ev.getCost(), (String)cost)) {
            changes.changed(PropertyIndex.PropertyInfoIndex.COST, (Object)ev.getCost(), (Object)cost);
            ev.setCost(cost);
        }
        String transp = Util.checkNull((String)form.getTransparency());
        if (!Util.equalsString((String)ev.getTransparency(), (String)transp)) {
            changes.changed(PropertyIndex.PropertyInfoIndex.TRANSP, (Object)ev.getTransparency(), (Object)transp);
            ev.setTransparency(transp);
        }
        ev.setPublick(Boolean.valueOf(publicAdmin));
        String fStatus = form.getEventStatus();
        if (!Util.equalsString((String)fStatus, (String)ev.getStatus())) {
            changes.changed(PropertyIndex.PropertyInfoIndex.STATUS, (Object)ev.getStatus(), (Object)fStatus);
            ev.setStatus(fStatus);
        }
        Attendees atts = form.getAttendees();
        ChangeTableEntry cte = changes.getEntry(PropertyIndex.PropertyInfoIndex.ATTENDEE);
        if (adding) {
            ev.setAttendees(atts.getAttendees());
        }
        if (atts.getAddedAttendees() != null) {
            for (BwAttendee att : atts.getAddedAttendees()) {
                cte.addAddedValue((Object)att);
            }
        }
        if (atts.getDeletedAttendees() != null) {
            for (BwAttendee att : atts.getDeletedAttendees()) {
                cte.addRemovedValue((Object)att);
            }
        }
        if (request.getErrFlag()) {
            this.restore(ev, preserveColPath);
            return 2;
        }
        if (request.getBooleanReqPar("recurring", false)) {
            String rrule = this.getRrule(request, form);
            ArrayList oldRrules = null;
            if (form.getErrorsEmitted()) {
                cl.rollback();
                return 17;
            }
            if (rrule != null) {
                boolean rruleChanged;
                Set rrules2 = ev.getRrules();
                if (rrules2 == null) {
                    TreeSet<String> newRrules = new TreeSet<String>();
                    newRrules.add(rrule);
                    ev.setRrules(newRrules);
                    rruleChanged = true;
                } else if (rrules2.size() == 0) {
                    rruleChanged = true;
                } else if (rrules2.size() > 1) {
                    oldRrules = new ArrayList(rrules2);
                    rrules2.clear();
                    rruleChanged = true;
                } else {
                    String oldRrule = (String)rrules2.iterator().next();
                    boolean bl = rruleChanged = !rrule.equals(oldRrule);
                    if (rruleChanged) {
                        oldRrules = new ArrayList(rrules2);
                        rrules2.clear();
                    }
                }
                if (rruleChanged) {
                    ev.addRrule(rrule);
                    cte = changes.getEntry(PropertyIndex.PropertyInfoIndex.RRULE);
                    cte.setChanged(oldRrules, (Object)ev.getRrules());
                    cte.setRemovedValues(oldRrules);
                    cte.setAddedValues(new TreeSet(ev.getRrules()));
                }
            }
            ev.setRecurring(Boolean.valueOf(ev.isRecurringEntity()));
        } else if (ev.getRecurring() == null) {
            ev.setRecurring(Boolean.valueOf(false));
        } else if (ev.testRecurring() && !Util.isEmpty((Collection)(rrules = ev.getRrules()))) {
            cte = changes.getEntry(PropertyIndex.PropertyInfoIndex.RRULE);
            cte.setChanged((Object)rrules, null);
            cte.setRemovedValues(new ArrayList(rrules));
            rrules.clear();
        }
        boolean evDateOnly = false;
        if (!form.getAddingEvent()) {
            evDateOnly = ev.getDtstart().getDateType();
        } else if (!request.present("initDates")) {
            evDateOnly = form.getEventDates().getStartDate().getDateOnly();
        }
        this.updateRExdates(request, ev, evDateOnly, changes);
        List<ValidationError> ves = BwWebUtil.validateEvent(cl, updateSubmitEvent || submitApp, publicAdmin, ev);
        if (ves != null) {
            for (ValidationError ve : ves) {
                form.getErr().emit(ve.getErrorCode(), (Object)ve.getExtra());
            }
            this.restore(ev, preserveColPath);
            return 2;
        }
        if (!request.setEventCalendar(ei, changes)) {
            return 2;
        }
        String colPath = ev.getColPath();
        if (publishEvent) {
            if (colPath.startsWith(submissionsRoot)) {
                form.getErr().emit("org.bedework.validation.error.insubmissionscalendar");
                cl.rollback();
                return 17;
            }
        } else if (approveEvent) {
            if (colPath.startsWith(workflowRoot)) {
                form.getErr().emit("org.bedework.validation.error.insubmissionscalendar");
                this.restore(ev, preserveColPath);
                cl.rollback();
                return 17;
            }
            if (ev.getRecurring().booleanValue() && !preserveColPath.equals(colPath) && ei.getOverrideProxies() != null) {
                for (BwEvent oev : ei.getOverrideProxies()) {
                    oev.setColPath(ev.getColPath());
                }
            }
        } else if (updateSubmitEvent) {
            if (!colPath.startsWith(submissionsRoot)) {
                form.getErr().emit("org.bedework.validation.error.notsubmissionscalendar");
                cl.rollback();
                return 17;
            }
        } else if (workflowRoot != null && colPath.startsWith(workflowRoot)) {
            awaitingApprovalEvent = adding;
        }
        if (publishEvent) {
            this.copyEntities(ev);
            this.changeOwner(ev, cl);
            changes.changed(PropertyIndex.PropertyInfoIndex.CREATOR, null, (Object)ev.getCreatorHref());
            if (ev.getRecurring().booleanValue() && ei.getOverrideProxies() != null) {
                for (BwEvent oev : ei.getOverrideProxies()) {
                    this.copyEntities(oev);
                    this.changeOwner(oev, cl);
                    oev.setColPath(ev.getColPath());
                }
            }
        }
        if (ev.getColPath() == null) {
            form.getErr().emit("org.bedework.validation.error.missingcalendar");
            cl.rollback();
            return 17;
        }
        if (this.debug) {
            this.debugMsg(changes.toString());
        }
        try {
            ei.setNewEvent(adding);
            EventInfo.UpdateResult ur = adding ? cl.addEvent(ei, !sendInvitations, true) : cl.updateEvent(ei, !sendInvitations, null);
            if (ur != null && ur.schedulingResult != null) {
                this.emitScheduleStatus(form, ur.schedulingResult, false);
            }
            form.assignAddingEvent(false);
            String aclStr = request.getReqPar("acl");
            if (aclStr != null) {
                Acl acl = new AccessXmlUtil(null, cl).getAcl(aclStr, true);
                cl.changeAccess((BwShareableDbentity)ev, acl.getAces(), true);
            }
            if (!adding && !unindexLocation.equals(ev.getHref())) {
                cl.unindex(unindexLocation);
            }
        }
        catch (CalFacadeException cfe) {
            cl.rollback();
            if ("org.bedework.exception.norecurrenceinstances".equals(cfe.getMessage())) {
                form.getErr().emit("org.bedework.client.error.norecurrenceinstances", (Object)ev.getUid());
                return 17;
            }
            if ("org.bedework.exception.duplicateguid".equals(cfe.getMessage())) {
                form.getErr().emit("org.bedework.client.error.duplicateuid");
                return 16;
            }
            throw cfe;
        }
        if ((publishEvent || updateSubmitEvent) && request.getBooleanReqPar("submitNotification", false)) {
            this.notifySubmitter(request, ei, submitterEmail);
        }
        if (approveEvent || awaitingApprovalEvent) {
            BwCalSuiteWrapper cs = cl.getCalSuite();
            String csHref = cs != null ? cs.getGroup().getOwnerHref() : null;
            Object sev = approveEvent ? new EntityApprovalResponseEvent(SysEventBase.SysCode.APPROVAL_STATUS, cl.getCurrentPrincipalHref(), ev.getCreatorHref(), ev.getHref(), null, true, null, csHref) : new EntityApprovalNeededEvent(SysEventBase.SysCode.APPROVAL_NEEDED, cl.getCurrentPrincipalHref(), ev.getCreatorHref(), ev.getHref(), null, null, csHref);
            cl.postNotification((SysEventBase)sev);
        }
        if (!Util.isEmpty(suggestedTo)) {
            for (BwEvent.SuggestedTo st : suggestedTo) {
                BwAdminGroup grp = (BwAdminGroup)cl.getAdminGroup(st.getGroupHref());
                if (grp == null) {
                    this.warn("Unable to locate group " + st.getGroupHref());
                    continue;
                }
                EntitySuggestedEvent ese = new EntitySuggestedEvent(SysEventBase.SysCode.SUGGESTED, cl.getCurrentPrincipalHref(), ev.getCreatorHref(), ev.getHref(), null, grp.getOwnerHref());
                cl.postNotification((SysEventBase)ese);
            }
        }
        if (publicAdmin) {
            BwXproperty evregprop = ev.findXproperty("X-BEDEWORK-REGISTRATION-START");
            if (evregprop != null) {
                this.notifyEventReg(request, ei);
            }
            this.resetEvent(request);
        } else {
            request.refresh();
        }
        if (adding) {
            ev = new BwEventObj();
            form.getEventDates().setNewEvent(ev);
            TimeView tv = request.getSess().getCurTimeView(request);
            form.getEventStartDate().setDateTime(tv.getCurDayFmt().getDateTimeString());
            form.getEventEndDate().setDateTime(tv.getCurDayFmt().getDateTimeString());
            ei = new EventInfo(ev);
            form.setEventInfo(ei, true);
            if (ev.getEntityType() == 2) {
                form.getMsg().emit("org.bedework.client.message.added.tasks", 1);
            } else {
                form.getMsg().emit("org.bedework.client.message.added.events", 1);
            }
        } else if (ev.getEntityType() == 2) {
            form.getMsg().emit("org.bedework.client.message.updated.task");
        } else {
            form.getMsg().emit("org.bedework.client.message.updated.event");
        }
        cl.clearSearchEntries();
        return 0;
    }

    private void restore(BwEvent ev, String preserveColPath) throws Throwable {
        if (preserveColPath == null) {
            return;
        }
        if (!preserveColPath.equals(ev.getColPath())) {
            ev.setColPath(preserveColPath);
        }
    }

    private List<BwEvent.SuggestedTo> doSuggested(BwRequest request, BwEvent ev, ChangeTable changes) throws Throwable {
        Client cl = request.getClient();
        if (!cl.getPublicAdmin() || !cl.getSystemProperties().getSuggestionEnabled()) {
            return null;
        }
        ArrayList<BwEvent.SuggestedTo> suggestedTo = null;
        ChangeTableEntry xcte = changes.getEntry(PropertyIndex.PropertyInfoIndex.XPROP);
        List groupHrefs = request.getReqPars("groupHref");
        List alreadySuggested = ev.getXproperties("X-BEDEWORK-SUGGESTED-TO");
        BwCalSuiteWrapper cs = cl.getCalSuite();
        String csHref = cs.getGroup().getPrincipalRef();
        if (groupHrefs == null) {
            if (!Util.isEmpty((Collection)alreadySuggested)) {
                for (BwXproperty xp : alreadySuggested) {
                    ev.removeXproperty(xp);
                    xcte.addRemovedValue((Object)xp);
                }
            }
            return suggestedTo;
        }
        TreeSet<String> hrefsPresent = new TreeSet<String>();
        HashMap<String, BwXproperty> toRemove = new HashMap<String, BwXproperty>(alreadySuggested.size());
        for (BwXproperty as : alreadySuggested) {
            String href = new BwEvent.SuggestedTo(as.getValue()).getGroupHref();
            hrefsPresent.add(href);
            toRemove.put(href, as);
        }
        TreeSet deDuped = new TreeSet(groupHrefs);
        for (String groupHref : deDuped) {
            if (!hrefsPresent.contains(groupHref)) {
                BwEvent.SuggestedTo sto = new BwEvent.SuggestedTo('P', groupHref, csHref);
                BwXproperty grpXp = new BwXproperty("X-BEDEWORK-SUGGESTED-TO", null, sto.toString());
                ev.addXproperty(grpXp);
                xcte.addAddedValue((Object)grpXp);
                if (suggestedTo == null) {
                    suggestedTo = new ArrayList<BwEvent.SuggestedTo>();
                }
                suggestedTo.add(sto);
            } else {
                toRemove.remove(groupHref);
            }
            cl.getPreferences().addPreferredGroup(groupHref);
        }
        if (!Util.isEmpty(toRemove.values())) {
            for (BwXproperty xp : toRemove.values()) {
                ev.removeXproperty(xp);
                xcte.addRemovedValue((Object)xp);
            }
        }
        return suggestedTo;
    }

    private void changeOwner(BwEvent ev, Client cl) throws CalFacadeException {
        cl.claimEvent(ev);
        ev.setCreatorHref(cl.getCurrentPrincipalHref());
    }

    private void copyEntities(BwEvent ev) throws CalFacadeException {
        BwContact contact;
        BwLocation loc = ev.getLocation();
        if (loc != null && !loc.getPublick().booleanValue()) {
            loc = (BwLocation)loc.clone();
            loc.setOwnerHref(null);
            loc.setCreatorHref(null);
            loc.setPublick(Boolean.valueOf(true));
            ev.setLocation(loc);
        }
        if ((contact = ev.getContact()) != null && !contact.getPublick().booleanValue()) {
            contact = (BwContact)contact.clone();
            contact.setOwnerHref(null);
            contact.setCreatorHref(null);
            contact.setPublick(Boolean.valueOf(true));
            ev.setLocation(loc);
            ev.setContact(contact);
        }
    }

    private boolean updateRExdates(BwRequest request, BwEvent event, boolean evDateOnly, ChangeTable changes) throws Throwable {
        Collection<BwDateTime> reqDates = request.getRdates(evDateOnly);
        TreeSet evDates = new TreeSet();
        if (event.getRdates() != null) {
            evDates.addAll(event.getRdates());
        }
        Collection<Object> added = null;
        TreeSet removed = null;
        boolean rdChanged = false;
        if (reqDates.isEmpty()) {
            if (!Util.isEmpty(evDates)) {
                removed = evDates;
                event.getRdates().clear();
                rdChanged = true;
            }
        } else if (Util.isEmpty(evDates)) {
            for (BwDateTime bwDateTime : reqDates) {
                event.addRdate(bwDateTime);
            }
            added = reqDates;
            event.setRecurring(Boolean.valueOf(true));
            rdChanged = true;
        } else {
            added = new TreeSet();
            removed = new TreeSet();
            rdChanged = CalFacadeUtil.updateCollection((boolean)false, reqDates, (Collection)event.getRdates(), added, removed);
        }
        if (rdChanged) {
            ChangeTableEntry cte = changes.getEntry(PropertyIndex.PropertyInfoIndex.RDATE);
            cte.setChanged(evDates, (Object)event.getRdates());
            cte.setRemovedValues(removed);
            cte.setAddedValues(added);
        }
        boolean exdChanged = false;
        evDates.clear();
        if (event.getExdates() != null) {
            evDates.addAll(event.getExdates());
        }
        added = null;
        removed = null;
        reqDates = request.getExdates(evDateOnly);
        if (Util.isEmpty(reqDates)) {
            if (!Util.isEmpty(evDates)) {
                removed = evDates;
                event.getExdates().clear();
                exdChanged = true;
            }
        } else if (Util.isEmpty(evDates)) {
            for (BwDateTime dt : reqDates) {
                event.addExdate(dt);
            }
            added = reqDates;
            exdChanged = true;
        } else {
            added = new TreeSet();
            removed = new TreeSet();
            exdChanged = CalFacadeUtil.updateCollection((boolean)false, reqDates, (Collection)event.getExdates(), added, removed);
        }
        if (exdChanged) {
            ChangeTableEntry changeTableEntry = changes.getEntry(PropertyIndex.PropertyInfoIndex.EXDATE);
            changeTableEntry.setChanged(evDates, (Object)event.getExdates());
            changeTableEntry.setRemovedValues(removed);
            changeTableEntry.setAddedValues(added);
        }
        return rdChanged || exdChanged;
    }

    private int processXprops(BwRequest request, BwEvent event, List<BwXproperty> extras, boolean publishEvent, ChangeTable changes) throws Throwable {
        ChangeTableEntry cte = changes.getEntry(PropertyIndex.PropertyInfoIndex.XPROP);
        List unparsedxps = request.getReqPars("xproperty");
        ArrayList added = null;
        ArrayList<BwXproperty> removed = null;
        List<BwXproperty> xprops = null;
        ArrayList evxprops = new ArrayList();
        if (!Util.isEmpty((Collection)event.getXproperties())) {
            evxprops.addAll(event.getXproperties());
        }
        if (unparsedxps != null) {
            xprops = this.parseXprops(request, false);
        }
        if (!Util.isEmpty(extras)) {
            if (xprops == null) {
                xprops = extras;
            } else {
                xprops.addAll(extras);
            }
        }
        if (Util.isEmpty(xprops)) {
            if (Util.isEmpty(evxprops)) {
                return 9;
            }
            for (BwXproperty xp : evxprops) {
                if (xp.getSkipJsp() && (!xp.getName().equals("X-BEDEWORK-ICAL") || xp.getValue() == null || !xp.getValue().startsWith(alwaysRemove1) && !xp.getValue().startsWith(alwaysRemove2))) continue;
                if (removed == null) {
                    removed = new ArrayList();
                }
                removed.add(xp);
            }
            if (removed != null) {
                cte.setChanged(evxprops, (Object)event.getXproperties());
                cte.setRemovedValues(removed);
            }
            return 0;
        }
        if (Util.isEmpty(evxprops)) {
            if (event.getXproperties() == null) {
                event.setXproperties(new ArrayList<BwXproperty>(xprops));
            } else {
                event.getXproperties().addAll(xprops);
            }
            cte.setChanged(evxprops, new ArrayList(event.getXproperties()));
            cte.setAddedValues(xprops);
            if (removed != null) {
                cte.setRemovedValues(removed);
            }
            return 0;
        }
        for (BwXproperty xp : evxprops) {
            if (!xp.getSkipJsp() || xp.getName().equals("X-BEDEWORK-ICAL") && xp.getValue() != null && (xp.getValue().startsWith(alwaysRemove1) || xp.getValue().startsWith(alwaysRemove2))) continue;
            xprops.add(xp);
        }
        added = new ArrayList();
        if (removed == null) {
            removed = new ArrayList<BwXproperty>();
        }
        if (CalFacadeUtil.updateCollection((boolean)true, xprops, (Collection)event.getXproperties(), added, removed)) {
            cte.setChanged(evxprops, new ArrayList(event.getXproperties()));
            cte.setAddedValues(added);
            cte.setRemovedValues(removed);
            return 0;
        }
        return 9;
    }

    private List<BwXproperty> parseXprops(BwRequest request, boolean publishEvent) throws Throwable {
        List unparsedxps = request.getReqPars("xproperty");
        if (unparsedxps == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("BEGIN:VCALENDAR\nVERSION:2.0\nPRODID:-//xyz.com//EN\nBEGIN:VEVENT\nUID:123456\nDTSTART;TYPE=DATE:20080212\n");
        for (String unparsedxp : unparsedxps) {
            String val = unparsedxp.replace("\r\n", "\\n");
            val = val.replace("\n", "\\n");
            val = val.replace("\r", "\\n");
            sb.append(val);
            sb.append("\n");
        }
        sb.append("END:VEVENT\nEND:VCALENDAR\n");
        Client cl = request.getClient();
        IcalTranslator trans = new IcalTranslator((IcalCallback)new IcalCallbackcb(cl));
        Icalendar c = trans.fromIcal(null, (Reader)new StringReader(sb.toString()));
        BwEvent ev = c.getEventInfo().getEvent();
        List xprops = ev.getXproperties();
        ArrayList<BwXproperty> strippedXprops = new ArrayList<BwXproperty>();
        if (!publishEvent) {
            for (BwXproperty xp : xprops) {
                if (xp.getSkipJsp() || xp.getName().equals("X-BEDEWORK-SUGGESTED-TO")) continue;
                strippedXprops.add(xp);
            }
            return strippedXprops;
        }
        HashMap<String, String> plistMap = new HashMap<String, String>();
        for (String plistName : request.getReqPars("xprop-preserve")) {
            plistMap.put(plistName, plistName);
        }
        for (BwXproperty xp : xprops) {
            if (plistMap.get(xp.getName()) == null) continue;
            strippedXprops.add(xp);
        }
        return strippedXprops;
    }

    public String getRrule(BwRequest request, BwActionFormBase form) throws Throwable {
        StringBuilder rrule = new StringBuilder();
        String freq = request.getReqPar("freq");
        if (freq == null || "NONE".equals(freq)) {
            return null;
        }
        if (validFreq.get(freq) == null) {
            form.getErr().emit("org.bedework.bad.request", (Object)"freq");
            return null;
        }
        rrule.append("FREQ=");
        rrule.append(freq);
        Integer interval = request.getIntReqPar("interval", "org.bedework.validation.error.invalid.recurinterval");
        if (interval != null) {
            rrule.append(";INTERVAL=");
            rrule.append(interval);
        }
        Integer count = request.getIntReqPar("count", "org.bedework.validation.error.invalid.recurcount");
        String until = request.getReqPar("until");
        if (count != null && until != null) {
            form.getErr().emit("org.bedework.validation.error.invalid.recurcountanduntil");
            return null;
        }
        if (until != null) {
            TimeDateComponents start = form.getEventDates().getStartDate();
            if (DateTimeUtil.isISODate((String)until) && !start.getDateOnly()) {
                until = until + "T" + start.getDateTime().getDtval().substring(8);
            }
            if (DateTimeUtil.isISODateTime((String)until)) {
                until = Timezones.getUtc((String)until, (String)start.getTzid());
            } else if (!DateTimeUtil.isISODateTimeUTC((String)until)) {
                form.getErr().emit("org.bedework.validation.error.invalid.recuruntil", (Object)"until");
                return null;
            }
            rrule.append(";UNTIL=");
            rrule.append(until);
        }
        if (count != null) {
            if (count < 0) {
                form.getErr().emit("org.bedework.validation.error.invalid.recurcount", (Object)count);
                return null;
            }
            rrule.append(";COUNT=");
            rrule.append(count);
        }
        if (!"DAILY".equals(freq)) {
            String byday = request.getReqPar("byday");
            if (byday != null) {
                rrule.append(";BYDAY=");
                rrule.append(byday);
            }
            if (!"WEEKLY".equals(freq)) {
                String bymonthday = request.getReqPar("bymonthday");
                if (bymonthday != null) {
                    rrule.append(";BYMONTHDAY=");
                    rrule.append(bymonthday);
                }
                if (!"MONTHLY".equals(freq)) {
                    String byyearday;
                    String bymonth = request.getReqPar("bymonth");
                    if (bymonth != null) {
                        rrule.append(";BYMONTH=");
                        rrule.append(bymonth);
                    }
                    if ((byyearday = request.getReqPar("byyearday")) != null) {
                        rrule.append(";BYYEARDAY=");
                        rrule.append(byyearday);
                    }
                }
            }
        }
        String rruleStr = rrule.toString();
        try {
            new Recur(rruleStr);
        }
        catch (Throwable t) {
            form.getErr().emit("org.bedework.validation.error.invalid.recurrule");
            return null;
        }
        if (this.debug) {
            this.debugMsg(rruleStr);
        }
        return rruleStr;
    }

    static {
        validFreq.put("HOURLY", "HOURLY");
        validFreq.put("DAILY", "DAILY");
        validFreq.put("WEEKLY", "WEEKLY");
        validFreq.put("MONTHLY", "MONTHLY");
        validFreq.put("YEARLY", "YEARLY");
    }
}

