/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.webcommon.filter;

import org.bedework.appcommon.client.Client;
import org.bedework.calfacade.BwFilterDef;
import org.bedework.webcommon.BwAbstractAction;
import org.bedework.webcommon.BwActionFormBase;
import org.bedework.webcommon.BwRequest;

public class AddFilterAction
extends BwAbstractAction {
    @Override
    public int doAction(BwRequest request, BwActionFormBase form) throws Throwable {
        Client cl = request.getClient();
        if (cl.isGuest()) {
            return 4;
        }
        BwFilterDef fd = new BwFilterDef();
        fd.setName(request.getReqPar("name"));
        if (fd.getName() == null) {
            form.getErr().emit("org.bedework.validation.error.missingname");
            return 28;
        }
        if (fd.getName().length() > 100) {
            form.getErr().emit("org.bedework.validation.error.toolong.name");
            return 28;
        }
        fd.setDefinition(request.getReqPar("def"));
        if (fd.getDefinition() == null) {
            form.getErr().emit("org.bedework.validation.error.missingfilterdef");
            return 28;
        }
        fd.setDescription(request.getReqPar("desc"));
        try {
            cl.validateFilter(fd.getDefinition());
            cl.saveFilter(fd);
        }
        catch (Throwable t) {
            form.getErr().emit("org.bedework.client.error.badfilter", (Object)t.getMessage());
            return 28;
        }
        form.assignReloadRequired(true);
        return 0;
    }
}

